/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.api.session;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.session.SavingPolicy;
import org.eclipse.sirius.common.tools.api.resource.ResourceSetSync;
import org.eclipse.sirius.viewpoint.SiriusPlugin;

public abstract class AbstractSavingPolicy
implements SavingPolicy {
    protected final TransactionalEditingDomain domain;

    protected AbstractSavingPolicy(TransactionalEditingDomain domain) {
        this.domain = (TransactionalEditingDomain)Preconditions.checkNotNull((Object)domain);
    }

    @Override
    public Collection<Resource> save(Iterable<Resource> allResources, Map<?, ?> options, IProgressMonitor monitor) {
        ArrayList resourcesToSave = Lists.newArrayList();
        try {
            try {
                monitor.beginTask("Save Session", -1);
                resourcesToSave.addAll(this.computeResourcesToSave(Sets.newLinkedHashSet(allResources), options, monitor));
                if (options == null) {
                    ResourceSetSync.getOrInstallResourceSetSync((TransactionalEditingDomain)this.domain).save((Iterable)resourcesToSave, allResources, this.getDefaultSaveOptions());
                } else {
                    ResourceSetSync.getOrInstallResourceSetSync((TransactionalEditingDomain)this.domain).save((Iterable)resourcesToSave, allResources, options);
                }
            }
            catch (IOException e) {
                SiriusPlugin.getDefault().error("error while saving session", e);
                monitor.done();
            }
            catch (InterruptedException e) {
                SiriusPlugin.getDefault().error("error while saving session", e);
                monitor.done();
            }
        }
        finally {
            monitor.done();
        }
        return resourcesToSave;
    }

    protected Map<?, ?> getDefaultSaveOptions() {
        HashMap<String, Constable> defaultSaveOptions = new HashMap<String, Constable>();
        defaultSaveOptions.put("FLUSH_THRESHOLD", Integer.valueOf(0x1000000));
        defaultSaveOptions.put("USE_FILE_BUFFER", Boolean.TRUE);
        return defaultSaveOptions;
    }

    protected abstract Collection<Resource> computeResourcesToSave(Set<Resource> var1, Map<?, ?> var2, IProgressMonitor var3);
}

