/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.contribution;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.internal.contribution.Matcher;
import org.eclipse.sirius.ext.emf.AllContents;

public class Updater {
    private final EObject element;
    private final EObject reference;
    private final Matcher matcher;
    private boolean isRoot;
    private Set<EObject> orphaned;
    private List<EStructuralFeature> ignored = Collections.emptyList();

    public Updater(Matcher matcher, EObject element, EObject reference) {
        this.matcher = (Matcher)Preconditions.checkNotNull((Object)matcher);
        this.element = (EObject)Preconditions.checkNotNull((Object)element);
        this.reference = (EObject)Preconditions.checkNotNull((Object)reference);
        this.isRoot = true;
    }

    public EObject update() {
        this.orphaned = Sets.newHashSet();
        if (!this.matcher.areSameLogicalElement(this.element, this.reference)) {
            throw new IllegalArgumentException("Can not update an element using a logically different element as reference.");
        }
        if (this.element.eClass() != this.reference.eClass()) {
            String msg = MessageFormat.format("Can not update an element using a reference element of a different type. Expected {0} but got a {1}", this.element.eClass(), this.reference.eClass());
            throw new IllegalArgumentException(msg);
        }
        this.updateAttributes();
        this.updateReferences();
        if (this.isRoot) {
            this.fixReferences();
        }
        return this.element;
    }

    private void updateAttributes() {
        for (EAttribute attr : this.element.eClass().getEAllAttributes()) {
            if (!attr.isChangeable() || attr.isDerived() || this.ignored.contains(attr)) continue;
            this.updateAttribute(attr);
        }
    }

    private void updateAttribute(EAttribute attr) {
        if (this.element.eIsSet((EStructuralFeature)attr) && !this.reference.eIsSet((EStructuralFeature)attr)) {
            this.element.eUnset((EStructuralFeature)attr);
        } else if (attr.isMany()) {
            this.updateManyValuesAttribute(attr);
        } else {
            this.updateSingleValueAttribute(attr);
        }
    }

    private void updateSingleValueAttribute(EAttribute attr) {
        Object newValue;
        Object oldValue = this.element.eGet((EStructuralFeature)attr);
        if (!Objects.equal((Object)oldValue, (Object)(newValue = this.reference.eGet((EStructuralFeature)attr)))) {
            this.element.eSet((EStructuralFeature)attr, this.reference.eGet((EStructuralFeature)attr));
        }
    }

    private void updateManyValuesAttribute(EAttribute attr) {
        Collection<Object> newValues;
        Collection<Object> oldValues = this.getMany(this.element, (EStructuralFeature)attr);
        if (!Iterables.elementsEqual(oldValues, newValues = this.getMany(this.reference, (EStructuralFeature)attr))) {
            oldValues.clear();
            oldValues.addAll(newValues);
        }
    }

    private void updateReferences() {
        for (EReference ref : this.element.eClass().getEAllReferences()) {
            if (!ref.isChangeable() || ref.isDerived() || this.ignored.contains(ref)) continue;
            this.updateReference(ref);
        }
    }

    private void updateReference(EReference ref) {
        if (ref.isMany()) {
            this.updateManyValuesReference(ref);
        } else if (this.element.eIsSet((EStructuralFeature)ref) && !this.reference.eIsSet((EStructuralFeature)ref)) {
            this.element.eUnset((EStructuralFeature)ref);
        } else {
            this.updateSingleValueReference(ref);
        }
    }

    private void updateSingleValueReference(EReference ref) {
        EObject oldValue = (EObject)this.element.eGet((EStructuralFeature)ref);
        EObject newValue = (EObject)this.reference.eGet((EStructuralFeature)ref);
        if (oldValue != null && newValue != null && this.matcher.areSameLogicalElement(oldValue, newValue) && ref.isContainment()) {
            this.recursiveUpdate(oldValue, newValue);
        } else if (oldValue != newValue && !this.matcher.areSameLogicalElement(oldValue, newValue)) {
            this.element.eSet((EStructuralFeature)ref, (Object)newValue);
        }
    }

    private void updateManyValuesReference(EReference ref) {
        EList<EObject> oldValues = this.getManyEObjects(this.element, ref);
        EList<EObject> newValues = this.getManyEObjects(this.reference, ref);
        BiMap<EObject, EObject> matches = this.matcher.computeMatches((Collection<EObject>)oldValues, (Collection<EObject>)newValues);
        this.removeObsoleteElements(oldValues, matches.keySet());
        this.reorderMatchingElements(oldValues, newValues, matches);
        this.addMissingElements(oldValues, newValues, matches);
        if (ref.isContainment()) {
            this.updateMatchingElements(oldValues, matches);
        }
    }

    private void removeObsoleteElements(EList<EObject> values, Set<EObject> tokeep) {
        Iterator iter = values.iterator();
        while (iter.hasNext()) {
            EObject obj = (EObject)iter.next();
            if (tokeep.contains(obj)) continue;
            iter.remove();
            this.orphaned.add(obj);
        }
    }

    private void reorderMatchingElements(EList<EObject> oldValues, EList<EObject> newValues, BiMap<EObject, EObject> matches) {
        HashMap targetIndices = Maps.newHashMapWithExpectedSize((int)newValues.size());
        int i = 0;
        while (i < newValues.size()) {
            targetIndices.put((EObject)newValues.get(i), i);
            ++i;
        }
        Function matchingElementIndex = Functions.compose((Function)Functions.forMap((Map)targetIndices), (Function)Functions.forMap(matches));
        ECollections.sort(oldValues, (Comparator)Ordering.natural().onResultOf(matchingElementIndex));
    }

    private void addMissingElements(EList<EObject> oldValues, EList<EObject> newValues, BiMap<EObject, EObject> matches) {
        EObject[] missing = new EObject[newValues.size()];
        int i = 0;
        while (i < newValues.size()) {
            boolean isMissingElement;
            EObject newValue = (EObject)newValues.get(i);
            boolean bl = isMissingElement = !matches.containsValue((Object)newValue);
            if (isMissingElement) {
                missing[i] = newValue;
            }
            ++i;
        }
        i = 0;
        while (i < missing.length) {
            if (missing[i] != null) {
                oldValues.add(i, (Object)missing[i]);
            }
            ++i;
        }
    }

    private void updateMatchingElements(EList<EObject> oldValues, BiMap<EObject, EObject> matches) {
        for (Map.Entry entry : matches.entrySet()) {
            this.recursiveUpdate((EObject)entry.getKey(), (EObject)entry.getValue());
        }
    }

    private void recursiveUpdate(EObject obj, EObject ref) {
        Updater updater = new Updater(this.matcher, obj, ref);
        updater.isRoot = false;
        updater.setFeaturesToIgnore(this.ignored);
        updater.update();
        this.orphaned.addAll(updater.orphaned);
    }

    private void fixReferences() {
        BiMap<EObject, EObject> matches = this.matcher.computeMatches(Lists.newArrayList((Iterable)AllContents.of((EObject)this.reference, (boolean)true)), Lists.newArrayList((Iterable)AllContents.of((EObject)this.element, (boolean)true)));
        for (EObject obj : AllContents.of((EObject)this.element, (boolean)true)) {
            this.fixReferences(obj, matches);
        }
    }

    private void fixReferences(EObject obj, BiMap<EObject, EObject> matches) {
        for (EReference ref : obj.eClass().getEAllReferences()) {
            if (ref.isContainment() || !ref.isChangeable() || ref.isDerived() || ref.getEOpposite() != null) continue;
            this.fixReference(obj, ref, matches);
        }
    }

    private void fixReference(EObject obj, EReference ref, BiMap<EObject, EObject> matches) {
        if (ref.isMany()) {
            EList<EObject> values = this.getManyEObjects(obj, ref);
            int i = 0;
            while (i < values.size()) {
                EObject value = (EObject)values.get(i);
                if (matches.containsKey((Object)value)) {
                    values.set(i, (Object)((EObject)matches.get((Object)value)));
                }
                ++i;
            }
            Iterator iter = values.iterator();
            while (iter.hasNext()) {
                EObject eObject = (EObject)iter.next();
                if (!this.orphaned.contains(eObject)) continue;
                iter.remove();
            }
        } else {
            Object value = obj.eGet((EStructuralFeature)ref);
            if (matches.containsKey(value)) {
                obj.eSet((EStructuralFeature)ref, matches.get(value));
            } else if (this.orphaned.contains(value)) {
                obj.eUnset((EStructuralFeature)ref);
            }
        }
    }

    private Collection<Object> getMany(EObject target, EStructuralFeature targetFeature) {
        Object rawValue = target.eGet(targetFeature);
        if (rawValue != null && !(rawValue instanceof Collection)) {
            throw new RuntimeException(MessageFormat.format("Expected a collection from many-valued feature {0} but got a {1}", targetFeature.getName(), rawValue.getClass()));
        }
        return (Collection)rawValue;
    }

    private EList<EObject> getManyEObjects(EObject target, EReference ref) {
        Object rawValue = target.eGet((EStructuralFeature)ref);
        if (rawValue != null && !(rawValue instanceof EList)) {
            throw new RuntimeException(MessageFormat.format("Expected a collection from many-valued feature {0} but got a {1}", ref.getName(), rawValue.getClass()));
        }
        return (EList)rawValue;
    }

    public void setFeaturesToIgnore(List<EStructuralFeature> ignore) {
        this.ignored = ignore;
    }
}

