/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.dialect.command;

import java.util.Collection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.transaction.RecordingCommand;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.viewpoint.DRepresentation;
import org.eclipse.sirius.viewpoint.DSemanticDecorator;

public class RefreshImpactedElementsCommand
extends RecordingCommand {
    private Collection<Notification> notifications;
    private Collection<DRepresentation> representations;
    private IProgressMonitor monitor;

    public RefreshImpactedElementsCommand(TransactionalEditingDomain domain, IProgressMonitor monitor, Collection<DRepresentation> representationsToRefresh, Collection<Notification> notifications) {
        super(domain, "Refresh impacted representation elements");
        this.monitor = monitor;
        this.representations = representationsToRefresh;
        this.notifications = notifications;
    }

    protected void doExecute() {
        if (this.monitor == null) {
            this.monitor = new NullProgressMonitor();
        }
        try {
            this.monitor.beginTask("Refresh impacted representation elements", this.representations.size());
            for (DRepresentation representation : this.representations) {
                if (this.safeRefresh(representation)) {
                    DialectManager.INSTANCE.refreshImpactedElements(representation, this.notifications, (IProgressMonitor)new SubProgressMonitor(this.monitor, 1));
                    continue;
                }
                this.monitor.worked(1);
            }
        }
        finally {
            this.monitor.done();
        }
    }

    private boolean safeRefresh(DRepresentation representation) {
        boolean safeRefresh;
        boolean bl = safeRefresh = representation != null;
        if (representation instanceof DSemanticDecorator) {
            safeRefresh = ((DSemanticDecorator)((Object)representation)).getTarget() != null;
        }
        return safeRefresh;
    }

    public boolean canExecute() {
        return this.representations.size() != 0;
    }
}

