/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.dialect.description;

import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.sirius.business.api.dialect.DialectManager;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionQuery;
import org.eclipse.sirius.business.api.dialect.description.IInterpretedExpressionTargetSwitch;
import org.eclipse.sirius.ext.base.Option;
import org.eclipse.sirius.ext.base.Options;
import org.eclipse.sirius.viewpoint.description.PasteTargetDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationDescription;
import org.eclipse.sirius.viewpoint.description.RepresentationElementMapping;
import org.eclipse.sirius.viewpoint.description.tool.AbstractToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.AcceleoVariable;
import org.eclipse.sirius.viewpoint.description.tool.Case;
import org.eclipse.sirius.viewpoint.description.tool.ChangeContext;
import org.eclipse.sirius.viewpoint.description.tool.CreateInstance;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaAction;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaActionCall;
import org.eclipse.sirius.viewpoint.description.tool.ExternalJavaActionParameter;
import org.eclipse.sirius.viewpoint.description.tool.For;
import org.eclipse.sirius.viewpoint.description.tool.MappingBasedToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ModelOperation;
import org.eclipse.sirius.viewpoint.description.tool.OperationAction;
import org.eclipse.sirius.viewpoint.description.tool.PaneBasedSelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.PasteDescription;
import org.eclipse.sirius.viewpoint.description.tool.PopupMenu;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationCreationDescription;
import org.eclipse.sirius.viewpoint.description.tool.RepresentationNavigationDescription;
import org.eclipse.sirius.viewpoint.description.tool.SelectModelElementVariable;
import org.eclipse.sirius.viewpoint.description.tool.SelectionWizardDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolFilterDescription;
import org.eclipse.sirius.viewpoint.description.tool.ToolPackage;
import org.eclipse.sirius.viewpoint.description.tool.util.ToolSwitch;
import org.eclipse.sirius.viewpoint.description.validation.ValidationRule;

public class ToolInterpretedExpressionTargetSwitch
extends ToolSwitch<Option<Collection<String>>> {
    private static final int DO_NOT_CONSIDER_FEATURE = -1;
    protected EStructuralFeature feature;
    protected boolean considerFeature;
    private IInterpretedExpressionTargetSwitch globalSwitch;

    public ToolInterpretedExpressionTargetSwitch(EStructuralFeature feature, IInterpretedExpressionTargetSwitch defaultInterpretedExpressionTargetSwitch) {
        this.feature = feature;
        this.globalSwitch = defaultInterpretedExpressionTargetSwitch;
    }

    @Override
    public Option<Collection<String>> doSwitch(EObject theEObject) {
        Option doSwitch = (Option)super.doSwitch(theEObject);
        if (doSwitch != null) {
            return doSwitch;
        }
        Set targets = Collections.emptySet();
        return Options.newSome(targets);
    }

    @Override
    protected Option<Collection<String>> doSwitch(EClass theEClass, EObject theEObject) {
        Option<Collection<String>> result = null;
        if (theEClass.eContainer() == modelPackage) {
            result = (Option<Collection<String>>)this.doSwitch(theEClass.getClassifierID(), theEObject);
        } else {
            EList eSuperTypes = theEClass.getESuperTypes();
            if (eSuperTypes.isEmpty()) {
                result = (Option)this.defaultCase(theEObject);
            } else {
                for (EClass eSuperType : eSuperTypes) {
                    result = this.doSwitch(eSuperType, theEObject);
                    if (result != null) break;
                }
            }
        }
        return result;
    }

    public void setConsiderFeature(boolean considerFeature) {
        this.considerFeature = considerFeature;
    }

    private int getFeatureId(EClass eClass) {
        int featureID = -1;
        if (this.considerFeature && this.feature != null) {
            featureID = eClass.getFeatureID(this.feature);
        }
        return featureID;
    }

    protected EObject getFirstContextChangingContainer(EObject element) {
        EObject container = element.eContainer();
        while (!this.isChangingContextElement(container)) {
            container = container.eContainer();
        }
        return container;
    }

    private boolean isChangingContextElement(EObject element) {
        boolean descCanChange = element instanceof RepresentationDescription || element instanceof RepresentationElementMapping;
        boolean operationCanChange = element instanceof CreateInstance || element instanceof ChangeContext || element instanceof For;
        boolean toolCanChange = element instanceof AbstractToolDescription;
        boolean validationRulecanChange = element instanceof ValidationRule;
        return descCanChange || operationCanChange || toolCanChange || validationRulecanChange;
    }

    @Override
    public Option<Collection<String>> caseMappingBasedToolDescription(MappingBasedToolDescription tool) {
        Option result = null;
        switch (this.getFeatureId(ToolPackage.eINSTANCE.getMappingBasedToolDescription())) {
            case -1: 
            case 3: {
                result = Options.newNone();
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseAbstractToolDescription(AbstractToolDescription tool) {
        Option result = null;
        switch (this.getFeatureId(ToolPackage.eINSTANCE.getAbstractToolDescription())) {
            case -1: 
            case 3: {
                result = Options.newNone();
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseToolDescription(ToolDescription object) {
        Option result = null;
        switch (this.getFeatureId(ToolPackage.eINSTANCE.getToolDescription())) {
            case -1: 
            case 3: {
                result = Options.newNone();
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseOperationAction(OperationAction object) {
        Option result = null;
        switch (this.getFeatureId(ToolPackage.eINSTANCE.getOperationAction())) {
            case -1: 
            case 3: {
                result = Options.newNone();
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> casePasteDescription(PasteDescription object) {
        Option result = null;
        switch (this.getFeatureId(ToolPackage.eINSTANCE.getPasteDescription())) {
            case -1: 
            case 3: {
                LinkedHashSet targets = Sets.newLinkedHashSet();
                for (PasteTargetDescription container : object.getContainers()) {
                    Option<Collection<String>> targetsFromMapping = this.globalSwitch.doSwitch(container, false);
                    if (!targetsFromMapping.some()) continue;
                    targets.addAll((Collection)targetsFromMapping.get());
                }
                result = Options.newSome((Object)targets);
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseAcceleoVariable(AcceleoVariable object) {
        Option<Collection<String>> result = null;
        switch (this.getFeatureId(ToolPackage.eINSTANCE.getAcceleoVariable())) {
            case -1: 
            case 2: {
                result = this.globalSwitch.doSwitch(this.getFirstContextChangingContainer(object), false);
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseSelectModelElementVariable(SelectModelElementVariable object) {
        Option<Collection<String>> result = null;
        switch (this.getFeatureId(ToolPackage.eINSTANCE.getSelectModelElementVariable())) {
            case -1: 
            case 1: 
            case 4: 
            case 5: {
                result = this.globalSwitch.doSwitch(this.getFirstContextChangingContainer(object), false);
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> casePaneBasedSelectionWizardDescription(PaneBasedSelectionWizardDescription toolDescription) {
        Option result = null;
        switch (this.getFeatureId(ToolPackage.eINSTANCE.getPaneBasedSelectionWizardDescription())) {
            case -1: 
            case 3: 
            case 15: 
            case 17: 
            case 18: 
            case 20: {
                result = Options.newNone();
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseSelectionWizardDescription(SelectionWizardDescription toolDescription) {
        Option result = null;
        switch (this.getFeatureId(ToolPackage.eINSTANCE.getSelectionWizardDescription())) {
            case -1: 
            case 3: 
            case 6: 
            case 9: 
            case 10: {
                result = Options.newNone();
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> casePopupMenu(PopupMenu object) {
        Option result = null;
        switch (this.getFeatureId(ToolPackage.eINSTANCE.getPopupMenu())) {
            case -1: 
            case 3: {
                result = Options.newNone();
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseExternalJavaAction(ExternalJavaAction object) {
        Option result = null;
        switch (this.getFeatureId(ToolPackage.eINSTANCE.getExternalJavaAction())) {
            case -1: 
            case 3: {
                result = Options.newNone();
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseExternalJavaActionCall(ExternalJavaActionCall object) {
        Option result = null;
        switch (this.getFeatureId(ToolPackage.eINSTANCE.getExternalJavaActionCall())) {
            case -1: 
            case 3: {
                result = Options.newNone();
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseExternalJavaActionParameter(ExternalJavaActionParameter object) {
        Option result = null;
        switch (this.getFeatureId(ToolPackage.eINSTANCE.getExternalJavaActionParameter())) {
            case -1: 
            case 1: {
                result = Options.newNone();
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseRepresentationCreationDescription(RepresentationCreationDescription toolDescription) {
        LinkedHashSet targets = Sets.newLinkedHashSet();
        Option result = Options.newSome((Object)targets);
        switch (this.getFeatureId(ToolPackage.eINSTANCE.getRepresentationCreationDescription())) {
            case -1: 
            case 3: 
            case 6: 
            case 7: {
                for (RepresentationElementMapping mapping : toolDescription.getMappings()) {
                    IInterpretedExpressionQuery interpretedExpressionQuery = DialectManager.INSTANCE.createInterpretedExpressionQuery(mapping, null);
                    Option<Collection<String>> mappingTypes = interpretedExpressionQuery.getTargetDomainClasses();
                    if (!mappingTypes.some()) continue;
                    targets.addAll((Collection)mappingTypes.get());
                }
                result = Options.newSome((Object)targets);
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseRepresentationNavigationDescription(RepresentationNavigationDescription toolDescription) {
        LinkedHashSet targets = Sets.newLinkedHashSet();
        Option result = Options.newSome((Object)targets);
        switch (this.getFeatureId(ToolPackage.eINSTANCE.getRepresentationNavigationDescription())) {
            case -1: 
            case 3: 
            case 6: 
            case 7: {
                for (RepresentationElementMapping mapping : toolDescription.getMappings()) {
                    IInterpretedExpressionQuery interpretedExpressionQuery = DialectManager.INSTANCE.createInterpretedExpressionQuery(mapping, null);
                    Option<Collection<String>> mappingTypes = interpretedExpressionQuery.getTargetDomainClasses();
                    if (!mappingTypes.some()) continue;
                    targets.addAll((Collection)mappingTypes.get());
                }
                result = Options.newSome((Object)targets);
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseModelOperation(ModelOperation object) {
        return this.globalSwitch.doSwitch(this.getFirstContextChangingContainer(object), false);
    }

    @Override
    public Option<Collection<String>> caseCase(Case object) {
        return this.globalSwitch.doSwitch(this.getFirstContextChangingContainer(object), false);
    }

    @Override
    public Option<Collection<String>> caseToolFilterDescription(ToolFilterDescription object) {
        return this.globalSwitch.doSwitch(this.getFirstContextChangingContainer(object), false);
    }

    @Override
    public Option<Collection<String>> caseChangeContext(ChangeContext object) {
        Option result = null;
        switch (this.getFeatureId(object.eClass())) {
            case 1: {
                return this.globalSwitch.doSwitch(this.getFirstContextChangingContainer(object), false);
            }
            case -1: {
                result = Options.newNone();
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseFor(For object) {
        Option result = null;
        switch (this.getFeatureId(object.eClass())) {
            case 1: {
                return this.globalSwitch.doSwitch(this.getFirstContextChangingContainer(object), false);
            }
            case -1: {
                result = Options.newNone();
                break;
            }
        }
        return result;
    }

    @Override
    public Option<Collection<String>> caseCreateInstance(CreateInstance object) {
        Option result = null;
        switch (this.getFeatureId(object.eClass())) {
            case -1: {
                Set<String> target = Collections.singleton(object.getTypeName());
                result = Options.newSome(target);
                break;
            }
        }
        return result;
    }
}

