/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sirius.business.internal.session;

import com.google.common.collect.Iterables;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.transaction.ResourceSetChangeEvent;
import org.eclipse.emf.transaction.ResourceSetListener;
import org.eclipse.emf.transaction.ResourceSetListenerImpl;
import org.eclipse.sirius.business.api.session.Session;
import org.eclipse.sirius.business.api.session.SessionManager;
import org.eclipse.sirius.viewpoint.DRepresentation;

public class RepresentationNameListener
extends ResourceSetListenerImpl {
    private Session session;

    public RepresentationNameListener(Session session) {
        this.session = session;
        session.getTransactionalEditingDomain().addResourceSetListener((ResourceSetListener)this);
    }

    public boolean isPostcommitOnly() {
        return true;
    }

    public void resourceSetChanged(ResourceSetChangeEvent event) {
        for (Notification notif : Iterables.filter((Iterable)event.getNotifications(), Notification.class)) {
            if (!this.isRepresentationNameChange(notif)) continue;
            SessionManager.INSTANCE.notifyRepresentationRenamed(this.session);
        }
    }

    private boolean isRepresentationNameChange(Notification notif) {
        return notif.getNotifier() instanceof DRepresentation && notif.getFeatureID(DRepresentation.class) == 4;
    }

    public void dispose() {
        this.getTarget().removeResourceSetListener((ResourceSetListener)this);
        this.session = null;
    }
}

