/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.draw2d;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.stardust.ide.simulation.ui.curves.draw2d.AbstractOverlayFigure;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Configuration;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Layer;
import org.eclipse.stardust.ide.simulation.ui.curves.drawing.Metrics;
import org.eclipse.stardust.ide.simulation.ui.curves.geometry.Rectangle2D;

public class CurveFigure
extends AbstractOverlayFigure {
    Layer layer;

    public CurveFigure(Configuration configuration, Layer layer) {
        super(configuration);
        this.layer = layer;
    }

    protected void paintFigure(Graphics graphics) {
        try {
            if (this.getLayer() != null) {
                graphics.translate(this.getBounds().x, this.getBounds().y);
                Layer layer = this.getLayer();
                Configuration configuration = this.getConfiguration();
                Rectangle rectangle = this.getClientArea();
                Metrics metrics = new Metrics(Rectangle2D.draw2d2model(rectangle), configuration.getMarginLeft(), configuration.getMarginBottom(), configuration.getMarginRight(), configuration.getMarginTop());
                Rectangle2D valueRectangle = layer.getBounds();
                metrics.initValueRectangle(valueRectangle != null ? valueRectangle : new Rectangle2D(0.0, 0.0, 1.0, 1.0));
                layer.draw(graphics, metrics, configuration);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
    }

    public Layer getLayer() {
        return this.layer;
    }
}

