/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.curves.layers;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import org.eclipse.stardust.ide.simulation.ui.curves.layers.AxisLabeling;

public class StaticAxisLabeling
implements AxisLabeling {
    protected double smallTicks;
    protected double largeTicks;
    protected double scaleTicks;
    protected DecimalFormat scaleFormat;

    public StaticAxisLabeling(double smallTicks, double largeTicks, double scaleTicks, String scaleFormat) {
        this.smallTicks = smallTicks;
        this.largeTicks = largeTicks;
        this.scaleTicks = scaleTicks;
        this.scaleFormat = scaleFormat != null ? new DecimalFormat(scaleFormat, new DecimalFormatSymbols(Locale.US)) : null;
    }

    @Override
    public boolean hasSmallTicks() {
        return this.smallTicks > 0.0;
    }

    @Override
    public double getSmallTicks() {
        return this.smallTicks;
    }

    @Override
    public boolean hasLargeTicks() {
        return this.largeTicks > 0.0;
    }

    @Override
    public double getLargeTicks() {
        return this.largeTicks;
    }

    @Override
    public boolean hasScaleTicks() {
        return this.scaleTicks > 0.0;
    }

    @Override
    public double getScaleTicks() {
        return this.scaleTicks;
    }

    @Override
    public String format(double value) {
        return this.scaleFormat != null ? this.scaleFormat.format(value) : Double.toString(value);
    }

    @Override
    public void update(double diffInValues, int diffInPixel) {
    }
}

