/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.ide.simulation.ui.propertypages.gui;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.stardust.ide.simulation.ui.Simulation_Modeling_Messages;
import org.eclipse.stardust.ide.simulation.ui.distributions.utils.AdjustableDoubleRange;
import org.eclipse.stardust.ide.simulation.ui.propertypages.gui.CreateSliderDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class AdapterForSliderButton
implements SelectionListener {
    static final NumberFormat MULTIPLICATOR_FORMATTER = new DecimalFormat("' * '#.#%");
    AdjustableDoubleRange initialRange;
    AdjustableDoubleRange sliderRange;
    AdjustableDoubleRange currentRange;
    Button hasSliderButton;
    Control[] dependentComponents = new Control[0];
    Control[] statusComponents = new Control[0];
    static int counter = 1;

    public AdapterForSliderButton(Composite parent, AdjustableDoubleRange initialRange) {
        this.hasSliderButton = new Button(parent, 2);
        this.hasSliderButton.setImage(ImageDescriptor.createFromFile(this.getClass(), (String)"icons/slider.gif").createImage());
        this.hasSliderButton.addSelectionListener((SelectionListener)this);
        this.initialRange = initialRange;
    }

    public Button getControl() {
        return this.hasSliderButton;
    }

    public AdjustableDoubleRange getSliderRange() {
        return this.sliderRange;
    }

    public void setSliderRange(AdjustableDoubleRange sliderRange) {
        this.sliderRange = sliderRange;
        this.hasSliderButton.setSelection(sliderRange != null);
        int i = 0;
        while (i < this.dependentComponents.length) {
            this.dependentComponents[i].setEnabled(sliderRange == null);
            ++i;
        }
        i = 0;
        while (i < this.statusComponents.length) {
            this.statusComponents[i].setVisible(sliderRange != null);
            ++i;
        }
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        this.hasSliderButton.setSelection(this.openConfigurationDialog());
        int i = 0;
        while (i < this.dependentComponents.length) {
            this.dependentComponents[i].setEnabled(this.sliderRange == null);
            ++i;
        }
        i = 0;
        while (i < this.statusComponents.length) {
            this.statusComponents[i].setVisible(this.sliderRange != null);
            ++i;
        }
    }

    private boolean openConfigurationDialog() {
        if (this.sliderRange != null) {
            this.currentRange = this.sliderRange;
        } else if (this.currentRange == null) {
            this.currentRange = new AdjustableDoubleRange(String.valueOf(this.initialRange.getLabel()) + " " + counter, this.initialRange.getMinValue(), this.initialRange.getMaxValue(), this.initialRange.getIncrement());
        }
        CreateSliderDialog dialog = new CreateSliderDialog(this.hasSliderButton.getShell(), Simulation_Modeling_Messages.CREATE_SLIDER_TITLE, Simulation_Modeling_Messages.CREATE_SLIDER_TEXT, this.currentRange, this.sliderRange != null);
        this.hasSliderButton.setToolTipText("");
        if (dialog.open() == 0) {
            this.currentRange = this.sliderRange = dialog.getSlider();
            this.hasSliderButton.setToolTipText(this.sliderRange != null ? this.sliderRange.getLabel() : "");
            ++counter;
        }
        return this.sliderRange != null;
    }

    public void addDependentComponent(Control dependentComponent) {
        Control[] temp = this.dependentComponents;
        this.dependentComponents = new Control[temp.length + 1];
        System.arraycopy(temp, 0, this.dependentComponents, 0, temp.length);
        this.dependentComponents[temp.length] = dependentComponent;
        if (dependentComponent != null) {
            dependentComponent.setEnabled(this.sliderRange == null);
        }
    }

    public void addStatusComponent(Control statusComponent) {
        Control[] temp = this.statusComponents;
        this.statusComponents = new Control[temp.length + 1];
        System.arraycopy(temp, 0, this.statusComponents, 0, temp.length);
        this.statusComponents[temp.length] = statusComponent;
        if (statusComponent != null) {
            statusComponent.setVisible(this.sliderRange != null);
        }
    }

    public void dispose() {
        if (this.hasSliderButton != null && this.hasSliderButton.getImage() != null) {
            this.hasSliderButton.getImage().dispose();
        }
    }
}

