/*******************************************************************************
 * Copyright (c) 2011, 2012 SunGard CSA LLC and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *    SunGard CSA LLC - initial API and implementation and/or initial documentation
 *******************************************************************************/
package org.eclipse.stardust.ide.wst.facet.portal;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.RegistryFactory;
import org.eclipse.stardust.ide.wst.common.ExternalLibrary;
import org.eclipse.stardust.ide.wst.common.utils.CommonLibraryUtils;
import org.eclipse.stardust.ide.wst.common.utils.LibraryProviderUtils;


/**
 * @author rsauer
 * @version $Revision: 34900 $
 */
public class IPPPortalFacet
{
   /* Extension point ID */
   public static final String ICEFACES_JAR_REPLACEMENT = "org.eclipse.stardust.ide.wst.facet.portal.icefacesJarReplacement"; //$NON-NLS-1$

   public static final String PORTAL_ROOT = "ipp-portal"; //$NON-NLS-1$

   public static ExternalLibrary[] getDeprecatedLibraries()
   {
      List<ExternalLibrary> result = new ArrayList<ExternalLibrary>();

      result.add(portalLib("carnot-dms.jar")); //$NON-NLS-1$

      result.add(portalLib("carnot-processportal.jar")); //$NON-NLS-1$
      result.add(portalLib("ipp-portal-core.jar")); //$NON-NLS-1$
      result.add(portalLib("jcr-vfs-1.6.1.jar")); //$NON-NLS-1$
      result.add(portalLib("el-api.jar")); //$NON-NLS-1$
      result.add(portalLib("standard.jar")); //$NON-NLS-1$

      result.add(portalLib("carnot-hibernate.jar")); //$NON-NLS-1$
      result.add(portalLib("dom4j-1.6.1.jar")); //$NON-NLS-1$
      result.add(portalLib("hibernate3.jar")); //$NON-NLS-1$

      result.add(portalLib("spring.jar")); //$NON-NLS-1$

      result.add(portalLib("trinidad-api.jar")); //$NON-NLS-1$
      result.add(portalLib("trinidad-impl.jar")); //$NON-NLS-1$

      result.add(portalLib("atmosphere-compat-jbossweb-1.0.4.jar")); //$NON-NLS-1$
      result.add(portalLib("atmosphere-compat-tomcat-1.0.4.jar")); //$NON-NLS-1$
      result.add(portalLib("atmosphere-compat-tomcat7-1.0.4.jar")); //$NON-NLS-1$
      result.add(portalLib("atmosphere-runtime-1.0.4.jar")); //$NON-NLS-1$
      
      result.add(portalLib("jsf-facelets.jar")); //$NON-NLS-1$

      result.add(j2eeLib("jms.jar")); //$NON-NLS-1$
      result.add(j2eeLib("ejb.jar")); //$NON-NLS-1$

      return result.toArray(new ExternalLibrary[0]);
   }

   public static ExternalLibrary[] getExternalSpringLibraries()
   {
      List<ExternalLibrary> result = new ArrayList<ExternalLibrary>();

      result.add(springLib("aopalliance.jar")); //$NON-NLS-1$
      result.add(springLib("spring-aop.jar")); //$NON-NLS-1$
      result.add(springLib("spring-asm.jar")); //$NON-NLS-1$
      result.add(springLib("spring-beans.jar")); //$NON-NLS-1$
      result.add(springLib("spring-context.jar")); //$NON-NLS-1$
      result.add(springLib("spring-context-support.jar")); //$NON-NLS-1$
      result.add(springLib("spring-core.jar")); //$NON-NLS-1$
      result.add(springLib("spring-expression.jar")); //$NON-NLS-1$
      result.add(springLib("spring-jdbc.jar")); //$NON-NLS-1$
      result.add(springLib("spring-jms.jar")); //$NON-NLS-1$
      result.add(springLib("spring-orm.jar")); //$NON-NLS-1$
      result.add(springLib("spring-tx.jar")); //$NON-NLS-1$
      result.add(springLib("spring-web.jar")); //$NON-NLS-1$
      result.add(springLib("spring-webmvc.jar")); //$NON-NLS-1$

      return result.toArray(new ExternalLibrary[0]);
   }

   public static ExternalLibrary[] getExternalLibraries()
   {
      List<ExternalLibrary> result = new ArrayList<ExternalLibrary>();

      result.add(engineLib("carnot-engine.jar")); //$NON-NLS-1$
      result.add(engineBaseLib("carnot-base.jar")); //$NON-NLS-1$
      result.add(j2eeLib("geronimo-ejb_2.1_spec.jar")); //$NON-NLS-1$
      result.add(j2eeLib("geronimo-jms_1.1_spec.jar")); //$NON-NLS-1$
      //result.add(xmlLib("org.apache.xerces_2.9.0.v201005080400.jar")); //$NON-NLS-1$
      result.add(portalLib("activation.jar")); //$NON-NLS-1$
      result.add(portalLib("commons-beanutils.jar")); //$NON-NLS-1$
      result.add(portalLib("commons-codec.jar")); //$NON-NLS-1$
      result.add(portalLib("commons-collections.jar")); //$NON-NLS-1$
      result.add(portalLib("commons-digester.jar")); //$NON-NLS-1$
      result.add(portalLib("commons-el.jar")); //$NON-NLS-1$
      result.add(portalLib("commons-fileupload.jar")); //$NON-NLS-1$
      result.add(portalLib("commons-io.jar")); //$NON-NLS-1$
      result.add(portalLib("commons-jxpath.jar")); //$NON-NLS-1$
      result.add(portalLib("commons-lang.jar")); //$NON-NLS-1$
      result.add(portalLib("commons-logging.jar")); //$NON-NLS-1$
      result.add(portalLib("el-ri.jar")); //$NON-NLS-1$
      result.add(portalLib("jstl.jar")); //$NON-NLS-1$
      result.add(portalLib("mail.jar")); //$NON-NLS-1$
      result.add(portalLib("myfaces-api.jar")); //$NON-NLS-1$
      result.add(portalLib("myfaces-impl.jar")); //$NON-NLS-1$
      result.add(portalLib("jcr.jar")); //$NON-NLS-1$
      result.add(portalLib("jcr-vfs.jar")); //$NON-NLS-1$
      result.add(portalLib("jcr-vfs-factory.jar")); //$NON-NLS-1$

      result.add(portalLib("jencks.jar")); //$NON-NLS-1$
      result.add(portalLib("geronimo-transaction.jar")); //$NON-NLS-1$
      result.add(portalLib("geronimo-connector.jar")); //$NON-NLS-1$
      result.add(portalLib("geronimo-jta_1.1_spec.jar")); //$NON-NLS-1$
      result.add(portalLib("geronimo-j2ee-connector_1.5_spec.jar")); //$NON-NLS-1$
      result.add(portalLib("tranql-connector.jar")); //$NON-NLS-1$

      result.add(portalLib("cglib-nodep.jar")); //$NON-NLS-1$

      result.add(portalLib("javax.ws.rs-api.jar")); //$NON-NLS-1$
      result.add(portalLib("stax2-api.jar")); //$NON-NLS-1$
      result.add(portalLib("woodstox-core-asl.jar")); //$NON-NLS-1$

      result.add(jsLib("js.jar")); //$NON-NLS-1$

      addIcefacesJars(result);
      result.add(portalLib("backport-util-concurrent.jar")); //$NON-NLS-1$

      // bcc
      result.add(portalLib("htmlcleaner.jar")); //$NON-NLS-1$
      result.add(portalLib("icepdf-core.jar")); //$NON-NLS-1$

      // new ipp jars
      result.add(portalLib("ipp-administration-perspective.jar")); //$NON-NLS-1$
      result.add(portalLib("ipp-business-control-center.jar")); //$NON-NLS-1$
      result.add(portalLib("ipp-portal-api.jar")); //$NON-NLS-1$
      result.add(portalLib("ipp-portal-common.jar")); //$NON-NLS-1$
      result.add(portalLib("ipp-graphics-common.jar")); //$NON-NLS-1$
      result.add(portalLib("ipp-views-common.jar")); //$NON-NLS-1$
      result.add(portalLib("ipp-workflow-perspective.jar")); //$NON-NLS-1$
      result.add(portalLib("ipp-end-user-doc.jar")); //$NON-NLS-1$
      result.add(portalLib("stardust-engine-business-calendar.jar")); //$NON-NLS-1$
      result.add(portalLib("stardust-mobile-workflow.jar")); //$NON-NLS-1$
      result.add(portalLib("stardust-modern-skin.jar")); //$NON-NLS-1$
      result.add(portalLib("stardust-html5-common.jar")); //$NON-NLS-1$
      result.add(portalLib("stardust-html5-process-portal.jar")); //$NON-NLS-1$
      result.add(portalLib("stardust-html5-business-control-center.jar")); //$NON-NLS-1$
      result.add(portalLib("stardust-html5-admin-portal.jar")); //$NON-NLS-1$
      result.add(portalLib("stardust-html5-views-common.jar")); //$NON-NLS-1$
      result.add(portalLib("stardust-portal-rest-common.jar")); //$NON-NLS-1$
      result.add(portalLib("stardust-web-camel.jar")); //$NON-NLS-1$

      // web reporting
      result.add(portalLib("stardust-reporting-client.jar")); //$NON-NLS-1$
      result.add(portalLib("stardust-reporting-rt.jar")); //$NON-NLS-1$
      result.add(portalLib("stardust-web-reporting.jar")); //$NON-NLS-1$

      // web reporting dependencies
      result.add(portalLib("icu4j.jar")); //$NON-NLS-1$

      result.add(portalLib("stardust-rules-manager.jar")); //$NON-NLS-1$

      result.add(portalLib("stardust-common-introspection.jar")); //$NON-NLS-1$
      result.add(portalLib("stardust-common-introspection-xsd.jar")); //$NON-NLS-1$
      result.add(portalLib("stardust-ui-form.jar")); //$NON-NLS-1$
      result.add(portalLib("stardust-ui-form-jsf.jar")); //$NON-NLS-1$

      // custom jai_imageio.jar
      result.add(portalLib("jai_imageio.jar")); //$NON-NLS-1$

      // web modeler
      result.add(portalLib("ipp-bpm-model-builder.jar")); //$NON-NLS-1$
      result.add(portalLib("stardust-web-modeler.jar")); //$NON-NLS-1$
      result.add(portalLib("stardust-web-modeler-bpmn2.jar")); //$NON-NLS-1$

      // web modeler stardust plugin dependencies
      result.add(portalLib("ipp-bpm-model.jar")); //$NON-NLS-1$
      result.add(portalLib("ipp-bpm-repository.jar")); //$NON-NLS-1$
      result.add(portalLib("ipp-bpm-model-validation.jar")); //$NON-NLS-1$

      // web modeler emf/xsd plugin dependencies
      result.add(portalLib("org.eclipse.emf.common.jar")); //$NON-NLS-1$
      result.add(portalLib("org.eclipse.emf.ecore.jar")); //$NON-NLS-1$
      result.add(portalLib("org.eclipse.emf.ecore.change.jar")); //$NON-NLS-1$
      result.add(portalLib("org.eclipse.emf.ecore.xmi.jar")); //$NON-NLS-1$
      result.add(portalLib("org.eclipse.xsd.jar")); //$NON-NLS-1$

      // web modeler eclipse plugin dependencies
      result.add(portalLib("org.eclipse.core.runtime.jar")); //$NON-NLS-1$
      result.add(portalLib("org.eclipse.equinox.common.jar")); //$NON-NLS-1$
      result.add(portalLib("org.eclipse.equinox.registry.jar")); //$NON-NLS-1$
      result.add(portalLib("org.eclipse.osgi.jar")); //$NON-NLS-1$
      result.add(portalLib("org.eclipse.bpmn2.jar")); //$NON-NLS-1$

      return result.toArray(new ExternalLibrary[0]);
   }

   protected static void addIcefacesJars(List<ExternalLibrary> result)
   {
      IConfigurationElement[] configElements = RegistryFactory.getRegistry()
            .getConfigurationElementsFor(ICEFACES_JAR_REPLACEMENT);
      if (configElements != null && configElements.length > 0)
      {
         // if any number of replacement jars are configured these will be used
         for (IConfigurationElement configElement : configElements)
         {
            String varName = configElement.getAttribute("varName");
            String pluginId = configElement.getAttribute("pluginId");
            String jarName = configElement.getAttribute("jarName");
            result.add(LibraryProviderUtils.resolveExternalLibrary(varName, pluginId,
                  jarName));
         }
      }
      else
      {
         // fallback to jars provided by default
         result.add(portalLib("icefaces.jar")); //$NON-NLS-1$
         result.add(portalLib("icefaces-comps.jar")); //$NON-NLS-1$
         result.add(portalLib("icefaces-facelets.jar")); //$NON-NLS-1$
      }
   }

   private static ExternalLibrary engineBaseLib(String jarBaseName)
   {
      return CommonLibraryUtils.resolveEngineBaseLibrary(jarBaseName);
   }

   private static ExternalLibrary engineLib(String jarBaseName)
   {
      return CommonLibraryUtils.resolveEngineLibrary(jarBaseName);
   }

   private static ExternalLibrary j2eeLib(String jarBaseName)
   {
      return CommonLibraryUtils.resolveJ2eeLibrary(jarBaseName);
   }

   private static ExternalLibrary springLib(String jarBaseName)
   {
      return CommonLibraryUtils.resolveSpringLibrary(jarBaseName);
   }

   private static ExternalLibrary jsLib(String jarBaseName)
   {
      return CommonLibraryUtils.resolveJsLibrary(jarBaseName);
   }

   private static ExternalLibrary portalLib(String jarBaseName)
   {
      return IPPPortalBundleActivator.getInstance().resolveExternalLibrary(
            jarBaseName);
   }
}
