/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.api.internal.adapters;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.w3c.dom.DocumentFragment;

public class AttributeUtils {
    public static void setAttribute(IExtensibleElement target, String name, Object value) {
        AttributeType attr = AttributeUtil.getAttribute((IExtensibleElement)target, (String)name);
        if (value == null) {
            if (attr != null) {
                target.getAttribute().remove((Object)attr);
            }
        } else {
            if (attr == null) {
                attr = CarnotWorkflowModelFactory.eINSTANCE.createAttributeType();
                attr.setName(name);
                target.getAttribute().add((Object)attr);
            }
            AttributeUtils.setAttributeValue(attr, value);
        }
    }

    public static void setAttributeValue(AttributeType attr, Object value) {
        if (!"carnot:model:xpdl:extendedAttributes".equals(attr.getValue()) || !(value instanceof DocumentFragment)) {
            attr.setAttributeValue(Reflect.getAbbreviatedName(value.getClass()), Reflect.convertObjectToString((Object)value));
        }
    }

    public static Object getAttribute(IExtensibleElement target, String name) {
        Object result = null;
        AttributeType attr = AttributeUtil.getAttribute((IExtensibleElement)target, (String)name);
        if (attr != null) {
            result = AttributeUtils.getAttributeValue(attr);
        }
        return result;
    }

    public static Object getAttributeValue(AttributeType attr) {
        String valueString;
        Object result = null;
        if (!"carnot:model:xpdl:extendedAttributes".equals(attr.getName()) && !StringUtils.isEmpty((String)(valueString = attr.getAttributeValue()))) {
            String classname = attr.getType();
            if (StringUtils.isEmpty((String)classname)) {
                result = valueString;
            } else {
                try {
                    result = Reflect.convertStringToObject((String)classname, (String)valueString);
                }
                catch (Exception exception) {}
            }
        }
        return result;
    }

    public static Map getAllAtttributes(IExtensibleElement target) {
        HashMap<String, Object> result = null;
        for (AttributeType attr : target.getAttribute()) {
            Object value = AttributeUtils.getAttributeValue(attr);
            if (StringUtils.isEmpty((String)attr.getName()) || value == null) continue;
            if (result == null) {
                result = new HashMap<String, Object>(target.getAttribute().size());
            }
            result.put(attr.getName(), value);
        }
        return result != null ? Collections.unmodifiableMap(result) : Collections.EMPTY_MAP;
    }
}

