/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.model.xpdl.xpdl2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum TestTimeType implements Enumerator
{
    BEFORE(0, "Before", "Before"),
    AFTER(1, "After", "After");

    public static final String copyright = "Copyright 2008 by SunGard";
    public static final int BEFORE_VALUE = 0;
    public static final int AFTER_VALUE = 1;
    private static final TestTimeType[] VALUES_ARRAY;
    public static final List<TestTimeType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new TestTimeType[]{BEFORE, AFTER};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static TestTimeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TestTimeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TestTimeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TestTimeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TestTimeType get(int value) {
        switch (value) {
            case 0: {
                return BEFORE;
            }
            case 1: {
                return AFTER;
            }
        }
        return null;
    }

    private TestTimeType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

