/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.projectnature.classpath;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry2;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.stardust.modeling.common.projectnature.classpath.CarnotToolClasspathProvider;
import org.osgi.framework.Bundle;

public class DeployModelNLClasspathProvider
extends CarnotToolClasspathProvider {
    private static final String TOMCAT_RUNTIME_TARGET = "org.eclipse.jst.server.core.container/org.eclipse.jst.server.tomcat.runtimeTarget";
    private static final String SRC_FOLDER = "src";
    private static final String MODELING_DEPLOY_NL_PLUGIN = "org.eclipse.stardust.modeling.deploy";

    @Override
    public IRuntimeClasspathEntry[] computeUnresolvedClasspath(ILaunchConfiguration configuration) throws CoreException {
        ArrayList<IRuntimeClasspathEntry> entries = new ArrayList<IRuntimeClasspathEntry>(Arrays.asList(super.computeUnresolvedClasspath(configuration)));
        this.removeTomcatLibraries(configuration, entries);
        Bundle deployBundle = Platform.getBundle((String)MODELING_DEPLOY_NL_PLUGIN);
        Bundle[] fragments = Platform.getFragments((Bundle)deployBundle);
        if (fragments != null) {
            int i = 0;
            while (i < fragments.length) {
                Bundle fragment = fragments[i];
                URI location = null;
                try {
                    location = FileLocator.toFileURL((URL)fragment.getEntry("/")).toURI();
                    if (fragment.getEntry(SRC_FOLDER) != null) {
                        location = location.resolve(SRC_FOLDER);
                    }
                    Path path = new Path(URIUtil.toFile((URI)location).getAbsolutePath());
                    IRuntimeClasspathEntry entry = JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)path);
                    entries.add(entry);
                }
                catch (URISyntaxException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                ++i;
            }
        }
        return entries.toArray(new IRuntimeClasspathEntry[0]);
    }

    private void removeTomcatLibraries(ILaunchConfiguration configuration, List<IRuntimeClasspathEntry> entries) throws CoreException {
        IRuntimeClasspathEntry defaultProjectEntry = null;
        IRuntimeClasspathEntry[] newRuntimeClasspathEntries = new IRuntimeClasspathEntry[]{};
        for (IRuntimeClasspathEntry runtimeClasspathEntry : entries) {
            if (!(runtimeClasspathEntry instanceof IRuntimeClasspathEntry2)) continue;
            defaultProjectEntry = runtimeClasspathEntry;
            IRuntimeClasspathEntry[] runtimeClasspathEntries = ((IRuntimeClasspathEntry2)runtimeClasspathEntry).getRuntimeClasspathEntries(configuration);
            if (runtimeClasspathEntries == null) continue;
            newRuntimeClasspathEntries = new IRuntimeClasspathEntry[runtimeClasspathEntries.length];
            int i = 0;
            int j = 0;
            while (i < runtimeClasspathEntries.length) {
                IRuntimeClasspathEntry classpathEntry = runtimeClasspathEntries[i];
                IPath rawPath = classpathEntry.getPath();
                String path = rawPath.toString();
                if (!path.startsWith(TOMCAT_RUNTIME_TARGET)) {
                    newRuntimeClasspathEntries[j] = runtimeClasspathEntries[i];
                    ++j;
                }
                ++i;
            }
        }
        entries.remove(defaultProjectEntry);
        int i = 0;
        while (i < newRuntimeClasspathEntries.length) {
            IRuntimeClasspathEntry runtimeClasspathEntry = newRuntimeClasspathEntries[i];
            if (runtimeClasspathEntry != null) {
                entries.add(runtimeClasspathEntry);
            }
            ++i;
        }
    }
}

