/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.common.ui.jface.utils;

import org.eclipse.stardust.common.StringUtils;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.widgets.Text;

public class NumericFieldVerifier
implements VerifyListener {
    private final int minValue;
    private final int maxValue;

    public NumericFieldVerifier(int minValue, int maxValue) {
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    public void verifyText(VerifyEvent e) {
        e.doit = false;
        if (Character.isDigit(e.character) && e.getSource() instanceof Text) {
            int intValue;
            Text field = (Text)e.getSource();
            StringBuffer buffer = new StringBuffer();
            buffer.append(field.getText());
            buffer.replace(e.start, e.end, e.text);
            try {
                intValue = !StringUtils.isEmpty((String)buffer.toString()) ? Integer.parseInt(buffer.toString()) : 0;
            }
            catch (NumberFormatException numberFormatException) {
                intValue = 0;
            }
            if (field.getSelectionCount() > 0 && field.getSelectionText().length() == field.getText().length()) {
                e.doit = true;
            }
            if (this.minValue <= intValue && intValue <= this.maxValue) {
                e.doit = true;
            }
        } else if (e.character == '\b') {
            e.doit = true;
        } else {
            try {
                int intValue = Integer.parseInt(e.text);
                if (this.minValue <= intValue && intValue <= this.maxValue) {
                    e.doit = true;
                }
            }
            catch (NumberFormatException numberFormatException) {
                e.doit = false;
            }
        }
    }
}

