/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors;

import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteDrawer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteGroup;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.palette.PaletteSeparator;
import org.eclipse.gef.palette.PanningSelectionToolEntry;
import org.eclipse.gef.palette.ToolEntry;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.stardust.model.xpdl.carnot.ActivityImplementationType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DiagramModeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.spi.SpiExtensionRegistry;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.DiagramEditorPage;
import org.eclipse.stardust.modeling.core.editors.DynamicConnectionFactory;
import org.eclipse.stardust.modeling.core.editors.EditPartRegistry;
import org.eclipse.stardust.modeling.core.editors.NodeCreationFactory;
import org.eclipse.stardust.modeling.core.editors.tools.CarnotConnectionCreationToolEntry;
import org.eclipse.stardust.modeling.core.editors.tools.CarnotCreationToolEntry;
import org.eclipse.stardust.modeling.core.editors.tools.CarnotSelectionTool;
import org.eclipse.stardust.modeling.core.editors.tools.PaletteFlyout;

public class WorkflowModelEditorPaletteFactory {
    public static final int CONNECTION_CONTAINER = 1;
    public static final int NODE_CONTAINER = 2;
    public static final int TRANSITION_CONNECTION = 0;
    public static final int DATA_MAPPING_CONNECTION = 1;
    public static final int EXECUTED_BY_CONNECTION = 2;
    public static final int PERFORMED_BY_CONNECTION = 3;
    public static final int PROCESS_ORGANIZATION_CONTAINER = 4;
    public static final int MODEL_ORGANIZATION_CONTAINER = 0;
    public static final int WORKS_FOR_CONNECTION = 0;
    public static final int PART_OF_CONNECTION = 1;
    public static final CarnotWorkflowModelPackage PKG_CWM = CarnotWorkflowModelPackage.eINSTANCE;
    public static final int GENERIC_DIAGRAM = 0;
    public static final int MODEL_DIAGRAM = 1;
    public static final int PROCESS_DEFINITION_DIAGRAM = 2;
    public static DiagramModeType diagramModeType = null;

    public static FlyoutPaletteComposite.FlyoutPreferences createPalettePreferences() {
        return new PalettePreferences();
    }

    public static void setDiagramModeType(DiagramModeType mode) {
        diagramModeType = mode;
    }

    public static PaletteRoot createPaletteForDiagram(DiagramEditorPage editor) {
        boolean isModelDiagram = 1 == WorkflowModelEditorPaletteFactory.getDiagramType(editor.getDiagram());
        PaletteRoot palette = new PaletteRoot();
        PaletteContainer controlGroup = WorkflowModelEditorPaletteFactory.createControlGroup(editor, isModelDiagram);
        palette.add((PaletteEntry)controlGroup);
        palette.setDefaultEntry((ToolEntry)controlGroup.getChildren().get(0));
        if (isModelDiagram) {
            palette.add(1, (PaletteEntry)WorkflowModelEditorPaletteFactory.createConnectionsContainer(editor, false));
            palette.add(2, (PaletteEntry)WorkflowModelEditorPaletteFactory.createModelNodesContainer());
        } else {
            palette.add(1, (PaletteEntry)WorkflowModelEditorPaletteFactory.createConnectionsContainer(editor, true));
            palette.add(2, (PaletteEntry)WorkflowModelEditorPaletteFactory.createProcessNodesContainer(editor));
        }
        return palette;
    }

    public static void updatePalette(DiagramEditorPage editor) {
        boolean isBusinessPerspective = false;
        PaletteRoot palette = editor.getPaletteRoot();
        PaletteContainer rootNodes = (PaletteContainer)palette.getChildren().get(2);
        List children = rootNodes.getChildren();
        int start = 1;
        int last = children.size() - 1;
        if (WorkflowModelEditorPaletteFactory.getDiagramType(editor.getDiagram()) == 2) {
            --start;
            PaletteContainer events = (PaletteContainer)children.get(--last);
            List eventsChildren = events.getChildren();
            int i = 2;
            while (i < eventsChildren.size()) {
                ((PaletteEntry)eventsChildren.get(i)).setVisible(!isBusinessPerspective);
                ++i;
            }
        }
        int i = start;
        while (i < last) {
            ((PaletteEntry)children.get(i)).setVisible(i < 3 ? isBusinessPerspective : !isBusinessPerspective);
            ++i;
        }
        if (WorkflowModelEditorPaletteFactory.getDiagramType(editor.getDiagram()) == 2 && diagramModeType != null) {
            rootNodes = (PaletteContainer)palette.getChildren().get(0);
            children = rootNodes.getChildren();
            CarnotCreationToolEntry entry = (CarnotCreationToolEntry)((Object)children.get(2));
            if (diagramModeType.equals((Object)DiagramModeType.MODE_450_LITERAL)) {
                entry.setVisible(true);
            } else {
                entry.setVisible(false);
            }
        }
    }

    private static int getDiagramType(DiagramType diagram) {
        if (diagram.eContainer() instanceof ModelType) {
            return 1;
        }
        if (diagram.eContainer() instanceof ProcessDefinitionType) {
            return 2;
        }
        return 0;
    }

    private static PaletteContainer createControlGroup(EditPartRegistry registry, boolean isModelDiagram) {
        PaletteGroup controls = new PaletteGroup(Diagram_Messages.LB_PALETTEGROUP_Controls);
        PanningSelectionToolEntry selectionEntry = new PanningSelectionToolEntry();
        selectionEntry.setToolClass(CarnotSelectionTool.class);
        selectionEntry.setLabel(Diagram_Messages.LBL_SELECT);
        controls.add((PaletteEntry)selectionEntry);
        PaletteSeparator separator = new PaletteSeparator();
        separator.setUserModificationPermission(1);
        controls.add((PaletteEntry)separator);
        controls.add((PaletteEntry)WorkflowModelEditorPaletteFactory.createSwimlaneTools(isModelDiagram, (DiagramEditorPage)registry));
        controls.add((PaletteEntry)WorkflowModelEditorPaletteFactory.createTextTools(registry));
        return controls;
    }

    private static PaletteContainer createConnectionsContainer(DiagramEditorPage editor, boolean isProcess) {
        PaletteGroup drawer = new PaletteGroup(Diagram_Messages.LB_PALETTEDRAWER_Connections);
        CarnotConnectionCreationToolEntry connectionTool = new CarnotConnectionCreationToolEntry(Diagram_Messages.WorkflowModelEditorPaletteFactory_ConnectToolLabel, Diagram_Messages.WorkflowModelEditorPaletteFactory_ConnectToolDescription, new DynamicConnectionFactory(editor.getWorkflowModelEditor()), DiagramPlugin.getImageDescriptor("icons/full/obj16/connection.gif"), DiagramPlugin.getImageDescriptor("icons/full/obj16/connection.gif"));
        connectionTool.setId("org.eclipse.stardust.modeling.core.connect");
        drawer.add((PaletteEntry)connectionTool);
        return drawer;
    }

    private static PaletteContainer createModelNodesContainer() {
        PaletteDrawer drawer = new PaletteDrawer(Diagram_Messages.LB_PALETTEDRAWER_Items, DiagramPlugin.getImageDescriptor("icons/blank16.gif"));
        drawer.add((PaletteEntry)new CarnotCreationToolEntry(Diagram_Messages.LB_TOOLENTRY_ProcessDefintion, Diagram_Messages.DESC_TOOLENTRY_CreatesNewWorkflow, NodeCreationFactory.getProcessDefinitionFactory(), DiagramPlugin.getImageDescriptor("icons/full/obj16/process.gif"), DiagramPlugin.getImageDescriptor("icons/full/obj16/process.gif")));
        CarnotCreationToolEntry tool = new CarnotCreationToolEntry(Diagram_Messages.WorkflowModelEditorPaletteFactory_LB_TOOLENTRY_Data, Diagram_Messages.WorkflowModelEditorPaletteFactory_DESC_TOOLENTRY_CreateData, NodeCreationFactory.getDataFactory(null), DiagramPlugin.getImageDescriptor("icons/full/obj16/data.gif"), DiagramPlugin.getImageDescriptor("icons/full/obj16/data.gif"));
        drawer.add((PaletteEntry)tool);
        tool = new CarnotCreationToolEntry(Diagram_Messages.WorkflowModelEditorPaletteFactory_LB_TOOLENTRY_Application, Diagram_Messages.WorkflowModelEditorPaletteFactory_DESC_TOOLENTRY_CreateApplication, NodeCreationFactory.getApplicationFactory(null), DiagramPlugin.getImageDescriptor("icons/full/obj16/application.gif"), DiagramPlugin.getImageDescriptor("icons/full/obj16/application.gif"));
        drawer.add((PaletteEntry)tool);
        drawer.add((PaletteEntry)WorkflowModelEditorPaletteFactory.createDataTools());
        drawer.add((PaletteEntry)WorkflowModelEditorPaletteFactory.createApplicationTools());
        drawer.add((PaletteEntry)WorkflowModelEditorPaletteFactory.createContextTools());
        drawer.add((PaletteEntry)WorkflowModelEditorPaletteFactory.createParticipantContainer());
        return drawer;
    }

    private static PaletteContainer createActivityTools(DiagramEditorPage editor) {
        PaletteFlyout container = new PaletteFlyout(Diagram_Messages.LB_PALETTEDRAWER_Activities, Diagram_Messages.DESC_PALETTEDRAWER_Activities, DiagramPlugin.getImageDescriptor(editor.getWorkflowModelEditor().getIconFactory().getIconFor((EObject)PKG_CWM.getActivityType())));
        container.add((PaletteEntry)new CarnotCreationToolEntry(Diagram_Messages.LB_TOOLENTRY_Route, Diagram_Messages.DESC_TOOLENTRY_CreatesNewRouteActivity, NodeCreationFactory.getActivityFactory(ActivityImplementationType.ROUTE_LITERAL), DiagramPlugin.getImageDescriptor("icons/full/obj16/activity_route.gif"), DiagramPlugin.getImageDescriptor("icons/connection24.gif")));
        container.add((PaletteEntry)new CarnotCreationToolEntry(Diagram_Messages.LB_TOOLENTRY_Manual, Diagram_Messages.DESC_TOOLENTRY_CreatesNewManualActivity, NodeCreationFactory.getActivityFactory(ActivityImplementationType.MANUAL_LITERAL), DiagramPlugin.getImageDescriptor("icons/full/obj16/activity_manual.gif"), DiagramPlugin.getImageDescriptor("icons/connection24.gif")));
        container.add((PaletteEntry)new CarnotCreationToolEntry(Diagram_Messages.LB_TOOLENTRY_Application, Diagram_Messages.DESC_TOOLENTRY_CreatesNewApplicationActivity, NodeCreationFactory.getActivityFactory(ActivityImplementationType.APPLICATION_LITERAL), DiagramPlugin.getImageDescriptor("icons/full/obj16/activity_application.gif"), DiagramPlugin.getImageDescriptor("icons/connection24.gif")));
        container.add((PaletteEntry)new CarnotCreationToolEntry(Diagram_Messages.LB_TOOLENTRY_Subprocess, Diagram_Messages.DESC_TOOLENTRY_CreatesNewSubprocessActivity, NodeCreationFactory.getActivityFactory(ActivityImplementationType.SUBPROCESS_LITERAL), DiagramPlugin.getImageDescriptor("icons/full/obj16/activity_subprocess.gif"), DiagramPlugin.getImageDescriptor("icons/connection24.gif")));
        return container;
    }

    private static PaletteContainer createProcessNodesContainer(DiagramEditorPage editor) {
        PaletteDrawer drawer = new PaletteDrawer(Diagram_Messages.LB_PALETTEDRAWER_Items, DiagramPlugin.getImageDescriptor("icons/blank16.gif"));
        CarnotCreationToolEntry tool = new CarnotCreationToolEntry(Diagram_Messages.LB_Activity, Diagram_Messages.LB_CreateActivity, NodeCreationFactory.getActivityFactory(null), DiagramPlugin.getImageDescriptor("icons/full/obj16/activity.gif"), DiagramPlugin.getImageDescriptor("icons/full/obj16/activity.gif"));
        drawer.add((PaletteEntry)tool);
        tool = new CarnotCreationToolEntry(Diagram_Messages.WorkflowModelEditorPaletteFactory_LB_TOOLENTRY_Data, Diagram_Messages.WorkflowModelEditorPaletteFactory_DESC_TOOLENTRY_CreateData, NodeCreationFactory.getDataFactory(null), DiagramPlugin.getImageDescriptor("icons/full/obj16/data.gif"), DiagramPlugin.getImageDescriptor("icons/full/obj16/data.gif"));
        drawer.add((PaletteEntry)tool);
        tool = new CarnotCreationToolEntry(Diagram_Messages.WorkflowModelEditorPaletteFactory_LB_TOOLENTRY_Application, Diagram_Messages.WorkflowModelEditorPaletteFactory_DESC_TOOLENTRY_CreateApplication, NodeCreationFactory.getApplicationFactory(null), DiagramPlugin.getImageDescriptor("icons/full/obj16/application.gif"), DiagramPlugin.getImageDescriptor("icons/full/obj16/application.gif"));
        drawer.add((PaletteEntry)tool);
        drawer.add((PaletteEntry)WorkflowModelEditorPaletteFactory.createActivityTools(editor));
        drawer.add((PaletteEntry)WorkflowModelEditorPaletteFactory.createDataTools());
        drawer.add((PaletteEntry)WorkflowModelEditorPaletteFactory.createApplicationTools());
        drawer.add((PaletteEntry)WorkflowModelEditorPaletteFactory.createContextTools());
        drawer.add((PaletteEntry)WorkflowModelEditorPaletteFactory.createStartingTools());
        drawer.add((PaletteEntry)WorkflowModelEditorPaletteFactory.createParticipantContainer());
        return drawer;
    }

    private static ToolEntry createSwimlaneTools(boolean isModelDiagram, DiagramEditorPage editor) {
        if (isModelDiagram) {
            CarnotCreationToolEntry toolEntry = new CarnotCreationToolEntry(Diagram_Messages.LB_TOOLENTRY_Pool, Diagram_Messages.DESC_TOOLENTRY_CreatesNewPool, NodeCreationFactory.getPoolFactory(), DiagramPlugin.getImageDescriptor("icons/full/obj16/pool.gif"), DiagramPlugin.getImageDescriptor("icons/pool24.gif"));
            toolEntry.setVisible(false);
            return toolEntry;
        }
        CarnotCreationToolEntry toolEntry = new CarnotCreationToolEntry(Diagram_Messages.LB_TOOLENTRY_Lane, Diagram_Messages.DESC_TOOLENTRY_CreatesNewLane, NodeCreationFactory.getLaneFactory(), DiagramPlugin.getImageDescriptor("icons/full/obj16/lane.gif"), DiagramPlugin.getImageDescriptor("icons/lane24.gif"));
        if (editor.getDiagram().getMode().equals((Object)DiagramModeType.MODE_450_LITERAL)) {
            toolEntry.setVisible(true);
        } else {
            toolEntry.setVisible(false);
        }
        return toolEntry;
    }

    private static PaletteContainer createTextTools(EditPartRegistry registry) {
        PaletteFlyout textTools = new PaletteFlyout(Diagram_Messages.LB_PALETTESTACK_Annotations, Diagram_Messages.DESC_PALETTESTACK_CreateAnnotation, DiagramPlugin.getImageDescriptor("icons/full/obj16/annotation.gif"));
        textTools.add((PaletteEntry)new CarnotCreationToolEntry(Diagram_Messages.LB_TOOLENTRY_Annotation, Diagram_Messages.DESC_TOOLENTRY_CreatesNewAnnotation, NodeCreationFactory.getAnnotationFactory(registry), DiagramPlugin.getImageDescriptor("icons/full/obj16/annotation.gif"), DiagramPlugin.getImageDescriptor("icons/connection24.gif")));
        textTools.add((PaletteEntry)new CarnotCreationToolEntry(Diagram_Messages.LB_TOOLENTRY_Text, Diagram_Messages.DESC_TOOLENTRY_CreatesNewTextField, NodeCreationFactory.getTextFactory(registry), DiagramPlugin.getImageDescriptor("icons/full/obj16/text.gif"), DiagramPlugin.getImageDescriptor("icons/connection24.gif")));
        return textTools;
    }

    private static PaletteContainer createContextTools() {
        PaletteFlyout applicationTools = new PaletteFlyout(Diagram_Messages.LB_PALETTESTACK_Contexts, Diagram_Messages.DESC_PALETTESTACK_CreateInteractiveApplications, DiagramPlugin.getImageDescriptor("icons/full/obj16/contexts.gif"));
        SpiExtensionRegistry registry = SpiExtensionRegistry.instance();
        Map extensions = registry.getExtensions("contextTypes");
        for (IConfigurationElement config : extensions.values()) {
            String id = config.getAttribute("id");
            if (ActivityUtil.isImplicitContext((String)id)) continue;
            CarnotCreationToolEntry tool = new CarnotCreationToolEntry(config.getAttribute("name"), String.valueOf(Diagram_Messages.DESC_TOOLENTRY_P1_CreatesNew) + id + Diagram_Messages.DESC_TOOLENTRY_P2_interactiveApplication, NodeCreationFactory.getContextFactory(config), DiagramPlugin.getImageDescriptor(config), DiagramPlugin.getImageDescriptor("icons/connection24.gif"));
            applicationTools.add((PaletteEntry)tool);
        }
        return applicationTools;
    }

    private static PaletteContainer createApplicationTools() {
        PaletteFlyout applicationTools = new PaletteFlyout(Diagram_Messages.LB_PALETTESTACK_Applications, Diagram_Messages.DESC_PALETTESTACK_CreateNoninteractiveApplications, DiagramPlugin.getImageDescriptor("icons/full/obj16/applications.gif"));
        SpiExtensionRegistry registry = SpiExtensionRegistry.instance();
        Map extensions = registry.getExtensions("applicationTypes");
        for (IConfigurationElement config : extensions.values()) {
            CarnotCreationToolEntry tool = new CarnotCreationToolEntry(config.getAttribute("name"), String.valueOf(Diagram_Messages.LB_TOOLENTRY_P1_CreatesNew) + config.getAttribute("name") + Diagram_Messages.LB_TOOLENTRY_P2_application, NodeCreationFactory.getApplicationFactory(config), DiagramPlugin.getImageDescriptor(config), DiagramPlugin.getImageDescriptor("icons/connection24.gif"));
            applicationTools.add((PaletteEntry)tool);
        }
        return applicationTools;
    }

    private static PaletteContainer createStartingTools() {
        PaletteFlyout startingTools = new PaletteFlyout(Diagram_Messages.LB_PALETTEDRAWER_ProcessLifecycle, Diagram_Messages.DESC_PALETTEDRAWER_ProcessLifecycle, DiagramPlugin.getImageDescriptor("icons/full/obj16/trigger.gif"));
        CarnotCreationToolEntry startTool = new CarnotCreationToolEntry(Diagram_Messages.LB_TOOLENTRY_StartEvent, Diagram_Messages.DESC_TOOLENTRY_CreatesNewStartEvent, NodeCreationFactory.getEventFactory(null, false), DiagramPlugin.getImageDescriptor("icons/full/obj16/start_event.gif"), DiagramPlugin.getImageDescriptor("icons/connection24.gif"));
        CarnotCreationToolEntry endTool = new CarnotCreationToolEntry(Diagram_Messages.LB_TOOLENTRY_EndEvent, Diagram_Messages.DESC_TOOLENTRY_CreatesNewEndEvent, NodeCreationFactory.getEventFactory(null, true), DiagramPlugin.getImageDescriptor("icons/full/obj16/end_event.gif"), DiagramPlugin.getImageDescriptor("icons/connection24.gif"));
        startingTools.add((PaletteEntry)startTool);
        startingTools.add((PaletteEntry)endTool);
        SpiExtensionRegistry registry = SpiExtensionRegistry.instance();
        Map extensions = registry.getExtensions("triggerTypes");
        for (IConfigurationElement config : extensions.values()) {
            CarnotCreationToolEntry tool = new CarnotCreationToolEntry(config.getAttribute("name"), String.valueOf(Diagram_Messages.LB_TOOLENTRY_P1_CreatesNew) + config.getAttribute("id") + Diagram_Messages.LB_TOOLENTRY_P2_trigger, NodeCreationFactory.getEventFactory(config, false), DiagramPlugin.getImageDescriptor(config), DiagramPlugin.getImageDescriptor("icons/connection24.gif"));
            startingTools.add((PaletteEntry)tool);
        }
        return startingTools;
    }

    private static PaletteContainer createDataTools() {
        PaletteFlyout dataTools = new PaletteFlyout(Diagram_Messages.LB_PALETTESTACK_Data, Diagram_Messages.DESC_PALETTESTACK_CreateData, DiagramPlugin.getImageDescriptor("icons/full/obj16/data.gif"));
        SpiExtensionRegistry registry = SpiExtensionRegistry.instance();
        Map extensions = registry.getExtensions("dataTypes");
        for (IConfigurationElement config : extensions.values()) {
            CarnotCreationToolEntry tool = new CarnotCreationToolEntry(config.getAttribute("name"), String.valueOf(Diagram_Messages.LB_TOOLENTRY_P1_CreatesNew) + config.getAttribute("id") + Diagram_Messages.LB_TOOLENTRY_P2_workflowData, NodeCreationFactory.getDataFactory(config), DiagramPlugin.getImageDescriptor(config), DiagramPlugin.getImageDescriptor("icons/connection24.gif"));
            dataTools.add((PaletteEntry)tool);
            if (!"primitive".equals(config.getAttribute("id"))) continue;
            dataTools.setActiveEntry((PaletteEntry)tool);
        }
        return dataTools;
    }

    private static PaletteContainer createParticipantContainer() {
        PaletteFlyout participantsTools = new PaletteFlyout(Diagram_Messages.LB_PALETTESTACK_Participants, Diagram_Messages.DESC_PALETTESTACK_Participants, DiagramPlugin.getImageDescriptor("icons/full/obj16/participants.gif"));
        participantsTools.add((PaletteEntry)new CarnotCreationToolEntry(Diagram_Messages.LB_TOOLENTRY_Role, Diagram_Messages.DESC_TOOLENTRY_CreatesNewWorkflowRole, NodeCreationFactory.getRoleFactory(), DiagramPlugin.getImageDescriptor("icons/full/obj16/role.gif"), DiagramPlugin.getImageDescriptor("icons/connection24.gif")));
        participantsTools.add((PaletteEntry)new CarnotCreationToolEntry(Diagram_Messages.LB_TOOLENTRY_Organization, Diagram_Messages.DESC_TOOLENTRY_CreatesNewWorkflowOrganization, NodeCreationFactory.getOrganizationFactory(), DiagramPlugin.getImageDescriptor("icons/full/obj16/organization.gif"), DiagramPlugin.getImageDescriptor("icons/connection24.gif")));
        participantsTools.add((PaletteEntry)new CarnotCreationToolEntry(Diagram_Messages.LB_TOOLENTRY_ConditionalPerformer, Diagram_Messages.DESC_TOOLENTRY_CreatesNewWorkflowCondPerformer, NodeCreationFactory.getConditionalPerformerFactory(), DiagramPlugin.getImageDescriptor("icons/full/obj16/conditional.gif"), DiagramPlugin.getImageDescriptor("icons/connection24.gif")));
        return participantsTools;
    }

    private static final class PalettePreferences
    implements FlyoutPaletteComposite.FlyoutPreferences {
        private PalettePreferences() {
        }

        private IPreferenceStore getPreferenceStore() {
            return DiagramPlugin.getDefault().getPreferenceStore();
        }

        public int getDockLocation() {
            return this.getPreferenceStore().getInt("WorkflowDiagramEditorPaletteFactory.Location");
        }

        public int getPaletteState() {
            return this.getPreferenceStore().getInt("WorkflowDiagramEditorPaletteFactory.State");
        }

        public int getPaletteWidth() {
            return this.getPreferenceStore().getInt("WorkflowDiagramEditorPaletteFactory.Size");
        }

        public void setDockLocation(int location) {
            this.getPreferenceStore().setValue("WorkflowDiagramEditorPaletteFactory.Location", location);
        }

        public void setPaletteState(int state) {
            this.getPreferenceStore().setValue("WorkflowDiagramEditorPaletteFactory.State", state);
        }

        public void setPaletteWidth(int width) {
            this.getPreferenceStore().setValue("WorkflowDiagramEditorPaletteFactory.Size", width);
        }
    }
}

