/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.figures;

import org.eclipse.draw2d.ColorConstants;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.Polygon;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.stardust.modeling.core.editors.figures.IGraphicalObjectFigure;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.GatewaySymbolEditPart;
import org.eclipse.swt.graphics.Color;

public class GatewayFigure
extends Polygon
implements IGraphicalObjectFigure {
    public static final int GATEWAY_TYPE_XOR = 0;
    public static final int GATEWAY_TYPE_OR = 1;
    public static final int GATEWAY_TYPE_AND = 2;
    public static final int GATEWAY_TYPE_COMPLEX = 3;
    public static final int XOR_TYPE_DATA = 0;
    public static final int XOR_TYPE_EVENT = 1;
    private static final int BORDER_LINE_WIDTH = 1;
    private int gatewayType;
    private int kind;
    private Color borderColor;
    private Color fillColor;
    private GatewaySymbolEditPart editPart;

    public GatewayFigure(GatewaySymbolEditPart gatewaySymbolEditPart) {
        this.editPart = gatewaySymbolEditPart;
        this.setOutline(true);
        this.setFill(true);
    }

    public GatewaySymbolEditPart getEditPart() {
        return this.editPart;
    }

    public int getKind() {
        return this.kind;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    public void setTypeIndicator(int gatewayType) {
        this.gatewayType = gatewayType;
        this.repaint();
    }

    protected boolean useLocalCoordinates() {
        return true;
    }

    public Dimension getMinimumSize(int wHint, int hHint) {
        return new Dimension(40, 40);
    }

    public Dimension getPreferredSize(int wHint, int hHint) {
        return this.getMinimumSize();
    }

    public void setBounds(Rectangle rect) {
        this.removeAllPoints();
        int width = 2 * ((rect.width + 1) / 2) - 1;
        int height = 2 * ((rect.height + 1) / 2) - 1;
        int left = rect.x;
        int top = rect.y;
        int center = rect.x + width / 2;
        int middle = rect.y + height / 2;
        int right = 2 * center - left;
        int bottom = 2 * middle - top;
        this.addPoint(new Point(center, top));
        this.addPoint(new Point(left, middle));
        this.addPoint(new Point(center, bottom));
        this.addPoint(new Point(right, middle));
        super.setBounds(rect);
    }

    protected void outlineShape(Graphics g) {
        g.setLineWidth(1);
        g.setForegroundColor(this.borderColor == null ? ColorConstants.gray : this.borderColor);
        super.outlineShape(g);
        switch (this.gatewayType) {
            case 2: {
                g.setLineWidth(3);
                Rectangle rect = this.getBounds();
                g.drawLine(Math.round(rect.x + rect.width / 4), Math.round(rect.y + rect.height / 2), Math.round(rect.x + rect.width * 3 / 4), Math.round(rect.y + rect.height / 2));
                g.drawLine(Math.round(rect.x + rect.width / 2), Math.round(rect.y + rect.height / 4), Math.round(rect.x + rect.width / 2), Math.round(rect.y + rect.height * 3 / 4));
                break;
            }
            case 1: {
                g.setLineWidth(3);
                Rectangle rect = this.getBounds();
                g.drawOval(Math.round(rect.x + rect.width / 4), Math.round(rect.y + rect.height / 4), Math.round(rect.width / 2), Math.round(rect.height / 2));
            }
        }
    }

    @Override
    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    @Override
    public void setFillColor(Color color) {
        this.fillColor = color;
    }
}

