/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.tools.ToolUtilities;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramRootEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.SymbolGroupEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.actions.ReloadConnectionsRequest;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DelegateCommand;
import org.eclipse.stardust.modeling.core.editors.ui.TreeNode;
import org.eclipse.stardust.modeling.core.editors.ui.TreeNodeContentProvider;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPart;

public class ReloadConnectionsAction
extends SelectionAction {
    public static final String REQ_RELOAD_CONNECTIONS = "org.eclipse.stardust.modeling.core.reloadConnections";
    public static final String RELOAD_CONNECTIONS_LABEL = Diagram_Messages.RELOAD_CONNECTIONS_LABEL;

    public ReloadConnectionsAction(WorkflowModelEditor editor) {
        super((IWorkbenchPart)editor);
        this.setId(REQ_RELOAD_CONNECTIONS);
        this.setText(RELOAD_CONNECTIONS_LABEL);
    }

    public boolean isEnabled() {
        this.update();
        return super.isEnabled();
    }

    protected boolean calculateEnabled() {
        CompoundCommand cmd = this.createReloadCommand();
        if (cmd == null) {
            return false;
        }
        return cmd.canExecute();
    }

    public void run() {
        CompoundCommand cmd = this.createReloadCommand();
        if (!cmd.isEmpty()) {
            HashMap<Object, Boolean> selection = new HashMap<Object, Boolean>();
            Dialog dialog = this.createDialog((Command)cmd, selection);
            if (dialog.open() == 0 && this.filter(cmd, selection)) {
                this.execute((Command)cmd);
            }
            PoolLaneUtils.refreshLaneContent();
        }
    }

    public void runEmbedded(DelegateCommand compound) {
        CompoundCommand cmd = this.createReloadCommand();
        if (!cmd.isEmpty()) {
            HashMap<Object, Boolean> selection = new HashMap<Object, Boolean>();
            Dialog dialog = this.createDialog((Command)cmd, selection);
            if (dialog.open() == 0 && this.filter(cmd, selection)) {
                compound.setDelegate((Command)cmd);
            }
            PoolLaneUtils.refreshLaneContent();
        }
    }

    private boolean filter(CompoundCommand command, Map<Object, Boolean> selection) {
        List commands = command.getCommands();
        Iterator itr = commands.iterator();
        while (itr.hasNext()) {
            Command cmd = (Command)itr.next();
            Boolean status = selection.get(cmd);
            if (cmd instanceof CompoundCommand) {
                CompoundCommand compound = (CompoundCommand)cmd;
                this.filter(compound, selection);
                if (!compound.isEmpty()) continue;
                itr.remove();
                continue;
            }
            if (status == null || status.booleanValue()) continue;
            itr.remove();
        }
        return !command.isEmpty();
    }

    private Dialog createDialog(final Command cmd, final Map<Object, Boolean> selection) {
        return new Dialog(this.getWorkbenchPart().getSite().getShell()){

            protected Control createDialogArea(Composite parent) {
                this.getShell().setText(Diagram_Messages.TXT_AvailableConnections);
                Composite composite = (Composite)super.createDialogArea(parent);
                Tree tree = new Tree(composite, 2080);
                GridData gd = new GridData(1808);
                gd.minimumWidth = 450;
                gd.minimumHeight = 250;
                tree.setLayoutData((Object)gd);
                TreeViewer viewer = new TreeViewer(tree);
                viewer.setContentProvider((IContentProvider)new TreeNodeContentProvider());
                viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

                    public String getText(Object element) {
                        TreeNode node = (TreeNode)element;
                        Command cmd = (Command)node.getValue();
                        if (cmd == null) {
                            return Diagram_Messages.TXT_DIAGRAM;
                        }
                        return cmd.getLabel();
                    }
                });
                viewer.setInput((Object)ReloadConnectionsAction.this.getNode(cmd, 0).getChildren());
                viewer.expandAll();
                ReloadConnectionsAction.this.checkAll(tree.getItems(), selection, true);
                tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

                    public void widgetSelected(SelectionEvent e) {
                        if (e.detail == 32) {
                            TreeItem item = (TreeItem)e.item;
                            boolean checked = item.getChecked();
                            ReloadConnectionsAction.this.setState(item, selection, checked);
                            this.validate();
                        }
                    }
                });
                this.validate();
                return composite;
            }

            private void validate() {
                boolean isValid = ReloadConnectionsAction.this.filter(this.createDuplicate((CompoundCommand)cmd), selection);
                Button okButton = this.getButton(0);
                if (okButton != null) {
                    okButton.setEnabled(isValid);
                }
            }

            private CompoundCommand createDuplicate(CompoundCommand cmd2) {
                CompoundCommand command = new CompoundCommand();
                List commands = cmd2.getCommands();
                for (Command cmd_ : commands) {
                    if (cmd_ instanceof CompoundCommand) {
                        command.add((Command)this.createDuplicate((CompoundCommand)cmd_));
                        continue;
                    }
                    command.add(cmd_);
                }
                return command;
            }
        };
    }

    private void setState(TreeItem item, Map<Object, Boolean> selection, boolean checked) {
        TreeNode node = (TreeNode)item.getData();
        if (node.getValue() != null) {
            selection.put(node.getValue(), checked ? Boolean.TRUE : Boolean.FALSE);
        }
        this.checkAll(item.getItems(), selection, checked);
    }

    private void checkAll(TreeItem[] items, Map<Object, Boolean> selection, boolean checked) {
        if (items != null) {
            int i = 0;
            while (i < items.length) {
                TreeItem item = items[i];
                item.setChecked(checked);
                this.setState(item, selection, checked);
                ++i;
            }
        }
    }

    private TreeNode getNode(Command cmd, int rootCnt) {
        TreeNode node = new TreeNode(++rootCnt <= 2 && cmd instanceof CompoundCommand ? null : cmd);
        if (cmd instanceof CompoundCommand) {
            CompoundCommand comp = (CompoundCommand)cmd;
            List cmds = comp.getCommands();
            TreeNode[] children = new TreeNode[cmds.size()];
            int i = 0;
            while (i < cmds.size()) {
                Command command = (Command)cmds.get(i);
                children[i] = this.getNode(command, rootCnt);
                children[i].setParent(node);
                ++i;
            }
            node.setChildren(children);
        }
        return node;
    }

    public CompoundCommand createReloadCommand() {
        ReloadConnectionsRequest request = new ReloadConnectionsRequest();
        List<EditPart> editparts = this.getOperationSet((Request)request);
        if (editparts.isEmpty()) {
            return null;
        }
        CompoundCommand command = new CompoundCommand();
        command.setDebugLabel(this.getText());
        int i = 0;
        while (i < editparts.size()) {
            EditPart part = editparts.get(i);
            command.add(part.getCommand((Request)request));
            ++i;
        }
        this.filterEmptyCommandsAndDuplicates(new HashSet<Command>(), command);
        return command;
    }

    private void filterEmptyCommandsAndDuplicates(Set<Command> existingCommands, CompoundCommand command) {
        List commands = command.getCommands();
        Iterator itr = commands.iterator();
        while (itr.hasNext()) {
            Command cmd = (Command)itr.next();
            if (cmd instanceof CompoundCommand) {
                CompoundCommand compound = (CompoundCommand)cmd;
                this.filterEmptyCommandsAndDuplicates(existingCommands, compound);
                if (!compound.isEmpty()) continue;
                itr.remove();
                continue;
            }
            if (existingCommands.contains(cmd)) {
                itr.remove();
                continue;
            }
            existingCommands.add(cmd);
        }
    }

    protected List<EditPart> getOperationSet(Request request) {
        List<EditPart> containers;
        ArrayList<EditPart> editparts = new ArrayList<EditPart>(this.getSelectedObjects());
        this.filterNonGraphicalEditParts(editparts);
        while (!(containers = this.filterContainers(editparts)).isEmpty()) {
            int i = 0;
            while (i < containers.size()) {
                editparts.addAll(containers.get(i).getChildren());
                ++i;
            }
        }
        DiagramRootEditPart rootEditPart = null;
        for (EditPart editPart : editparts) {
            if (!(editPart instanceof DiagramRootEditPart)) continue;
            rootEditPart = (DiagramRootEditPart)editPart;
        }
        ToolUtilities.filterEditPartsUnderstanding(editparts, (Request)request);
        if (rootEditPart != null) {
            editparts.add((EditPart)rootEditPart);
        }
        return editparts;
    }

    private List<EditPart> filterContainers(List<EditPart> editparts) {
        ArrayList<EditPart> containers = new ArrayList<EditPart>();
        Iterator<EditPart> iter = editparts.iterator();
        while (iter.hasNext()) {
            EditPart ep = iter.next();
            if (!(ep.getModel() instanceof ISymbolContainer)) continue;
            iter.remove();
            containers.add(ep);
        }
        return containers;
    }

    private void filterNonGraphicalEditParts(List<EditPart> editparts) {
        Iterator<EditPart> iter = editparts.iterator();
        while (iter.hasNext()) {
            EditPart next = iter.next();
            if (next instanceof GraphicalEditPart && !(next instanceof SymbolGroupEditPart)) continue;
            iter.remove();
        }
    }
}

