/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.actions;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.ui.actions.SelectionAction;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.IModelParticipant;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.DiagramEditorPage;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.LaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.properties.DefaultPropSheetCmdFactory;
import org.eclipse.stardust.modeling.core.utils.HierarchyUtils;
import org.eclipse.stardust.modeling.core.utils.IdentifiableViewerSorter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.ui.IWorkbenchPart;

public class SetDefaultParticipantAction
extends SelectionAction {
    public SetDefaultParticipantAction(WorkflowModelEditor editor) {
        super((IWorkbenchPart)editor);
    }

    protected boolean calculateEnabled() {
        if (this.getSelectedObjects().size() == 1) {
            LaneSymbol lane = this.getLane();
            if (lane != null && HierarchyUtils.hasChildLanesParticipant(lane)) {
                return false;
            }
            return lane != null && this.getParticipants() != null;
        }
        return false;
    }

    public void run() {
        IModelParticipant[] participant = new IModelParticipant[1];
        Dialog dialog = this.createDialog(participant);
        if (dialog.open() == 0) {
            DiagramEditorPage page;
            WorkflowModelEditor editor = (WorkflowModelEditor)this.getWorkbenchPart();
            DiagramEditorPage diagramEditorPage = page = editor.getCurrentPage() instanceof DiagramEditorPage ? (DiagramEditorPage)editor.getCurrentPage() : null;
            if (page != null) {
                Command cmd = DefaultPropSheetCmdFactory.INSTANCE.getSetCommand(page.findEditPart(this.getLane()), (EObject)this.getLane(), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getISwimlaneSymbol_ParticipantReference(), participant[0]);
                this.execute(cmd);
            }
        }
    }

    private Dialog createDialog(final IModelParticipant[] participant) {
        return new Dialog(this.getWorkbenchPart().getSite().getShell()){

            protected Control createDialogArea(Composite parent) {
                this.getShell().setText(Diagram_Messages.TXT_DefaultLaneParticipant);
                Composite composite = (Composite)super.createDialogArea(parent);
                SetDefaultParticipantAction.this.createContent(composite, participant);
                return composite;
            }
        };
    }

    private void createContent(Composite composite, final IModelParticipant[] participant) {
        Table table = new Table(composite, 2048);
        GridData gd = new GridData(1808);
        gd.minimumWidth = 350;
        gd.minimumHeight = 250;
        table.setLayoutData((Object)gd);
        final TableViewer viewer = new TableViewer(table);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                IModelParticipant participant = (IModelParticipant)element;
                return participant.getName();
            }

            public Image getImage(Object element) {
                return DiagramPlugin.getImage(((WorkflowModelEditor)SetDefaultParticipantAction.this.getWorkbenchPart()).getIconFactory().getIconFor((EObject)((IModelParticipant)element)));
            }
        });
        viewer.setSorter((ViewerSorter)new IdentifiableViewerSorter());
        viewer.setInput((Object)this.getParticipants());
        table.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                participant[0] = (IModelParticipant)((IStructuredSelection)viewer.getSelection()).getFirstElement();
            }
        });
        LaneSymbol lane = this.getLane();
        if (lane.getParticipantReference() != null) {
            viewer.setSelection((ISelection)new StructuredSelection((Object)lane.getParticipantReference()));
            participant[0] = lane.getParticipantReference();
        }
    }

    private ArrayList getParticipants() {
        ModelType model;
        LaneSymbol lane = this.getLane();
        List participants = HierarchyUtils.getParticipants(lane, model = ModelUtils.findContainingModel((EObject)lane));
        if (participants != null && !participants.isEmpty()) {
            return (ArrayList)participants;
        }
        return null;
    }

    private LaneSymbol getLane() {
        Object selection = this.getSelectedObjects().get(0);
        if (selection instanceof LaneEditPart) {
            return (LaneSymbol)((LaneEditPart)selection).getModel();
        }
        return null;
    }

    protected void init() {
        super.init();
        this.setId("org.eclipse.stardust.modeling.core.setParticipant");
        this.setText(Diagram_Messages.TXT_SetDefaultParticipant);
    }
}

