/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.parts.diagram.policies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.PrecisionPoint;
import org.eclipse.draw2d.geometry.PrecisionRectangle;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.gef.commands.UnexecutableCommand;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.XYLayoutEditPolicy;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DiagramModeType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IGraphicalObject;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.OrientationType;
import org.eclipse.stardust.model.xpdl.carnot.util.DiagramUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.NodeCreationFactory;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.figures.ActivitySymbolFigure;
import org.eclipse.stardust.modeling.core.editors.figures.LaneFigure;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractNodeSymbolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.AbstractSwimlaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.DiagramEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.LaneEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.PoolEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.SymbolGroupEditPart;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.ChangeConstraintCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CompoundDiagramCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateModelElementCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.CreateSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.DelegatingCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.IDiagramCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.MoveNodeSymbolCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.MoveSymbolCommandUtils;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.commands.SetSymbolContainerCommand;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.NodeSymbolResizableEditPolicy;
import org.eclipse.stardust.modeling.core.editors.parts.diagram.policies.ProxyChangeBoundsRequest;
import org.eclipse.stardust.modeling.core.editors.tools.SnapCenterToGrid;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.core.utils.PoolLaneUtils;
import org.eclipse.stardust.modeling.core.utils.SnapGridUtils;
import org.eclipse.ui.PlatformUI;

public class SymbolContainerLayoutEditPolicy
extends XYLayoutEditPolicy {
    private static CarnotWorkflowModelPackage PKG = CarnotWorkflowModelPackage.eINSTANCE;
    private Request request = null;

    protected Command getAddCommand(Request generic) {
        this.request = generic;
        Command command = super.getAddCommand(generic);
        this.request = null;
        return command;
    }

    private Request getRequest() {
        return this.request;
    }

    protected Command createAddCommand(EditPart child, Object constraint) {
        return this.createChangeConstraintCommand(child, constraint);
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        List changedParts = request instanceof ProxyChangeBoundsRequest ? ((ProxyChangeBoundsRequest)request).getOther().getEditParts() : request.getEditParts();
        return this.doCreateChangeConstraintCommand(request, child, changedParts, constraint);
    }

    protected Command createChangeConstraintCommand(EditPart target, Object constraint) {
        return this.doCreateChangeConstraintCommand((ChangeBoundsRequest)this.getRequest(), target, Collections.singletonList(target), constraint);
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        return child instanceof AbstractNodeSymbolEditPart ? new NodeSymbolResizableEditPolicy() : super.createChildEditPolicy(child);
    }

    protected Command doCreateChangeConstraintCommand(ChangeBoundsRequest request, final EditPart target, List changedParts, Object constraint) {
        Integer changeChildLanes;
        Object result = UnexecutableCommand.INSTANCE;
        Object type = request.getType();
        if (type.equals("resize children")) {
            int resizeDirection = request.getResizeDirection();
            PoolLaneUtils.setResizeFlags(resizeDirection);
        } else {
            PoolLaneUtils.setResizeFlags(-1);
        }
        if (type.equals("resize children") && target instanceof SymbolGroupEditPart) {
            return result;
        }
        Point mouseLocation = new Point(0, 0);
        if (request.getLocation() != null) {
            mouseLocation = request.getLocation().getCopy();
        }
        Point viewPortPoint = PoolLaneUtils.findViewportPoint((GraphicalEditPart)target);
        mouseLocation.performTranslate(viewPortPoint.x, viewPortPoint.y);
        boolean isColliding = MoveSymbolCommandUtils.isSymbolCollision(changedParts, this.getHost(), target, constraint);
        DiagramType diagram = ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)target.getModel()));
        if (diagram == null) {
            return result;
        }
        OrientationType direction = diagram.getOrientation();
        if (diagram.getMode().equals((Object)DiagramModeType.MODE_450_LITERAL) && DiagramUtil.getDefaultPool((DiagramType)diagram) != null) {
            if (target instanceof LaneEditPart) {
                isColliding = false;
            } else if (isColliding) {
                return result;
            }
        }
        if (("move children".equals(type) || "move".equals(type) || "align children".equals(type) || "align".equals(type)) && target instanceof PoolEditPart && DiagramUtil.isDefaultPool((ISwimlaneSymbol)((PoolEditPart)target).getPoolModel())) {
            return result;
        }
        Rectangle boundsRect = ((Rectangle)constraint).getCopy();
        if ("resize children".equals(type) && target instanceof LaneEditPart) {
            LaneEditPart laneEP = (LaneEditPart)target;
            LaneFigure laneFigure = (LaneFigure)laneEP.getFigure();
            if (laneFigure.isCollapsed()) {
                return result;
            }
            if (!diagram.getMode().equals((Object)DiagramModeType.MODE_450_LITERAL)) {
                this.setLaneBoundsToMinSize(boundsRect, (LaneEditPart)target, !isColliding);
            }
        }
        if (this.getHost() instanceof DiagramEditPart && target instanceof LaneEditPart) {
            return result;
        }
        if (target instanceof LaneEditPart && !"resize children".equals(type)) {
            mouseLocation = PoolLaneUtils.getLocation((GraphicalEditPart)target.getParent(), (IFigure)((AbstractSwimlaneEditPart)this.getHost()).getSwimlaneFigure(), mouseLocation, false);
        }
        if (isColliding) {
            return result;
        }
        ChangeConstraintCommand cmd = new ChangeConstraintCommand();
        cmd.setTarget(target);
        cmd.setHost(this.getHost());
        cmd.setColliding(isColliding);
        cmd.setPart((INodeSymbol)target.getModel());
        if ("move children".equals(type) || "move".equals(type) || "align children".equals(type) || "align".equals(type)) {
            if (diagram.getMode().equals((Object)DiagramModeType.MODE_450_LITERAL) && DiagramUtil.getDefaultPool((DiagramType)diagram) != null && target instanceof LaneEditPart) {
                cmd.setLocation(mouseLocation);
            } else {
                cmd.setLocation(boundsRect.getLocation().getCopy());
            }
        } else {
            cmd.setBounds(boundsRect);
        }
        if (diagram.getMode().equals((Object)DiagramModeType.MODE_450_LITERAL) && DiagramUtil.getDefaultPool((DiagramType)diagram) != null && target instanceof AbstractSwimlaneEditPart) {
            cmd.setSnapToGrid(false);
        }
        result = cmd;
        if (!(target instanceof AbstractSwimlaneEditPart)) {
            if (diagram.getMode().equals((Object)DiagramModeType.MODE_450_LITERAL) && DiagramUtil.getDefaultPool((DiagramType)diagram) != null) {
                final EditPart host = this.getHost();
                if (host instanceof DiagramEditPart) {
                    return UnexecutableCommand.INSTANCE;
                }
                if (host instanceof AbstractSwimlaneEditPart) {
                    result = result.chain((Command)new DelegatingCommand(){

                        @Override
                        public Command createDelegate() {
                            return PoolLaneUtils.resizeLane((AbstractSwimlaneEditPart)host);
                        }
                    });
                    result = result.chain((Command)new DelegatingCommand(){

                        @Override
                        public Command createDelegate() {
                            return PoolLaneUtils.reorderSiblings(host, null);
                        }
                    });
                }
            }
            return result;
        }
        if (!diagram.getMode().equals((Object)DiagramModeType.MODE_450_LITERAL) && DiagramUtil.getDefaultPool((DiagramType)diagram) != null) {
            return result;
        }
        Rectangle targetRectangle = GenericUtils.getSymbolRectangle(target);
        boolean canChange = true;
        Rectangle containerBounds = GenericUtils.getSymbolRectangle(this.getHost());
        if ("add children".equals(type) && (PoolLaneUtils.containsOthers((AbstractSwimlaneEditPart)this.getHost()) || !PoolLaneUtils.containsLanes((EditPart)((AbstractSwimlaneEditPart)this.getHost())))) {
            changeChildLanes = OrientationType.VERTICAL_LITERAL.equals((Object)direction) ? (containerBounds.height > boundsRect.height ? new Integer(3) : new Integer(2)) : (containerBounds.width > boundsRect.width ? new Integer(3) : new Integer(2));
        } else if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
            if (targetRectangle.width != boundsRect.width) {
                canChange = false;
            }
            changeChildLanes = targetRectangle.height > boundsRect.height ? new Integer(1) : new Integer(2);
        } else {
            if (targetRectangle.height != boundsRect.height) {
                canChange = false;
            }
            changeChildLanes = targetRectangle.width > boundsRect.width ? new Integer(1) : new Integer(2);
        }
        if (diagram.getMode().equals((Object)DiagramModeType.MODE_450_LITERAL) && DiagramUtil.getDefaultPool((DiagramType)diagram) != null) {
            if ("resize children".equals(type) && !PoolLaneUtils.canChange(target) && !canChange) {
                return UnexecutableCommand.INSTANCE;
            }
            if (("move children".equals(type) || "move".equals(type) || "align children".equals(type) || "align".equals(type)) && target instanceof LaneEditPart && PoolLaneUtils.containsLanes(this.getHost()) && !PoolLaneUtils.isSensitiveArea((AbstractSwimlaneEditPart)this.getHost(), mouseLocation)) {
                return UnexecutableCommand.INSTANCE;
            }
            int newWidthSpace = boundsRect.width - targetRectangle.width;
            int newHeightSpace = boundsRect.height - targetRectangle.height;
            if ("resize children".equals(type) && (newWidthSpace < 0 || newHeightSpace < 0)) {
                int[] newSpace = new int[]{newWidthSpace, newHeightSpace};
                EditPart poolEP = PoolLaneUtils.getPoolEditPart(target);
                if (PoolLaneUtils.hasCollision(poolEP, (AbstractSwimlaneEditPart)target, newSpace)) {
                    return UnexecutableCommand.INSTANCE;
                }
                poolEP = PoolLaneUtils.getPoolEditPart(target);
                if (PoolLaneUtils.laneTooSmall(poolEP, (AbstractSwimlaneEditPart)target, newSpace)) {
                    return UnexecutableCommand.INSTANCE;
                }
            }
            final int[] oldSize = new int[]{targetRectangle.width, targetRectangle.height};
            final EditPart parentEP = target.getParent();
            if (target instanceof PoolEditPart) {
                result = result.chain((Command)new DelegatingCommand(){

                    @Override
                    public Command createDelegate() {
                        return PoolLaneUtils.moveDefaultPool((PoolEditPart)target);
                    }
                });
                result = result.chain((Command)new DelegatingCommand(){

                    @Override
                    public Command createDelegate() {
                        return PoolLaneUtils.resizeChildLanes((AbstractSwimlaneEditPart)target, oldSize);
                    }
                });
                result = result.chain((Command)new DelegatingCommand(){

                    @Override
                    public Command createDelegate() {
                        return PoolLaneUtils.reorderLanes((AbstractSwimlaneEditPart)target, changeChildLanes);
                    }
                });
                if (PoolLaneUtils.containsOthers((AbstractSwimlaneEditPart)target)) {
                    final int[] newSpace = new int[]{newWidthSpace, newHeightSpace};
                    result = result.chain((Command)new DelegatingCommand(){

                        @Override
                        public Command createDelegate() {
                            return PoolLaneUtils.checkMoveChildren((EditPart)((AbstractSwimlaneEditPart)target), newSpace);
                        }
                    });
                }
                return result;
            }
            if ("resize children".equals(type)) {
                if (PoolLaneUtils.containsOthers((AbstractSwimlaneEditPart)target)) {
                    final int[] newSpace = new int[]{newWidthSpace, newHeightSpace};
                    result = result.chain((Command)new DelegatingCommand(){

                        @Override
                        public Command createDelegate() {
                            return PoolLaneUtils.checkMoveChildren((EditPart)((AbstractSwimlaneEditPart)target), newSpace);
                        }
                    });
                }
                result = result.chain((Command)new DelegatingCommand(){

                    @Override
                    public Command createDelegate() {
                        return PoolLaneUtils.resizeChildLanes((AbstractSwimlaneEditPart)target, oldSize);
                    }
                });
                result = result.chain((Command)new DelegatingCommand(){

                    @Override
                    public Command createDelegate() {
                        return PoolLaneUtils.reorderLanes((AbstractSwimlaneEditPart)parentEP, changeChildLanes);
                    }
                });
                result = result.chain((Command)new DelegatingCommand(){

                    @Override
                    public Command createDelegate() {
                        return PoolLaneUtils.reorderSiblings(target, null);
                    }
                });
            } else {
                Integer childLanesFlag = changeChildLanes;
                if (!parentEP.equals(this.getHost())) {
                    if (PoolLaneUtils.containsOthers((AbstractSwimlaneEditPart)this.getHost())) {
                        Point createLocation;
                        Object oldCommand = result;
                        Rectangle moveBounds = boundsRect.getCopy();
                        if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
                            if (boundsRect.getLocation().x < containerBounds.width / 2) {
                                createLocation = new Point(containerBounds.width - 1, 0);
                                moveBounds.x = 0;
                            } else {
                                createLocation = new Point(0, 0);
                                moveBounds.x = containerBounds.width - 1;
                            }
                        } else if (boundsRect.getLocation().y < containerBounds.height / 2) {
                            createLocation = new Point(0, containerBounds.height - 1);
                            moveBounds.y = 0;
                        } else {
                            createLocation = new Point(0, 0);
                            moveBounds.y = containerBounds.height - 1;
                        }
                        if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
                            if (containerBounds.height > moveBounds.height) {
                                moveBounds.height = containerBounds.height;
                            }
                        } else if (containerBounds.width > moveBounds.width) {
                            moveBounds.width = containerBounds.width;
                        }
                        ((ChangeConstraintCommand)((Object)oldCommand)).setBounds(moveBounds);
                        Object moveCommand = oldCommand;
                        CreateRequest creationRequest = new CreateRequest();
                        result = this.getCreateDefaultLaneCommand(creationRequest, createLocation);
                        result = result.chain((Command)new DelegatingCommand((Command)moveCommand){
                            private final /* synthetic */ Command val$moveCommand;
                            {
                                this.val$moveCommand = command;
                            }

                            @Override
                            public Command createDelegate() {
                                return this.val$moveCommand;
                            }
                        });
                    }
                    childLanesFlag = new Integer(2);
                }
                final EditPart host = this.getHost();
                final Integer useFlag = childLanesFlag;
                result = result.chain((Command)new DelegatingCommand(){

                    @Override
                    public Command createDelegate() {
                        return PoolLaneUtils.reorderLanes((AbstractSwimlaneEditPart)host, useFlag);
                    }
                });
                result = result.chain((Command)new DelegatingCommand(){

                    @Override
                    public Command createDelegate() {
                        return PoolLaneUtils.reorderSiblings(target, host);
                    }
                });
                if (!parentEP.equals(this.getHost())) {
                    result = result.chain((Command)new DelegatingCommand(){

                        @Override
                        public Command createDelegate() {
                            return PoolLaneUtils.reorderLanes((AbstractSwimlaneEditPart)parentEP, new Integer(4));
                        }
                    });
                }
                result = result.chain((Command)new DelegatingCommand(){

                    @Override
                    public Command createDelegate() {
                        return PoolLaneUtils.reorderChildLanes((AbstractSwimlaneEditPart)target, new Integer(3));
                    }
                });
            }
        }
        return result;
    }

    private void setLaneBoundsToMinSize(Rectangle bounds, LaneEditPart laneEditPart, boolean noCollision) {
        IFigure laneFigure = laneEditPart.getFigure();
        Rectangle laneBounds = laneFigure.getBounds();
        Insets laneBorder = laneFigure.getBorder().getInsets(laneFigure);
        long laneXPosRight = laneBounds.x + laneBounds.width;
        long lastSymbolXPosRight = laneBounds.x;
        long laneYPosBottom = laneBounds.y + laneBounds.height;
        long lastSymbolYPosBottom = laneBounds.y;
        boolean isXIntersection = false;
        boolean isYIntersection = false;
        boolean isLeftResize = bounds.getLocation().x > laneBounds.x;
        boolean isRightResize = bounds.getLocation().x <= laneBounds.x && bounds.width < laneBounds.width;
        boolean isTopResize = bounds.getLocation().y > laneBounds.y;
        boolean isBottomResize = bounds.getLocation().y <= laneBounds.y && bounds.height < laneBounds.height;
        Rectangle croppedBounds = bounds.getCropped(laneBorder);
        for (AbstractNodeEditPart childPart : laneEditPart.getChildren()) {
            long boundY;
            long boundX;
            Rectangle childBounds = childPart.getFigure().getBounds();
            Rectangle translatedRect = childBounds.getCopy().translate(croppedBounds.getLocation());
            if (!croppedBounds.contains(translatedRect)) {
                if (isLeftResize && (long)(translatedRect.x + translatedRect.width) > laneXPosRight || isRightResize && (long)(translatedRect.x + translatedRect.width) < laneXPosRight) {
                    isXIntersection = true;
                }
                if (isTopResize && (long)(translatedRect.y + translatedRect.height) > laneYPosBottom || isBottomResize && (long)(translatedRect.y + translatedRect.height) < laneYPosBottom) {
                    isYIntersection = true;
                }
                noCollision = false;
            }
            if ((boundX = ((INodeSymbol)childPart.getModel()).getXPos() + (long)childBounds.width) > lastSymbolXPosRight && boundX < laneXPosRight) {
                lastSymbolXPosRight = boundX;
            }
            if ((boundY = ((INodeSymbol)childPart.getModel()).getYPos() + (long)childBounds.height) <= lastSymbolYPosBottom || boundY >= laneYPosBottom) continue;
            lastSymbolYPosBottom = boundY;
        }
        int diffX = 0;
        int width = laneBounds.width - new Long(lastSymbolXPosRight).intValue() - (laneBorder.left + laneBorder.right);
        if (isLeftResize && (diffX == 0 || diffX > width)) {
            diffX = width;
        }
        int diffY = 0;
        int height = laneBounds.height - new Long(lastSymbolYPosBottom).intValue() - (laneBorder.bottom + laneBorder.top);
        if (isTopResize && (diffY == 0 || diffY > height)) {
            diffY = height;
        }
        if (!noCollision) {
            bounds.setLocation(isXIntersection ? laneBounds.x + diffX : bounds.x, isYIntersection ? laneBounds.y + diffY : bounds.y);
            bounds.setSize(isXIntersection ? new Long(lastSymbolXPosRight).intValue() + laneBorder.left + laneBorder.right : bounds.width, isYIntersection ? new Long(lastSymbolYPosBottom).intValue() + laneBorder.bottom + laneBorder.top : bounds.height);
        }
        PrecisionRectangle rect = new PrecisionRectangle(bounds);
        PrecisionRectangle baseRect = rect.getPreciseCopy();
        PrecisionPoint preciseDelta = new PrecisionPoint(0, 0);
        SnapToHelper snapToHelper = (SnapToHelper)this.getHost().getAdapter(SnapToHelper.class);
        if (snapToHelper != null) {
            ChangeBoundsRequest fakeRequest = new ChangeBoundsRequest();
            fakeRequest.setLocation(bounds.getLocation());
            Point moveDelta = new Point(0, 0);
            fakeRequest.setMoveDelta(moveDelta);
            fakeRequest.setType((Object)"resize");
            fakeRequest.setEditParts(new ArrayList());
            snapToHelper.snapPoint((Request)fakeRequest, 192, new PrecisionRectangle[]{baseRect}, preciseDelta);
            bounds.setLocation(preciseDelta.getTranslated(bounds.getLocation()));
        }
    }

    protected Command getCreateCommand(CreateRequest request) {
        PoolLaneUtils.setResizeFlags(-1);
        CreateSymbolCommand createSymbolCommand = null;
        Command requestCommand = (Command)request.getNewObject();
        if (requestCommand instanceof CompoundCommand) {
            List commands = ((CompoundCommand)requestCommand).getCommands();
            int i = 0;
            while (i < commands.size()) {
                Command singleCommand = (Command)commands.get(i);
                if (singleCommand instanceof CreateSymbolCommand) {
                    createSymbolCommand = (CreateSymbolCommand)singleCommand;
                    break;
                }
                ++i;
            }
        } else if (requestCommand instanceof CreateSymbolCommand) {
            createSymbolCommand = (CreateSymbolCommand)requestCommand;
        }
        UnexecutableCommand result = UnexecutableCommand.INSTANCE;
        if (createSymbolCommand == null) {
            return result;
        }
        DiagramType diagram = null;
        diagram = this.getHost().getModel() instanceof DiagramType ? (DiagramType)this.getHost().getModel() : ModelUtils.findContainingDiagram((IGraphicalObject)((IGraphicalObject)this.getHost().getModel()));
        boolean isLane = false;
        EClass eClass = createSymbolCommand.getEClass();
        if (eClass.equals(PKG.getLaneSymbol())) {
            isLane = true;
        }
        if (request.getNewObject() instanceof IDiagramCommand) {
            boolean mustCreatedefaultLane = false;
            if (diagram.getMode().equals((Object)DiagramModeType.MODE_450_LITERAL) && isLane && !(this.getHost().getModel() instanceof DiagramType) && !PoolLaneUtils.containsLanes(this.getHost()) && this.getHost().getChildren().size() > 0) {
                mustCreatedefaultLane = true;
            }
            if (mustCreatedefaultLane) {
                result = this.getCreateDefaultLaneCommand(request, null);
            }
            IDiagramCommand command = (IDiagramCommand)request.getNewObject();
            Rectangle location = (Rectangle)this.getConstraintFor(request);
            command.setLocation(location);
            result = mustCreatedefaultLane ? result.chain((Command)command) : (Command)command;
            result = result.chain(this.getMoveSymbolToCenterCommand((AbstractGraphicalEditPart)this.getHost(), command));
            if (diagram.getMode().equals((Object)DiagramModeType.MODE_450_LITERAL) && this.getHost() instanceof AbstractSwimlaneEditPart) {
                result = isLane ? result.chain((Command)new DelegatingCommand(){

                    @Override
                    public Command createDelegate() {
                        return PoolLaneUtils.reorderLanes((AbstractSwimlaneEditPart)SymbolContainerLayoutEditPolicy.this.getHost(), new Integer(2));
                    }
                }) : result.chain((Command)new DelegatingCommand(){

                    @Override
                    public Command createDelegate() {
                        return PoolLaneUtils.resizeLane((AbstractSwimlaneEditPart)SymbolContainerLayoutEditPolicy.this.getHost());
                    }
                });
                result = result.chain((Command)new DelegatingCommand(){

                    @Override
                    public Command createDelegate() {
                        return PoolLaneUtils.reorderSiblings(SymbolContainerLayoutEditPolicy.this.getHost(), null);
                    }
                });
            }
        }
        return result;
    }

    private Command getCreateDefaultLaneCommand(CreateRequest request, Point newLocation) {
        CompoundCommand compoundCommand = new CompoundCommand();
        CreationFactory factory = NodeCreationFactory.getLaneFactory();
        final IDiagramCommand command = (IDiagramCommand)factory.getNewObject();
        command.setParent((EObject)this.getHost().getModel());
        Rectangle bounds = newLocation != null ? new Rectangle(newLocation, new Dimension(-1, -1)) : (Rectangle)this.getConstraintFor(request);
        ISwimlaneSymbol container = (ISwimlaneSymbol)this.getHost().getModel();
        DiagramType diagram = null;
        diagram = container instanceof DiagramType ? (DiagramType)container : ModelUtils.findContainingDiagram((IGraphicalObject)container);
        OrientationType direction = diagram.getOrientation();
        WorkflowModelEditor editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        AbstractSwimlaneEditPart abstractSwimlaneEP = (AbstractSwimlaneEditPart)editor.findEditPart(container);
        Rectangle containerBounds = GenericUtils.getSymbolRectangle((EditPart)abstractSwimlaneEP);
        if (newLocation == null) {
            if (OrientationType.VERTICAL_LITERAL.equals((Object)direction)) {
                bounds.x = bounds.x < containerBounds.width / 2 ? 0 : containerBounds.width - 1;
            } else {
                bounds.y = bounds.y < containerBounds.height / 2 ? 0 : containerBounds.height - 1;
            }
        }
        command.setLocation(bounds);
        compoundCommand.add((Command)command);
        compoundCommand.add((Command)new DelegatingCommand(){

            @Override
            public Command createDelegate() {
                INodeSymbol symbol = SymbolContainerLayoutEditPolicy.getCreatedSymbol(command);
                AbstractGraphicalEditPart host = (AbstractGraphicalEditPart)SymbolContainerLayoutEditPolicy.this.getHost();
                return SymbolContainerLayoutEditPolicy.this.moveSymbolsToLane(host, SymbolContainerLayoutEditPolicy.getCreatedPart(host, symbol));
            }
        });
        return compoundCommand;
    }

    private Command moveSymbolsToLane(AbstractGraphicalEditPart host, final AbstractNodeSymbolEditPart part) {
        CompoundCommand command = new CompoundCommand();
        List children = host.getChildren();
        int i = 0;
        while (i < children.size()) {
            INodeSymbol symbol;
            EditPart child = (EditPart)children.get(i);
            if (!(child instanceof AbstractSwimlaneEditPart) && (symbol = (INodeSymbol)child.getModel()).eContainmentFeature() != null) {
                CompoundCommand moveSymbolsCmd = new CompoundCommand();
                moveSymbolsCmd.add((Command)new DelegatingCommand(){

                    @Override
                    public Command createDelegate() {
                        SetSymbolContainerCommand cmd = new SetSymbolContainerCommand(){

                            @Override
                            public boolean changePerformer() {
                                return false;
                            }
                        };
                        cmd.setContainer((ISymbolContainer)part.getModel(), null);
                        cmd.setSymbol((IGraphicalObject)symbol);
                        return cmd;
                    }
                });
                command.add((Command)moveSymbolsCmd);
            }
            ++i;
        }
        return command;
    }

    private Command getMoveSymbolToCenterCommand(final AbstractGraphicalEditPart host, final IDiagramCommand command) {
        return new DelegatingCommand(){

            @Override
            public Command createDelegate() {
                CompoundCommand cmd = new CompoundCommand();
                INodeSymbol symbol = SymbolContainerLayoutEditPolicy.getCreatedSymbol(command);
                if (!(symbol instanceof ISwimlaneSymbol)) {
                    AbstractNodeSymbolEditPart part = SymbolContainerLayoutEditPolicy.getCreatedPart(host, symbol);
                    Figure figure = (Figure)part.getFigure();
                    Dimension prefSize = figure.getPreferredSize();
                    Dimension size = SnapGridUtils.getSnapDimension(prefSize, host, 2, true);
                    if (!(figure instanceof ActivitySymbolFigure) && SnapGridUtils.getSnapToHelper(host) != null) {
                        boolean change = false;
                        if (size.height < prefSize.height) {
                            prefSize.height += SnapCenterToGrid.CARNOT_DEFAULT_GRID_SIZE;
                            change = true;
                        }
                        if (size.width < prefSize.width) {
                            prefSize.width += SnapCenterToGrid.CARNOT_DEFAULT_GRID_SIZE;
                            change = true;
                        }
                        if (change) {
                            size = SnapGridUtils.getSnapDimension(prefSize, host, 2, true);
                        }
                    }
                    Point newLocation = new Point(new Long(symbol.getXPos()).intValue() - size.width / 2, new Long(symbol.getYPos()).intValue() - size.height / 2);
                    if (SnapGridUtils.getSnapToHelper(host) != null) {
                        symbol.setWidth(size.width);
                        symbol.setHeight(size.height);
                    }
                    Point setLocation = SnapGridUtils.getSnapLocation(host, part, null, size, newLocation);
                    MoveNodeSymbolCommand moveCommand = new MoveNodeSymbolCommand();
                    moveCommand.setPart(symbol);
                    moveCommand.setLocation(setLocation);
                    cmd.add((Command)moveCommand);
                } else {
                    AbstractNodeSymbolEditPart part = SymbolContainerLayoutEditPolicy.getCreatedPart(host, symbol);
                    Dimension size = SnapGridUtils.getSnapDimension(GenericUtils.getSymbolRectangle((EditPart)part).getSize(), host, 1, true);
                    if (SnapGridUtils.getSnapToHelper(host) != null) {
                        symbol.setWidth(size.width);
                        symbol.setHeight(size.height);
                    }
                }
                return cmd;
            }
        };
    }

    public static DelegatingCommand getSnapToGridCommand(final AbstractGraphicalEditPart host, final IDiagramCommand command, final Point location) {
        return new DelegatingCommand(){

            @Override
            public Command createDelegate() {
                INodeSymbol symbol = SymbolContainerLayoutEditPolicy.getCreatedSymbol(command);
                AbstractNodeSymbolEditPart part = SymbolContainerLayoutEditPolicy.getCreatedPart(host, symbol);
                return SymbolContainerLayoutEditPolicy.getSnapToGridCommand(host, symbol, location, part);
            }
        };
    }

    public static Command getSnapToGridCommand(AbstractGraphicalEditPart host, INodeSymbol symbol, Point location, AbstractNodeSymbolEditPart part) {
        IFigure figure = part.getFigure();
        PrecisionRectangle rect = new PrecisionRectangle(new Rectangle(location, figure.getPreferredSize()));
        Point oldLocation = rect.getLocation();
        figure.translateToAbsolute((Translatable)rect);
        PrecisionRectangle baseRect = rect.getPreciseCopy();
        PrecisionPoint preciseDelta = new PrecisionPoint(0, 0);
        SnapToHelper snapToHelper = (SnapToHelper)host.getAdapter(SnapToHelper.class);
        if (snapToHelper != null) {
            ChangeBoundsRequest fakeRequest = new ChangeBoundsRequest();
            fakeRequest.setLocation(location);
            Point moveDelta = new Point(0, 0);
            fakeRequest.setMoveDelta(moveDelta);
            fakeRequest.setType((Object)"resize");
            fakeRequest.setEditParts(new ArrayList());
            snapToHelper.snapPoint((Request)fakeRequest, 192, new PrecisionRectangle[]{baseRect}, preciseDelta);
        }
        MoveNodeSymbolCommand moveCommand = new MoveNodeSymbolCommand();
        moveCommand.setPart(symbol);
        moveCommand.setLocation(preciseDelta.getTranslated(oldLocation));
        return moveCommand;
    }

    public static AbstractNodeSymbolEditPart getCreatedPart(AbstractGraphicalEditPart host, INodeSymbol symbol) {
        AbstractNodeSymbolEditPart symbolPart = null;
        for (EditPart child : host.getChildren()) {
            if (symbolPart != null || !(child instanceof AbstractNodeSymbolEditPart) || !symbol.equals(child.getModel())) continue;
            symbolPart = (AbstractNodeSymbolEditPart)child;
        }
        if (symbolPart == null && host instanceof DiagramEditPart && !host.getChildren().isEmpty()) {
            AbstractGraphicalEditPart realHost = (AbstractGraphicalEditPart)host.getChildren().get(0);
            symbolPart = null;
            for (EditPart child : realHost.getChildren()) {
                if (symbolPart != null || !(child instanceof AbstractNodeSymbolEditPart) || !symbol.equals(child.getModel())) continue;
                symbolPart = (AbstractNodeSymbolEditPart)child;
            }
        }
        return symbolPart;
    }

    private static INodeSymbol getCreatedSymbol(IDiagramCommand command) {
        INodeSymbol symbol;
        block3: {
            block4: {
                block2: {
                    symbol = null;
                    if (!(command instanceof CreateSymbolCommand)) break block2;
                    symbol = (INodeSymbol)((CreateSymbolCommand)command).getModelElement();
                    break block3;
                }
                if (!(command instanceof CreateModelElementCommand)) break block4;
                IModelElement element = ((CreateModelElementCommand)((Object)command)).getModelElement();
                if (!(element instanceof INodeSymbol)) break block3;
                symbol = (INodeSymbol)element;
                break block3;
            }
            if (command instanceof CompoundDiagramCommand) {
                for (Command child : ((CompoundDiagramCommand)command).getCommands()) {
                    if (!(child instanceof CreateSymbolCommand)) continue;
                    symbol = (INodeSymbol)((CreateSymbolCommand)child).getModelElement();
                    break;
                }
            }
        }
        return symbol;
    }

    protected Command getDeleteDependantCommand(Request request) {
        return null;
    }

    protected IFigure createSizeOnDropFeedback(CreateRequest createRequest) {
        IFigure result = super.createSizeOnDropFeedback(createRequest);
        if (result != null) {
            this.addFeedback(result);
        }
        return result;
    }

    protected IFigure getFeedbackLayer() {
        return super.getFeedbackLayer();
    }
}

