/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.editors.ui;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.change.ChangeDescription;
import org.eclipse.emf.ecore.change.util.ChangeRecorder;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.IPreferencePageContainer;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.spi.IPropertyPage;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContext;
import org.eclipse.stardust.model.xpdl.carnot.util.VariableContextHelper;
import org.eclipse.stardust.model.xpdl.util.IConnection;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalPackage;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.modeling.common.platform.validation.IQuickValidationStatus;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.BindingManager;
import org.eclipse.stardust.modeling.common.ui.jface.databinding.IWidgetAdapter;
import org.eclipse.stardust.modeling.core.editors.IValidationEventListener;
import org.eclipse.stardust.modeling.core.editors.ValidationIssueManager;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.dialog.ApplyUpdatesCommand;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPreferenceNode;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPropertyPageContributor;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.IPageValidationEventListener;
import org.eclipse.stardust.modeling.core.editors.ui.validation.PageValidationManager;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.DataPathPropertyPage;
import org.eclipse.stardust.modeling.core.properties.VariablesConfigurationPage;
import org.eclipse.stardust.modeling.core.ui.PreferenceNodeBinding;
import org.eclipse.stardust.modeling.core.utils.CompositeUtils;
import org.eclipse.stardust.modeling.core.utils.VerifyingChangeRecorder;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.repository.common.descriptors.EObjectDescriptor;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;

public class ModelElementPropertyDialog
extends PreferenceDialog {
    public static final char NODE_PATH_SEPARATOR = '.';
    private BindingManager bindings = new BindingManager();
    private Set<CarnotPreferenceNode> validationNodes = new HashSet<CarnotPreferenceNode>();
    private final ValidationIssueManager issueManager = new ValidationIssueManager();
    private final ChangeRecorder changeRecorder;
    private final IAdaptable element;
    private WorkflowModelEditor editor;
    private ArrayList<Command> dependentCommands = new ArrayList();

    public ModelElementPropertyDialog(WorkflowModelEditor editor, Shell shell, PreferenceManager pageManager, IAdaptable element, ChangeRecorder recorder) {
        super(shell, pageManager);
        this.editor = editor;
        this.element = element;
        this.changeRecorder = recorder == null ? new VerifyingChangeRecorder(editor, this.issueManager) : recorder;
        this.startRecording();
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        this.getTreeViewer().setSorter(new ViewerSorter(){

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public int compare(Viewer viewer, Object e1, Object e2) {
                if (e1 instanceof CarnotPreferenceNode) {
                    if (!(e2 instanceof CarnotPreferenceNode)) return -1;
                    String cat1 = ((CarnotPreferenceNode)((Object)e1)).category;
                    String cat2 = ((CarnotPreferenceNode)((Object)e2)).category;
                    String id1 = ((CarnotPreferenceNode)((Object)e1)).getId();
                    String id2 = ((CarnotPreferenceNode)((Object)e2)).getId();
                    if (!StringUtils.isEmpty((String)cat2) && !StringUtils.isEmpty((String)cat1)) {
                        if (id1.equals("_cwm_general_")) {
                            return -1;
                        }
                        if (id2.equals("_cwm_general_")) {
                            return 1;
                        }
                        if (cat1.equals(cat2)) {
                            return id1.compareTo(id2);
                        }
                        int i = 0;
                        while (i < CarnotPropertyPageContributor.CATEGORIES.length) {
                            if (CarnotPropertyPageContributor.CATEGORIES[i].equals(cat1)) {
                                return -1;
                            }
                            if (CarnotPropertyPageContributor.CATEGORIES[i].equals(cat2)) {
                                return 1;
                            }
                            ++i;
                        }
                        return cat1.compareTo(cat2);
                    }
                    int c1 = ((CarnotPreferenceNode)((Object)e1)).getSortOrder();
                    int c2 = ((CarnotPreferenceNode)((Object)e2)).getSortOrder();
                    if (c1 >= 0) {
                        if (c2 < 0) return -1;
                        if (c1 == c2) return super.compare(viewer, e1, e2);
                        return c1 - c2;
                    }
                    if (c2 >= 0) {
                        return 1;
                    }
                    if (c1 != -2 || c2 != -2) return super.compare(viewer, e1, e2);
                    return -1;
                }
                if (!(e2 instanceof CarnotPreferenceNode)) return super.compare(viewer, e1, e2);
                return 1;
            }
        });
        this.notifyPages(false);
        return control;
    }

    public IAdaptable getElement() {
        return this.element;
    }

    protected void okPressed() {
        super.okPressed();
        if (this.getReturnCode() != 2 && this.changeRecorder.isRecording()) {
            VariableContext context;
            this.executeCommands();
            if (!(this.getCurrentPage() instanceof VariablesConfigurationPage) && (context = VariableContextHelper.getInstance().getContext(this.editor.getWorkflowModel())) != null) {
                context.refreshVariables((EObject)this.editor.getWorkflowModel());
            }
        }
    }

    private void executeCommands() {
        ChangeDescription recording = this.changeRecorder.endRecording();
        ApplyUpdatesCommand command = new ApplyUpdatesCommand(recording);
        this.editor.getEditDomain().getCommandStack().execute((Command)command);
        int i = 0;
        while (i < this.dependentCommands.size()) {
            Command cmd = this.dependentCommands.get(i);
            this.editor.getEditDomain().getCommandStack().execute(cmd);
            ++i;
        }
        this.dependentCommands.clear();
    }

    protected void cancelPressed() {
        super.cancelPressed();
        this.undo();
    }

    public void performApply() {
        VariableContext context;
        if (this.changeRecorder.isRecording()) {
            this.apply();
            this.executeCommands();
            this.startRecording();
        }
        this.notifyPages(false);
        if (!(this.getCurrentPage() instanceof VariablesConfigurationPage) && (context = VariableContextHelper.getInstance().getContext(this.editor.getWorkflowModel())) != null) {
            context.refreshVariables((EObject)this.editor.getWorkflowModel());
        }
    }

    private void apply() {
        PreferenceManager manager = this.getPreferenceManager();
        List elements = manager.getElements(0);
        int i = 0;
        while (i < elements.size()) {
            IPreferenceNode node = (IPreferenceNode)elements.get(i);
            IPreferencePage page = node.getPage();
            if (page instanceof IPropertyPage) {
                ((IPropertyPage)page).apply();
            }
            ++i;
        }
    }

    public void performDefaults() {
        this.undo();
        this.startRecording();
        this.notifyPages(true);
    }

    private void undo() {
        if (this.changeRecorder.isRecording()) {
            ChangeDescription changes = this.changeRecorder.endRecording();
            changes.apply();
        }
    }

    private void notifyPages(boolean force) {
        HashSet<CarnotPreferenceNode> visited = new HashSet<CarnotPreferenceNode>();
        PreferenceManager manager = this.getPreferenceManager();
        List elements = manager.getElements(0);
        IPreferenceNode[] nodes = elements.toArray(new IPreferenceNode[elements.size()]);
        this.notifyPages(nodes, visited, force);
    }

    private void notifyPages(IPreferenceNode[] nodes, HashSet<CarnotPreferenceNode> visited, boolean force) {
        int i = 0;
        while (i < nodes.length) {
            CarnotPreferenceNode node = (CarnotPreferenceNode)nodes[i];
            if (!visited.contains((Object)node)) {
                IPreferencePage page = this.getCreatePage(node);
                if (page instanceof IPropertyPage && (force || !(page instanceof AbstractModelElementPropertyPage))) {
                    ((IPropertyPage)page).elementChanged();
                }
                visited.add(node);
                this.notifyPages(node.getSubNodes(), visited, force);
            }
            ++i;
        }
    }

    private IPreferencePage getCreatePage(CarnotPreferenceNode node) {
        if (node == null) {
            return null;
        }
        if (node.getPage() == null) {
            this.createPage((IPreferenceNode)node);
        }
        if (node.getPage() == null) {
            return null;
        }
        return this.initializePageControl(node);
    }

    private void enablePageControl(IPreferencePage page) {
        boolean isExternalReference;
        if (page instanceof PropertyPage && (isExternalReference = this.isExternalReference(this.getElement()))) {
            Button okButton;
            Control control;
            boolean enablePage = false;
            if (page instanceof AbstractModelElementPropertyPage) {
                if (page instanceof DataPathPropertyPage) {
                    if (((DataPathPropertyPage)page).isEditable()) {
                        ((AbstractModelElementPropertyPage)page).setEnablePage(enablePage);
                    }
                } else {
                    ((AbstractModelElementPropertyPage)page).setEnablePage(enablePage);
                }
            } else if (page instanceof PropertyPage && (control = page.getControl()) != null) {
                control.setEnabled(true);
                if (control instanceof Composite) {
                    CompositeUtils.enableComposite((Composite)control, enablePage);
                }
            }
            if ((okButton = this.getButton(0)) != null) {
                okButton.setEnabled(enablePage);
            }
        }
    }

    private boolean isExternalReference(IAdaptable adaptable) {
        EObject modelElement = this.getModelElement(adaptable);
        if (modelElement != null) {
            if (modelElement.eIsProxy()) {
                return true;
            }
            if (modelElement instanceof ActivityType) {
                return false;
            }
            if (modelElement instanceof DataType) {
                DataType dataType = (DataType)modelElement;
                if (dataType.getType().getId().equals("struct")) {
                    if (dataType.getExternalReference() == null) {
                        if (AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)modelElement), (String)"carnot:connection:uri") != null) {
                            return true;
                        }
                    } else {
                        return false;
                    }
                }
                if (dataType.getType().getId().equals("primitive")) {
                    if (dataType.getExternalReference() == null) {
                        if (AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)modelElement), (String)"carnot:connection:uri") != null) {
                            return true;
                        }
                    } else {
                        return false;
                    }
                }
            }
            String uri = null;
            if (modelElement instanceof IExtensibleElement) {
                uri = AttributeUtil.getAttributeValue((IExtensibleElement)((IExtensibleElement)modelElement), (String)"carnot:connection:uri");
            } else if (modelElement instanceof Extensible) {
                uri = ExtendedAttributeUtil.getAttributeValue((Extensible)((Extensible)modelElement), (String)"carnot:connection:uri");
            }
            if (uri != null) {
                String importString;
                ModelType model = ModelUtils.findContainingModel((EObject)modelElement);
                if (model == null) {
                    return false;
                }
                Connection connection = (Connection)model.getConnectionManager().findConnection(uri);
                return connection == null || (importString = connection.getAttribute("importByReference")) == null || !importString.equalsIgnoreCase("false");
            }
        }
        return false;
    }

    protected EObject getModelElement(IAdaptable adaptable) {
        EditPart editPart = (EditPart)adaptable.getAdapter(EditPart.class);
        Object model = editPart.getModel();
        if (model instanceof IModelElementNodeSymbol) {
            IModelElementNodeSymbol nd = (IModelElementNodeSymbol)model;
            return nd.getModelElement();
        }
        if (model instanceof Proxy) {
            Proxy proxy = (Proxy)model;
            InvocationHandler ih = Proxy.getInvocationHandler(proxy);
            Object value = Reflect.getFieldValue((Object)ih, (String)"val$desc");
            if (value == null || !(value instanceof EObjectDescriptor)) {
                return null;
            }
            EObjectDescriptor ed = (EObjectDescriptor)value;
            return ed.getEObject();
        }
        if (model instanceof IConnection) {
            return (EObject)model;
        }
        if (model instanceof ExternalPackage) {
            return null;
        }
        if (model instanceof EObject) {
            return (EObject)model;
        }
        return null;
    }

    private IPreferencePage initializePageControl(CarnotPreferenceNode node) {
        final IPreferencePage page = this.getPage((IPreferenceNode)node);
        page.setContainer((IPreferencePageContainer)this);
        this.registerValidation(node, page);
        this.enablePageControl(page);
        if (page.getControl() == null) {
            final boolean[] failed = new boolean[1];
            SafeRunnable.run((ISafeRunnable)new ISafeRunnable(){

                public void handleException(Throwable e) {
                    e.printStackTrace();
                    failed[0] = true;
                }

                public void run() {
                    ModelElementPropertyDialog.this.createPageControl(page, ModelElementPropertyDialog.this.getPageContainer());
                }
            });
            if (failed[0]) {
                return null;
            }
            Assert.isNotNull((Object)page.getControl());
        }
        this.enablePageControl(page);
        return page;
    }

    private void registerValidation(final CarnotPreferenceNode node, IPreferencePage page) {
        if (page instanceof IAdaptable && !this.validationNodes.contains((Object)node)) {
            IValidationEventListener vel;
            PageValidationManager vldMgr = (PageValidationManager)((IAdaptable)page).getAdapter(PageValidationManager.class);
            if (vldMgr != null) {
                vldMgr.addPageValidationEventListener(new IPageValidationEventListener(){

                    @Override
                    public void pageStatusUpdated(IPreferencePage page, IQuickValidationStatus status) {
                        node.updatePageStatus(status);
                        if (!ModelElementPropertyDialog.this.getTreeViewer().getControl().isDisposed()) {
                            ModelElementPropertyDialog.this.getTreeViewer().refresh((Object)node);
                        }
                    }
                });
            }
            if ((vel = (IValidationEventListener)((IAdaptable)page).getAdapter(IValidationEventListener.class)) != null) {
                this.issueManager.addValidationEventListener(vel);
                this.issueManager.pushCurrentStatus(vel);
            }
            this.validationNodes.add(node);
        }
        if (this.changeRecorder instanceof VerifyingChangeRecorder) {
            ((VerifyingChangeRecorder)this.changeRecorder).performElementValidation(true);
        }
    }

    public void registerValidation(IAdaptable adaptable) {
        IValidationEventListener vel = (IValidationEventListener)adaptable.getAdapter(IValidationEventListener.class);
        if (vel != null) {
            this.issueManager.addValidationEventListener(vel);
            this.issueManager.pushCurrentStatus(vel);
            if (this.changeRecorder instanceof VerifyingChangeRecorder) {
                ((VerifyingChangeRecorder)this.changeRecorder).performElementValidation(true);
            }
        }
    }

    private void startRecording() {
        if (!this.changeRecorder.isRecording() && this.getElement() != null) {
            EObject eobj;
            IModelElement modelElement = (IModelElement)this.getElement().getAdapter(IModelElement.class);
            if (modelElement != null) {
                ModelType model = ModelUtils.findContainingModel((EObject)modelElement);
                if (this.changeRecorder instanceof VerifyingChangeRecorder) {
                    ((VerifyingChangeRecorder)this.changeRecorder).beginRecording(model, modelElement);
                    return;
                }
            }
            if ((eobj = (EObject)this.getElement().getAdapter(EObject.class)) != null) {
                while (eobj.eContainer() != null) {
                    eobj = eobj.eContainer();
                }
                this.changeRecorder.beginRecording(Collections.singleton(eobj));
            }
        }
    }

    public void selectPage(IPreferenceNode node) {
        this.getTreeViewer().setSelection((ISelection)new StructuredSelection((Object)node));
    }

    public void addNodeTo(String path, CarnotPreferenceNode node, EObjectLabelProvider labelProvider) {
        PreferenceManager manager = this.getPreferenceManager();
        if (path == null) {
            manager.addToRoot((IPreferenceNode)node);
        } else {
            manager.addTo(path, (IPreferenceNode)node);
        }
        if (labelProvider != null) {
            IModelElement model = (IModelElement)node.getAdaptable().getAdapter(IModelElement.class);
            this.bindings.bind((EObject)model, (IWidgetAdapter)new PreferenceNodeBinding(this.getTreeViewer(), (EObject)model, node, labelProvider));
        }
        this.getCreatePage(node);
    }

    public void refreshTree() {
        if (!this.getTreeViewer().getTree().isDisposed()) {
            this.getTreeViewer().refresh();
        }
    }

    public void selectPage(String path) {
        PreferenceManager manager = this.getPreferenceManager();
        this.selectPage(manager.find(path));
    }

    public void selectPageForObject(Object selection) {
        if (selection == null) {
            return;
        }
        PreferenceManager manager = this.getPreferenceManager();
        List list = manager.getElements(0);
        int i = 0;
        while (i < list.size()) {
            IPreferenceNode node = (IPreferenceNode)list.get(i);
            if (node instanceof CarnotPreferenceNode) {
                Proxy proxy;
                CarnotPreferenceNode cpn = (CarnotPreferenceNode)node;
                if (selection.equals(cpn.getAdaptable().getAdapter(IModelElement.class))) {
                    this.selectPage(node);
                    break;
                }
                if (cpn.getAdaptable().getAdapter(IModelElement.class) instanceof Proxy && (proxy = (Proxy)cpn.getAdaptable().getAdapter(IModelElement.class)).equals(selection)) {
                    this.selectPage(node);
                    break;
                }
            }
            ++i;
        }
    }

    public void expandTree() {
        this.getTreeViewer().expandAll();
    }

    public void removePreferenceNodes(String parentNodeId, boolean removeParent) {
        PreferenceManager manager = this.getPreferenceManager();
        IPreferenceNode node = manager.find(parentNodeId);
        if (node != null) {
            IPreferenceNode[] subNodes = node.getSubNodes();
            int i = 0;
            while (i < subNodes.length) {
                this.removeBindings(subNodes[i]);
                node.remove(subNodes[i]);
                this.disposeNode(subNodes[i]);
                ++i;
            }
            if (removeParent) {
                this.bindings.unbind((Object)node);
                manager.remove(parentNodeId);
                this.disposeNode(node);
            }
        }
    }

    public void removePreferenceNode(IPreferenceNode parentNode, IPreferenceNode node) {
        this.bindings.unbind((Object)node);
        parentNode.remove(node);
        this.disposeNode(node);
    }

    private void disposeNode(IPreferenceNode node) {
        if (CompareHelper.areEqual((Object)this.getCurrentPage(), (Object)node.getPage())) {
            IPreferenceNode firstNode = (IPreferenceNode)this.getPreferenceManager().getElements(0).get(0);
            this.setCurrentPage(firstNode.getPage());
        }
        node.disposeResources();
    }

    private void removeBindings(IPreferenceNode node) {
        IPreferenceNode[] subNodes = node.getSubNodes();
        int i = 0;
        while (i < subNodes.length) {
            this.removeBindings(subNodes[i]);
            this.validationNodes.remove(node);
            this.bindings.unbind((Object)node);
            ++i;
        }
    }

    public WorkflowModelEditor getEditor() {
        return this.editor;
    }

    public IPreferencePage getPage(String pageId) {
        IPreferenceNode node = this.getNode(pageId);
        return node == null ? null : node.getPage();
    }

    public IPreferenceNode getNode(String pageId) {
        return this.getPreferenceManager().find(pageId);
    }

    public static String composePageId(String parentId, String id) {
        return String.valueOf(parentId) + '.' + ModelElementPropertyDialog.convertId(id);
    }

    public static String convertId(String id) {
        return id.replace('.', '~');
    }

    public void addDependentCommand(Command command) {
        this.dependentCommands.add(command);
    }

    public void setReadOnly() {
        Button okButton = this.getButton(0);
        okButton.setVisible(false);
        Button cancelButton = this.getButton(1);
        cancelButton.setText(okButton.getText());
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
    }

    public void updateButtons() {
        Button okButton;
        super.updateButtons();
        if (this.isExternalReference(this.getElement()) && (okButton = this.getButton(0)) != null) {
            okButton.setEnabled(false);
        }
    }

    protected void buttonPressed(int buttonId) {
        super.buttonPressed(buttonId);
    }
}

