/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.ColorConstants;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IFilter;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.ApplicationContextTypeType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataSymbolType;
import org.eclipse.stardust.model.xpdl.carnot.DataType;
import org.eclipse.stardust.model.xpdl.carnot.DirectionType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.AccessPointUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ActivityUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.common.ui.IdFactory;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.ui.CarnotPreferenceNode;
import org.eclipse.stardust.modeling.core.editors.ui.EObjectLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.ModelElementPropertyDialog;
import org.eclipse.stardust.modeling.core.editors.ui.TableLabelProvider;
import org.eclipse.stardust.modeling.core.editors.ui.TableUtil;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.properties.DataMappingPropertyPage;
import org.eclipse.stardust.modeling.core.properties.DataMappingsTreeContentProvider;
import org.eclipse.stardust.modeling.core.properties.DefaultOutlineProvider;
import org.eclipse.stardust.modeling.core.properties.IButtonManager;
import org.eclipse.stardust.modeling.core.properties.ModelElementsOutlineSynchronizer;
import org.eclipse.stardust.modeling.core.spi.ConfigurationElement;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IWorkbenchPropertyPage;

class ActivityDataMappingsPropertyPage
extends AbstractModelElementPropertyPage
implements IButtonManager {
    public static final String OUT_DATA_MAPPINGS_ID = "_cwm_out_data_mappings_";
    public static final String IN_DATA_MAPPINGS_ID = "_cwm_in_data_mappings_";
    private static final String UNDEFINED = "[undefined]";
    private boolean isIn;
    private TreeViewer viewer;
    private TableLabelProvider labelProvider;
    private Button[] buttons;
    private Object selection;
    private ModelElementsOutlineSynchronizer outlineSynchronizer;
    private ActivityType activity;
    private DataType data;

    public ActivityDataMappingsPropertyPage(boolean in) {
        this.isIn = in;
    }

    @Override
    protected void performDefaults() {
        super.performDefaults();
        this.selectPage(this.isIn ? IN_DATA_MAPPINGS_ID : OUT_DATA_MAPPINGS_ID);
    }

    @Override
    public void contributeVerticalButtons(Composite parent) {
        this.buttons = this.createButtons(parent);
    }

    @Override
    public void dispose() {
        this.outlineSynchronizer.dispose();
        super.dispose();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updateButtons(this.getSelectedItem(), this.buttons);
            this.updateTable();
        }
        super.setVisible(visible);
    }

    protected void updateTable() {
        int i = 0;
        while (i < this.viewer.getTree().getItemCount()) {
            TreeItem contextItem = this.viewer.getTree().getItem(i);
            boolean isGrayed = !this.isValidContext(((ApplicationContextTypeType)contextItem.getData()).getId());
            contextItem.setGrayed(isGrayed);
            contextItem.setForeground(isGrayed ? ColorConstants.gray : ColorConstants.black);
            int j = 0;
            while (j < contextItem.getItemCount()) {
                TreeItem dmItem = contextItem.getItem(j);
                dmItem.setGrayed(isGrayed);
                dmItem.setForeground(isGrayed ? ColorConstants.gray : ColorConstants.black);
                ++j;
            }
            ++i;
        }
    }

    @Override
    public void updateButtons(Object selection, Button[] buttons) {
        this.selection = selection;
        int i = 0;
        while (i < buttons.length) {
            if (buttons[i].isDisposed()) {
                return;
            }
            ++i;
        }
        boolean isValidDM = selection instanceof DataMappingType;
        buttons[0].setEnabled(selection != null && (isValidDM || selection instanceof ApplicationContextTypeType) && this.canAdd(selection));
        buttons[1].setEnabled(isValidDM);
        buttons[2].setEnabled(isValidDM && this.canMoveUp((DataMappingType)selection));
        buttons[3].setEnabled(isValidDM && this.canMoveDown((DataMappingType)selection));
    }

    private boolean canAdd(Object selection) {
        String context = selection instanceof ApplicationContextTypeType ? ((ApplicationContextTypeType)selection).getId() : ((DataMappingType)selection).getContext();
        return this.isValidContext(context);
    }

    private boolean canMoveDown(DataMappingType type) {
        List contexts = ActivityUtil.getContextTypes((ActivityType)this.getActivity(), (DirectionType)(this.isIn ? DirectionType.IN_LITERAL : DirectionType.OUT_LITERAL));
        int i = 0;
        while (i < contexts.size()) {
            Object activeDialog;
            ApplicationContextTypeType context = (ApplicationContextTypeType)contexts.get(i);
            if (context.getId().equals(type.getContext()) && (activeDialog = ((ModelElementPropertyDialog)this.getContainer()).getSelectedPage()) != null) {
                if (activeDialog instanceof ActivityDataMappingsPropertyPage && i < contexts.size() - 1) {
                    return true;
                }
                DataMappingsTreeContentProvider provider = (DataMappingsTreeContentProvider)this.viewer.getContentProvider();
                List<Object> mappings = Arrays.asList(provider.getChildren(context));
                int index = mappings.indexOf(type);
                return index >= 0 && index < mappings.size() - 1;
            }
            ++i;
        }
        return false;
    }

    private boolean canMoveUp(DataMappingType type) {
        List contexts = ActivityUtil.getContextTypes((ActivityType)this.getActivity(), (DirectionType)(this.isIn ? DirectionType.IN_LITERAL : DirectionType.OUT_LITERAL));
        int i = 0;
        while (i < contexts.size()) {
            ApplicationContextTypeType context = (ApplicationContextTypeType)contexts.get(i);
            if (context.getId().equals(type.getContext())) {
                if (i > 0) {
                    return true;
                }
                DataMappingsTreeContentProvider provider = (DataMappingsTreeContentProvider)this.viewer.getContentProvider();
                List<Object> mappings = Arrays.asList(provider.getChildren(context));
                int index = mappings.indexOf(type);
                return index > 0;
            }
            ++i;
        }
        return false;
    }

    @Override
    public Button[] createButtons(Composite parent) {
        Button[] buttons;
        buttons = new Button[]{FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_Add, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivityDataMappingsPropertyPage.this.performAdd(buttons);
            }
        }), FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_Delete, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivityDataMappingsPropertyPage.this.performDelete(buttons);
            }
        }), FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_MoveUp, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivityDataMappingsPropertyPage.this.performUp(buttons);
            }
        }), FormBuilder.createButton((Composite)parent, (String)Diagram_Messages.B_MoveDown, (SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivityDataMappingsPropertyPage.this.performDown(buttons);
            }
        })};
        return buttons;
    }

    @Override
    public Object getSelection() {
        return this.selection == null ? this.getSelectedItem() : this.selection;
    }

    private Object getSelectedItem() {
        IStructuredSelection sel = (IStructuredSelection)this.viewer.getSelection();
        Object selection = sel.getFirstElement();
        return selection;
    }

    private void performDown(Button[] buttons) {
        DataMappingType type = (DataMappingType)this.getSelection();
        List contexts = ActivityUtil.getContextTypes((ActivityType)this.getActivity(), (DirectionType)(this.isIn ? DirectionType.IN_LITERAL : DirectionType.OUT_LITERAL));
        EList allMappings = this.getActivity().getDataMapping();
        int i = 0;
        while (i < contexts.size()) {
            ApplicationContextTypeType context = (ApplicationContextTypeType)contexts.get(i);
            if (context.getId().equals(type.getContext())) {
                DataMappingsTreeContentProvider provider = (DataMappingsTreeContentProvider)this.viewer.getContentProvider();
                List<Object> mappings = Arrays.asList(provider.getChildren(context));
                int index = mappings.indexOf(type);
                if (index < mappings.size() - 1) {
                    int oldPos = allMappings.indexOf((Object)type);
                    DataMappingType theOneAfter = (DataMappingType)mappings.get(index + 1);
                    int newPos = allMappings.indexOf((Object)theOneAfter);
                    allMappings.move(newPos, oldPos);
                    break;
                }
                ApplicationContextTypeType nextContext = (ApplicationContextTypeType)contexts.get(i + 1);
                type.setContext(nextContext.getId());
                List<Object> newMappings = Arrays.asList(provider.getChildren(nextContext));
                if (newMappings.indexOf(type) <= 0) break;
                int oldPos = allMappings.indexOf((Object)type);
                DataMappingType theFirstOne = (DataMappingType)newMappings.get(0);
                int newPos = allMappings.indexOf((Object)theFirstOne);
                allMappings.move(newPos, oldPos);
                break;
            }
            ++i;
        }
        this.refreshAccessPoints(type);
        this.updateButtons(type, buttons);
    }

    private void performUp(Button[] buttons) {
        DataMappingType type = (DataMappingType)this.getSelection();
        List contexts = ActivityUtil.getContextTypes((ActivityType)this.getActivity(), (DirectionType)(this.isIn ? DirectionType.IN_LITERAL : DirectionType.OUT_LITERAL));
        EList allMappings = this.getActivity().getDataMapping();
        int i = 0;
        while (i < contexts.size()) {
            ApplicationContextTypeType context = (ApplicationContextTypeType)contexts.get(i);
            if (context.getId().equals(type.getContext())) {
                DataMappingsTreeContentProvider provider = (DataMappingsTreeContentProvider)this.viewer.getContentProvider();
                List<Object> mappings = Arrays.asList(provider.getChildren(context));
                int index = mappings.indexOf(type);
                if (index > 0) {
                    int oldPos = allMappings.indexOf((Object)type);
                    DataMappingType theOneBefore = (DataMappingType)mappings.get(index - 1);
                    int newPos = allMappings.indexOf((Object)theOneBefore);
                    allMappings.move(newPos, oldPos);
                    break;
                }
                ApplicationContextTypeType prevContext = (ApplicationContextTypeType)contexts.get(i - 1);
                type.setContext(prevContext.getId());
                List<Object> newMappings = Arrays.asList(provider.getChildren(prevContext));
                if (newMappings.indexOf(type) >= newMappings.size() - 1) break;
                int oldPos = allMappings.indexOf((Object)type);
                DataMappingType theLastOne = (DataMappingType)newMappings.get(newMappings.size() - 1);
                int newPos = allMappings.indexOf((Object)theLastOne) + 1;
                allMappings.move(newPos, oldPos);
                break;
            }
            ++i;
        }
        this.refreshAccessPoints(type);
        this.updateButtons(type, buttons);
    }

    private void refreshAccessPoints(DataMappingType type) {
        List<ModelElementsOutlineSynchronizer> modelElementsOutlineElements = this.getModelElementsOutlineElements();
        for (ModelElementsOutlineSynchronizer element : modelElementsOutlineElements) {
            List<IPreferenceNode> nodes = element.getNodes();
            for (IPreferenceNode node : nodes) {
                IWorkbenchPropertyPage page;
                if (!(node instanceof CarnotPreferenceNode) || (page = (IWorkbenchPropertyPage)node.getPage()) == null || !(page instanceof DataMappingPropertyPage) || !((DataMappingPropertyPage)page).getModelElement().equals(type)) continue;
                ((DataMappingPropertyPage)page).refreshAccessPoint();
            }
        }
    }

    private void performDelete(Button[] buttons) {
        DataMappingType dataMapping = (DataMappingType)this.getSelection();
        if (dataMapping != null) {
            ActivityType activity = this.getActivity();
            activity.getDataMapping().remove((Object)dataMapping);
            ActivityUtil.updateConnections((ActivityType)activity);
            this.updateButtons(null, buttons);
            this.selectPage(this.isIn ? IN_DATA_MAPPINGS_ID : OUT_DATA_MAPPINGS_ID);
        }
    }

    private void performAdd(Button[] buttons) {
        String context = null;
        Object object = this.getSelection();
        context = object instanceof DataMappingType ? ((DataMappingType)object).getContext() : ((ApplicationContextTypeType)object).getId();
        DataMappingType dataMapping = CarnotWorkflowModelFactory.eINSTANCE.createDataMappingType();
        String baseId = this.isIn ? "in" : "out";
        String baseName = this.isIn ? Diagram_Messages.BASENAME_InDataMapping : Diagram_Messages.BASENAME_OutDataMapping;
        IdFactory factory = new IdFactory(baseId, baseName, CarnotWorkflowModelPackage.eINSTANCE.getDataMappingType(), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Id(), null);
        factory.computeNames((List)this.getActivity().getDataMapping());
        dataMapping.setId(factory.getId());
        dataMapping.setName(factory.getId());
        dataMapping.setContext(context);
        dataMapping.setDirection(this.isIn ? DirectionType.IN_LITERAL : DirectionType.OUT_LITERAL);
        DataType data = this.getData();
        if (data != null) {
            dataMapping.setData(data);
        }
        ActivityType activity = this.getActivity();
        activity.getDataMapping().add((Object)dataMapping);
        this.refreshAccessPoints(dataMapping);
        this.selectPageForObject(dataMapping);
    }

    private ActivityType getActivity() {
        IAdaptable element;
        if (this.activity == null && (element = this.getElement()) instanceof EditPart) {
            Object model = ((EditPart)element).getModel();
            if (model instanceof DataMappingConnectionType) {
                model = ((DataMappingConnectionType)model).getActivitySymbol();
            }
            if (model instanceof ActivitySymbolType) {
                model = ((ActivitySymbolType)model).getActivity();
            }
            if (model instanceof ActivityType) {
                this.activity = (ActivityType)model;
            }
        }
        return this.activity;
    }

    private DataType getData() {
        IAdaptable element;
        if (this.data == null && (element = this.getElement()) instanceof EditPart) {
            Object model = ((EditPart)element).getModel();
            if (model instanceof DataMappingConnectionType) {
                model = ((DataMappingConnectionType)model).getDataSymbol();
            }
            if (model instanceof DataSymbolType) {
                model = ((DataSymbolType)model).getData();
            }
            if (model instanceof DataType) {
                this.data = (DataType)model;
            }
        }
        return this.data;
    }

    private String getPageId() {
        return this.isIn ? IN_DATA_MAPPINGS_ID : OUT_DATA_MAPPINGS_ID;
    }

    private ApplicationContextTypeType getApplicationContext(DataMappingType dataMapping) {
        return (ApplicationContextTypeType)ModelUtils.findIdentifiableElement((EObject)ModelUtils.findContainingModel((EObject)dataMapping), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getModelType_ApplicationContextType(), (String)dataMapping.getContext());
    }

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement node) {
        this.viewer.setInput((Object)this.getActivity());
        this.viewer.expandAll();
        this.outlineSynchronizer.init((EObject)this.getActivity());
        this.updateButtons(null, this.buttons);
        this.updateTable();
        this.expandTree();
        this.postMouseClickEvent();
    }

    private void postMouseClickEvent() {
        Event e = new Event();
        e.type = 3;
        e.type = 3;
        e.widget = this.viewer.getControl();
        Display.getCurrent().post(e);
        e = new Event();
        e.type = 4;
        e.button = 4;
        e.widget = this.viewer.getControl();
        Display.getCurrent().post(e);
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        Tree tree = new Tree(composite, 67584);
        tree.setHeaderVisible(true);
        tree.setLayoutData((Object)FormBuilder.createDefaultLimitedMultiLineWidgetGridData((int)200));
        FormBuilder.applyDefaultTextControlWidth((Control)tree);
        tree.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivityDataMappingsPropertyPage.this.updateButtons(ActivityDataMappingsPropertyPage.this.getSelectedItem(), ActivityDataMappingsPropertyPage.this.buttons);
            }
        });
        tree.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                Object selection = ActivityDataMappingsPropertyPage.this.getSelectedItem();
                if (selection instanceof DataMappingType) {
                    ActivityDataMappingsPropertyPage.this.selectPageForObject(selection);
                }
            }
        });
        this.viewer = new TreeViewer(tree);
        TableUtil.createColumns(tree, new String[]{Diagram_Messages.COL_NAME_Id, Diagram_Messages.COL_NAME_Name});
        this.labelProvider = new EObjectLabelProvider(this.getEditor()){

            @Override
            public Image getImage(Object element) {
                Image image = super.getImage(element);
                return image == null ? DiagramPlugin.getImage("icons/full/obj16/context.gif") : image;
            }

            @Override
            public String getText(String name, Object element) {
                if (name.equals("name") && element instanceof DataMappingType) {
                    DataMappingType dm = (DataMappingType)element;
                    ModelType model = ModelUtils.findContainingModel((EObject)dm);
                    ApplicationContextTypeType context = (ApplicationContextTypeType)ModelUtils.findIdentifiableElement((List)model.getApplicationContextType(), (String)dm.getContext());
                    DataType data = dm.getData();
                    String ds = data == null ? null : (data.getName() == null ? data.getId() : data.getName());
                    String as = dm.getApplicationAccessPoint();
                    if (context != null && context.isHasApplicationPath()) {
                        return String.valueOf(ds == null ? ActivityDataMappingsPropertyPage.UNDEFINED : ds) + (DirectionType.IN_LITERAL.equals((Object)dm.getDirection()) ? ">>" : "<<") + (as == null ? ActivityDataMappingsPropertyPage.UNDEFINED : as);
                    }
                    return ds == null ? ActivityDataMappingsPropertyPage.UNDEFINED : ds;
                }
                return super.getText(name, element);
            }
        };
        final DataType data = this.getData();
        TableUtil.setLabelProvider(this.viewer, this.labelProvider, new String[]{"id", "name"});
        this.viewer.setContentProvider((IContentProvider)new DataMappingsTreeContentProvider(data, this.isIn));
        DefaultOutlineProvider op = new DefaultOutlineProvider(this, (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getActivityType_DataMapping(), (EStructuralFeature)CarnotWorkflowModelPackage.eINSTANCE.getIIdentifiableElement_Id(), null, this.getPageId(), DataMappingPropertyPage.class.getName(), new IFilter(){

            public boolean select(Object object) {
                DataMappingType type = (DataMappingType)object;
                return ActivityDataMappingsPropertyPage.this.isIn == AccessPointUtil.isIn((DirectionType)type.getDirection()) && (data == null || data.equals(type.getData()));
            }
        }){

            @Override
            public ConfigurationElement createPageConfiguration(IModelElement element) {
                DataMappingType dataMapping = (DataMappingType)element;
                ApplicationContextTypeType ctxType = ActivityDataMappingsPropertyPage.this.getApplicationContext(dataMapping);
                return ConfigurationElement.createPageConfiguration(dataMapping.getId(), String.valueOf(dataMapping.getContext()) + ":" + dataMapping.getId(), this.getEditor().getIconFactory().getIconFor((EObject)ctxType), DataMappingPropertyPage.class.getName());
            }

            @Override
            public void addNodeTo(String parentNodeId, final CarnotPreferenceNode node) {
                this.page.addNodeTo(parentNodeId, node, new EObjectLabelProvider(this.getEditor()){

                    @Override
                    public String getText(String name, Object element) {
                        DataMappingType dataMapping = (DataMappingType)node.getAdaptable().getAdapter(IModelElement.class);
                        return String.valueOf(dataMapping.getContext()) + ":" + dataMapping.getId();
                    }
                });
            }
        };
        this.outlineSynchronizer = new ModelElementsOutlineSynchronizer(op);
        this.addModelElementsOutlineSynchronizer(this.outlineSynchronizer);
        return composite;
    }

    public Point computeSize() {
        TableUtil.setInitialColumnSizesDirect((Control)this.viewer.getTree(), new int[]{35, 65});
        return super.computeSize();
    }

    private boolean isValidContext(String context) {
        List contexts = ActivityUtil.getContextTypes((ActivityType)this.getActivity(), (DirectionType)(this.isIn ? DirectionType.IN_LITERAL : DirectionType.OUT_LITERAL));
        for (ApplicationContextTypeType applicationContext : contexts) {
            if (!applicationContext.getId().equals(context)) continue;
            return true;
        }
        return false;
    }
}

