/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.properties;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.SubProcessModeType;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.LoopMultiInstanceType;
import org.eclipse.stardust.model.xpdl.xpdl2.LoopType;
import org.eclipse.stardust.model.xpdl.xpdl2.LoopTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.MIOrderingType;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.common.ui.jface.utils.LabeledViewer;
import org.eclipse.stardust.modeling.common.ui.jface.widgets.LabelWithStatus;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.properties.AbstractModelElementPropertyPage;
import org.eclipse.stardust.modeling.core.ui.ProcessDefinitionSelectionViewer;
import org.eclipse.stardust.modeling.core.utils.WidgetBindingManager;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;

public class ActivitySubprocessPropertyPage
extends AbstractModelElementPropertyPage {
    private static final String PAGE_ID = "_cwm_subprocess_";
    public static final String[] LABELS = new String[]{Diagram_Messages.LABEL_SyncShared, "Sync Separate", Diagram_Messages.LABEL_AsyncSeparate};
    private LabeledViewer labeledComboViewer;
    private LabeledViewer labeledViewer;
    private Button checkCopyData;
    private boolean loading;
    private ComboViewer comboViewer;
    private ModelType model;

    @Override
    public void loadFieldsFromElement(IModelElementNodeSymbol symbol, IModelElement element) {
        this.loading = true;
        ActivityType activity = (ActivityType)element;
        this.model = (ModelType)activity.eContainer().eContainer();
        ProcessDefinitionSelectionViewer viewer = (ProcessDefinitionSelectionViewer)this.labeledViewer.getViewer();
        viewer.reset(this.model);
        this.updateSubprocessMode();
        WidgetBindingManager wBndMgr = this.getWidgetBindingManager();
        wBndMgr.bind(this.labeledViewer, (EObject)element, (EStructuralFeature)PKG_CWM.getActivityType_ImplementationProcess());
        wBndMgr.getModelBindingManager().updateWidgets((Object)element);
        this.checkCopyData.setSelection(Boolean.valueOf(AttributeUtil.getAttributeValue((IExtensibleElement)activity, (String)"carnot:engine:subprocess:copyAllData")).booleanValue());
        this.loading = false;
    }

    private ActivityType getActivity() {
        return (ActivityType)this.getModelElement();
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.updateSubprocessMode();
        }
        super.setVisible(visible);
    }

    private void updateSubprocessMode() {
        ActivityType activity = this.getActivity();
        SubProcessModeType mode = activity.getSubProcessMode();
        List input = SubProcessModeType.VALUES;
        if (this.isParallelMultiInstance(activity) && mode != SubProcessModeType.SYNC_SHARED_LITERAL) {
            input = CollectionUtils.newListFromElements((Collection)input);
            input.remove(0);
        }
        this.comboViewer.setInput((Object)input);
        this.comboViewer.setSelection((ISelection)new StructuredSelection((Object)mode));
    }

    private boolean isParallelMultiInstance(ActivityType activity) {
        LoopMultiInstanceType mi;
        LoopType loop = activity.getLoop();
        return loop != null && loop.getLoopType() == LoopTypeType.MULTI_INSTANCE && (mi = loop.getLoopMultiInstance()) != null && mi.getMIOrdering() == MIOrderingType.PARALLEL;
    }

    @Override
    public void loadElementFromFields(IModelElementNodeSymbol symbol, IModelElement element) {
        AttributeUtil.setBooleanAttribute((IExtensibleElement)((IExtensibleElement)element), (String)"carnot:engine:subprocess:copyAllData", (Boolean)this.checkCopyData.getSelection());
    }

    @Override
    public Control createBody(Composite parent) {
        Composite composite = FormBuilder.createComposite((Composite)parent, (int)1);
        LabelWithStatus label = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)Diagram_Messages.FORMBUILDER_LB_Subprocess);
        final ProcessDefinitionSelectionViewer tableViewer = new ProcessDefinitionSelectionViewer(composite, this.getEditor());
        tableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection;
                if (!ActivitySubprocessPropertyPage.this.loading && PlatformUI.getPreferenceStore().getBoolean("org.eclipse.stardust.modeling.common.projectnature.autoSubprocessNameGeneration") && (selection = (IStructuredSelection)tableViewer.getSelection()) != null && selection.getFirstElement() instanceof ProcessDefinitionType) {
                    ProcessDefinitionType pdt = (ProcessDefinitionType)selection.getFirstElement();
                    String defaultName = ((ProcessDefinitionType)selection.getFirstElement()).getName();
                    ActivityType activity = ActivitySubprocessPropertyPage.this.getActivity();
                    activity.setName(defaultName);
                    ModelType externalModel = (ModelType)pdt.eContainer();
                    if (((ActivityType)ActivitySubprocessPropertyPage.this.getModelElement()).getSubProcessMode().equals((Object)SubProcessModeType.SYNC_SHARED_LITERAL) && externalModel != ActivitySubprocessPropertyPage.this.model) {
                        activity.setSubProcessMode(SubProcessModeType.SYNC_SEPARATE_LITERAL);
                    }
                    ActivitySubprocessPropertyPage.this.updateSubprocessMode();
                    ActivitySubprocessPropertyPage.this.removePreferenceNodes(ActivitySubprocessPropertyPage.PAGE_ID, false);
                    ActivitySubprocessPropertyPage.this.addNodesTo(ActivitySubprocessPropertyPage.PAGE_ID);
                }
            }
        });
        this.labeledViewer = new LabeledViewer((StructuredViewer)tableViewer, label);
        final Button groupingCheckbox = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.LB_GroupModelElements);
        groupingCheckbox.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                ((ProcessDefinitionSelectionViewer)ActivitySubprocessPropertyPage.this.labeledViewer.getViewer()).setGrouped(groupingCheckbox.getSelection());
            }
        });
        LabelWithStatus comboLabel = FormBuilder.createLabelWithRightAlignedStatus((Composite)composite, (String)Diagram_Messages.FORMBUILDER_LB_ExecutionType);
        this.comboViewer = new ComboViewer(FormBuilder.createCombo((Composite)composite));
        this.comboViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.comboViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return ModelUtils.getSubprocessModeTypeText((SubProcessModeType)((SubProcessModeType)element));
            }
        });
        this.labeledComboViewer = new LabeledViewer((StructuredViewer)this.comboViewer, comboLabel);
        this.checkCopyData = FormBuilder.createCheckBox((Composite)composite, (String)Diagram_Messages.BOX_COPY_ALL_DATA, (int)2);
        this.comboViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = ((EditPart)ActivitySubprocessPropertyPage.this.getElement()).getModel();
                ActivityType activity = obj instanceof ActivitySymbolType ? ((ActivitySymbolType)obj).getActivity() : (ActivityType)obj;
                Object selection = ((IStructuredSelection)ActivitySubprocessPropertyPage.this.comboViewer.getSelection()).getFirstElement();
                if (selection != null) {
                    boolean isCopyAllData = selection.equals(SubProcessModeType.SYNC_SHARED_LITERAL) ? false : AttributeUtil.getBooleanValue((IExtensibleElement)activity, (String)"carnot:engine:subprocess:copyAllData");
                    ActivitySubprocessPropertyPage.this.checkCopyData.setSelection(isCopyAllData);
                    ActivitySubprocessPropertyPage.this.checkCopyData.setEnabled(!selection.equals(SubProcessModeType.SYNC_SHARED_LITERAL));
                    ActivitySubprocessPropertyPage.this.updateModelData();
                }
            }
        });
        this.checkCopyData.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ActivitySubprocessPropertyPage.this.updateModelData();
            }
        });
        return composite;
    }

    private void updateModelData() {
        Object obj = ((EditPart)this.getElement()).getModel();
        ActivityType activity = obj instanceof ActivitySymbolType ? ((ActivitySymbolType)obj).getActivity() : (ActivityType)obj;
        IStructuredSelection selection = (IStructuredSelection)this.labeledComboViewer.getViewer().getSelection();
        SubProcessModeType subProcMode = (SubProcessModeType)selection.getFirstElement();
        if (!CompareHelper.areEqual((Object)subProcMode, (Object)activity.getSubProcessMode())) {
            activity.setSubProcessMode(subProcMode);
        }
        AttributeUtil.setBooleanAttribute((IExtensibleElement)activity, (String)"carnot:engine:subprocess:copyAllData", (Boolean)this.checkCopyData.getSelection());
    }
}

