/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.core.search;

import java.text.MessageFormat;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.TreeEditPart;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.stardust.model.xpdl.carnot.DescriptionType;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElementNodeSymbol;
import org.eclipse.stardust.model.xpdl.carnot.INodeSymbol;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.core.editors.parts.tree.WorkflowModelTreeEditPartFactory;
import org.eclipse.stardust.modeling.core.search.ResultLabelProvider;
import org.eclipse.stardust.modeling.core.search.ResultTreeContentProvider;
import org.eclipse.stardust.modeling.core.search.WorkflowModelSearchQuery;
import org.eclipse.stardust.modeling.core.search.WorkflowModelSearchResult;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.IPageSite;
import org.eclipse.ui.part.Page;

public class SearchResultPage
extends Page
implements ISearchResultPage,
ISearchResultListener {
    private String id;
    private Object uiState;
    private WorkflowModelSearchResult searchResult;
    private ISearchResultViewPart part;
    private Composite composite;
    private TreeViewer viewer;
    private String label = "";

    public Object getUIState() {
        return this.uiState;
    }

    public void setInput(ISearchResult search, Object uiState) {
        this.uiState = uiState;
        this.searchResult = (WorkflowModelSearchResult)search;
        if (this.searchResult != null) {
            this.searchResult.addListener(this);
        }
    }

    public void setViewPart(ISearchResultViewPart part) {
        this.part = part;
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public IPageSite getSite() {
        return super.getSite();
    }

    public void init(IPageSite site) {
        super.init(site);
    }

    public void createControl(Composite parent) {
        final WorkflowModelEditor editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        this.composite = FormBuilder.createComposite((Composite)parent, (int)1);
        this.composite.setLayout((Layout)new FillLayout());
        this.viewer = new TreeViewer(FormBuilder.createTree((Composite)this.composite, (int)0));
        this.viewer.setContentProvider((IContentProvider)new ResultTreeContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ResultLabelProvider(editor));
        this.viewer.setSorter(new ViewerSorter());
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object obj = ((IStructuredSelection)event.getSelection()).getFirstElement();
                Object object = obj = obj instanceof DescriptionType ? ((EObject)obj).eContainer() : obj;
                if (obj instanceof IModelElementNodeSymbol) {
                    editor.selectSymbol((INodeSymbol)((IModelElementNodeSymbol)obj));
                } else if (obj instanceof IModelElement) {
                    EditPart part = new WorkflowModelTreeEditPartFactory(editor).createEditPart(null, obj);
                    if (!(part instanceof TreeEditPart)) {
                        obj = ((IModelElement)obj).eContainer();
                        part = new WorkflowModelTreeEditPartFactory(editor).createEditPart(null, obj);
                    }
                    editor.selectInOutline((EObject)((IModelElement)obj));
                }
            }
        });
        Tree tree = (Tree)this.viewer.getControl();
        tree.setLayout((Layout)new FillLayout());
        tree.setLayoutData(null);
    }

    public void dispose() {
        super.dispose();
    }

    public Control getControl() {
        return this.composite;
    }

    public void setFocus() {
    }

    public void searchResultChanged(SearchResultEvent e) {
        final Set matchedElements = this.searchResult.getMatchedElements();
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                SearchResultPage.this.viewer.setInput((Object)matchedElements);
                SearchResultPage.this.label = MessageFormat.format(Diagram_Messages.LB_Result, ((WorkflowModelSearchQuery)SearchResultPage.this.searchResult.getQuery()).getSearchText(), String.valueOf(matchedElements.size()), matchedElements.size() == 1 ? Diagram_Messages.LB_Reference : Diagram_Messages.LB_References);
                SearchResultPage.this.part.updateLabel();
            }
        });
    }
}

