/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.data.structured.validation;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.Extensible;
import org.eclipse.stardust.model.xpdl.xpdl2.ExternalReferenceType;
import org.eclipse.stardust.model.xpdl.xpdl2.SchemaTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationsType;
import org.eclipse.stardust.model.xpdl.xpdl2.XpdlTypeType;
import org.eclipse.stardust.model.xpdl.xpdl2.util.ExtendedAttributeUtil;
import org.eclipse.stardust.model.xpdl.xpdl2.util.TypeDeclarationUtils;
import org.eclipse.stardust.modeling.common.platform.utils.WorkspaceUtils;
import org.eclipse.stardust.modeling.core.utils.GenericUtils;
import org.eclipse.stardust.modeling.data.structured.Structured_Messages;
import org.eclipse.stardust.modeling.validation.IModelValidator;
import org.eclipse.stardust.modeling.validation.Issue;
import org.eclipse.stardust.modeling.validation.ValidationException;
import org.eclipse.stardust.modeling.validation.util.TypeFinder;
import org.eclipse.stardust.modeling.validation.util.TypeInfo;
import org.eclipse.xsd.XSDDiagnostic;
import org.eclipse.xsd.XSDImport;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSimpleTypeDefinition;

public class ModelValidator
implements IModelValidator {
    private static final Issue[] ISSUE_ARRAY = new Issue[0];

    private boolean canResolveExternalReference(String location, IProject project) {
        try {
            new URL(location);
            return true;
        }
        catch (MalformedURLException malformedURLException) {
            try {
                IJavaProject javaProject;
                if (project.hasNature("org.eclipse.jdt.core.javanature") && GenericUtils.getFile((IJavaProject)(javaProject = JavaCore.create((IProject)project)), (String)location, (boolean)true) != null) {
                    return true;
                }
            }
            catch (CoreException e1) {
                e1.printStackTrace();
            }
            return false;
        }
    }

    public Issue[] validate(ModelType model) throws ValidationException {
        IProject project = WorkspaceUtils.getProjectFromEObject((EObject)model);
        List result = CollectionUtils.newList();
        TypeDeclarationsType declarations = model.getTypeDeclarations();
        EList allDeclarations = declarations.getTypeDeclaration();
        for (TypeDeclarationType declaration : allDeclarations) {
            XSDSchema schema;
            boolean canResolveExternalReference;
            String location;
            XpdlTypeType dataType;
            Issue duplicateId = this.checkTypeDeclaration(declaration, (List<TypeDeclarationType>)allDeclarations);
            if (duplicateId != null) {
                result.add(duplicateId);
            }
            if (!((dataType = declaration.getDataType()) instanceof SchemaTypeType) && !(dataType instanceof ExternalReferenceType)) continue;
            if (dataType instanceof ExternalReferenceType && (location = ((ExternalReferenceType)dataType).getLocation()) != null && !location.startsWith("urn:internal:") && !(canResolveExternalReference = this.canResolveExternalReference(location, project))) {
                result.add(Issue.error((EObject)declaration, (String)MessageFormat.format("TypeDeclaration ''{0}'': imported file ''{1}'' not found.", declaration.getId(), location)));
            }
            if (!(dataType instanceof SchemaTypeType) || (schema = declaration.getSchema()) == null) continue;
            schema.validate();
            EList diagnostics = schema.getDiagnostics();
            schema.clearDiagnostics();
            for (XSDDiagnostic diagnostic : diagnostics) {
                String message = diagnostic.getMessage();
                result.add(Issue.error((EObject)declaration, (String)message));
            }
            List xsdImports = TypeDeclarationUtils.getImports((XSDSchema)schema);
            if (xsdImports != null) {
                for (XSDImport xsdImport : xsdImports) {
                    String typeId;
                    String location2 = xsdImport.getSchemaLocation();
                    if (!location2.startsWith("urn:internal:") || declarations.getTypeDeclaration(typeId = location2.substring("urn:internal:".length())) != null) continue;
                    result.add(Issue.error((EObject)declaration, (String)MessageFormat.format("TypeDeclaration ''{0}'': referenced type ''{1}'' not found.", declaration.getId(), typeId)));
                }
            }
            this.checkEnumeration(declaration, result);
        }
        return result.toArray(ISSUE_ARRAY);
    }

    private Issue checkTypeDeclaration(TypeDeclarationType checkDeclaration, List<TypeDeclarationType> allDeclarations) {
        for (TypeDeclarationType declaration : allDeclarations) {
            if (declaration.equals(checkDeclaration) || !declaration.getId().equals(checkDeclaration.getId())) continue;
            return Issue.error((EObject)checkDeclaration, (String)MessageFormat.format("TypeDeclaration ''{0}'' has duplicate Id.", checkDeclaration.getId()));
        }
        return null;
    }

    private void checkEnumeration(TypeDeclarationType checkDeclaration, List<Issue> result) {
        XSDSimpleTypeDefinition component = TypeDeclarationUtils.getSimpleType((TypeDeclarationType)checkDeclaration);
        if (component instanceof XSDSimpleTypeDefinition && ExtendedAttributeUtil.getAttribute((Extensible)checkDeclaration, (String)"carnot:engine:className") != null) {
            TypeFinder finder;
            TypeInfo type;
            ModelType model = ModelUtils.findContainingModel((EObject)checkDeclaration);
            String className = ExtendedAttributeUtil.getAttributeValue((Extensible)checkDeclaration, (String)"carnot:engine:className");
            if (StringUtils.isEmpty((String)className)) {
                result.add(Issue.error((EObject)checkDeclaration, (String)Structured_Messages.ERROR_MSG_NO_CLASSNAME));
            } else if (model != null && TypeFinder.getProjectFromEObject((EObject)model) != null && (type = (finder = new TypeFinder((EObject)model)).findType(className)) == null) {
                result.add(Issue.error((EObject)checkDeclaration, (String)MessageFormat.format(Structured_Messages.ERROR_MSG_INVALID_CLASSNAME, className)));
            }
        }
    }
}

