/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.model.i18n.properties;

import java.util.Properties;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.modeling.model.i18n.properties.PropertyModel;

public class PropertyBundleCommand
extends CompoundCommand {
    private ModelType model;
    private PropertyModel propertyModel;

    public PropertyBundleCommand(ModelType model) {
        this.model = model;
    }

    public void redo() {
        this.propertyModel = PropertyModel.get(this.model);
        super.redo();
        this.propertyModel.save();
        this.propertyModel.dispose();
    }

    public void undo() {
        this.propertyModel = PropertyModel.get(this.model);
        super.undo();
        this.propertyModel.save();
        this.propertyModel.dispose();
    }

    public void addUpdatePropertiesFor(IIdentifiableElement changedElement, String oldId, String newId) {
        this.add(new UpdatePropertiesFor(changedElement, oldId, newId));
    }

    public void addLocale(Object locale) {
        this.add(new AddLocale(locale));
    }

    public void setProperty(Object locale, String propertyName, String newValue, String oldValue) {
        this.add(new SetProperty(locale, propertyName, newValue, oldValue));
    }

    private class AddLocale
    extends Command {
        private Object locale;
        private Properties properties;

        public AddLocale(Object locale) {
            this.locale = locale;
        }

        public void redo() {
            PropertyBundleCommand.this.propertyModel.addLocale(this.locale, this.properties);
            this.properties = null;
        }

        public void undo() {
            this.properties = PropertyBundleCommand.this.propertyModel.getPropertiesFor(this.locale);
            PropertyBundleCommand.this.propertyModel.deleteNls(this.locale);
        }
    }

    private class SetProperty
    extends Command {
        private Object locale;
        private String propertyName;
        private String newValue;
        private String oldValue;

        public SetProperty(Object locale, String propertyName, String newValue, String oldValue) {
            this.locale = locale;
            this.propertyName = propertyName;
            this.newValue = newValue;
            this.oldValue = oldValue;
        }

        public void redo() {
            this.set(this.newValue);
        }

        public void undo() {
            this.set(this.oldValue);
        }

        public void set(String value) {
            if (value == null) {
                PropertyBundleCommand.this.propertyModel.deleteProperty(this.locale, this.propertyName);
            } else {
                PropertyBundleCommand.this.propertyModel.setProperty(this.locale, this.propertyName, value);
            }
        }
    }

    private class UpdatePropertiesFor
    extends Command {
        private IIdentifiableElement changedElement;
        private String oldId;
        private String newId;

        public UpdatePropertiesFor(IIdentifiableElement changedElement, String oldId, String newId) {
            this.changedElement = changedElement;
            this.oldId = oldId;
            this.newId = newId;
        }

        public void redo() {
            PropertyBundleCommand.this.propertyModel.updatePropertiesFor(this.changedElement, this.oldId, this.newId);
        }

        public void undo() {
            PropertyBundleCommand.this.propertyModel.updatePropertiesFor(this.changedElement, this.newId, this.oldId);
        }
    }
}

