/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.modelimport.elements;

import java.util.Collections;
import java.util.List;
import org.eclipse.compare.IEditableContent;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.structuremergeviewer.IStructureComparator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.model.xpdl.carnot.AttributeType;
import org.eclipse.stardust.model.xpdl.carnot.ContextType;
import org.eclipse.stardust.model.xpdl.carnot.Coordinates;
import org.eclipse.stardust.model.xpdl.carnot.DataMappingType;
import org.eclipse.stardust.model.xpdl.carnot.DataPathType;
import org.eclipse.stardust.model.xpdl.carnot.DescriptionType;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.IIdentifiableElement;
import org.eclipse.stardust.model.xpdl.carnot.IModelElement;
import org.eclipse.stardust.model.xpdl.carnot.ISwimlaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.LaneSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ParticipantType;
import org.eclipse.stardust.model.xpdl.carnot.PoolSymbol;
import org.eclipse.stardust.model.xpdl.carnot.TextType;
import org.eclipse.stardust.model.xpdl.carnot.ViewType;
import org.eclipse.stardust.model.xpdl.carnot.XmlTextNode;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.model.xpdl.xpdl2.TypeDeclarationType;
import org.eclipse.stardust.modeling.core.DiagramPlugin;
import org.eclipse.stardust.modeling.core.editors.parts.IconFactory;
import org.eclipse.stardust.modeling.modelimport.elements.AttributeComparator;
import org.eclipse.stardust.modeling.modelimport.elements.MergeUtil;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.swt.graphics.Image;

public class StructureComparator
implements IStructureComparator,
ITypedElement,
IEditableContent {
    EObject model;
    private IStructureComparator parent;
    private IStructureComparator[] children;
    private String key;

    public StructureComparator(EObject model, IStructureComparator parent) {
        this.model = model;
        this.parent = parent;
        this.key = this.computeUniqueIdentifier();
    }

    String computeUniqueIdentifier() {
        String id = null;
        if (this.model instanceof DiagramType) {
            id = ((DiagramType)this.model).getName();
        }
        if (this.model instanceof ViewType) {
            id = ((DiagramType)this.model).getName();
        }
        if (this.model instanceof AttributeType) {
            id = ((AttributeType)this.model).getName();
        }
        if (this.model instanceof ParticipantType) {
            id = ((ParticipantType)this.model).getParticipant().getId();
        }
        if (this.model instanceof ContextType) {
            String string = id = ((ContextType)this.model).getMetaType() != null ? ((ContextType)this.model).getMetaType().getId() : ((ContextType)this.model).toString();
        }
        if (this.model instanceof Coordinates) {
            id = Integer.toString(this.getList(this.model.eContainer(), this.model.eContainingFeature()).indexOf(this.model));
        }
        if (this.model instanceof DataMappingType) {
            id = String.valueOf(((DataMappingType)this.model).getContext()) + ":" + ((DataMappingType)this.model).getDirection() + ":" + ((DataMappingType)this.model).getId();
        }
        if (this.model instanceof IIdentifiableElement) {
            id = ((IIdentifiableElement)this.model).getId();
        }
        if (this.model instanceof DataPathType) {
            id = ((DataPathType)this.model).getDirection() + ":" + id;
        }
        if (this.model instanceof TypeDeclarationType) {
            id = ((TypeDeclarationType)this.model).getId();
        }
        if (this.model instanceof Connection) {
            id = ((Connection)this.model).getId();
        }
        if (id == null && this.model instanceof IModelElement) {
            id = Long.toString(((IModelElement)this.model).getElementOid());
        }
        if (id == null && this.model.eContainingFeature() != null && !this.model.eContainingFeature().isMany()) {
            id = this.model.eContainingFeature().getName();
        }
        if (id == null) {
            id = StructureComparator.getEObjectLabel(this.model);
        }
        return String.valueOf(this.model.eClass().getName()) + ':' + id;
    }

    public Object[] getChildren() {
        if (this.children == null) {
            List all = CollectionUtils.newList();
            this.addAttributes(all);
            this.addReferences(all);
            this.addContents(all);
            this.children = all.toArray(new IStructureComparator[all.size()]);
        }
        return this.children;
    }

    void addContents(List<IStructureComparator> all) {
        EList contents = this.model.eContents();
        for (EObject eObject : contents) {
            if (!"http://www.carnot.ag/workflowmodel/3.1".equals(eObject.eClass().getEPackage().getNsURI()) && !"http://www.wfmc.org/2008/XPDL2.1".equals(eObject.eClass().getEPackage().getNsURI())) continue;
            this.addContentElement(all, eObject);
        }
    }

    void addContentElement(List<IStructureComparator> all, EObject eObject) {
        all.add(new StructureComparator(eObject, this));
    }

    void addReferences(List<IStructureComparator> all) {
        EList references = this.model instanceof IModelElement || this.model instanceof ModelType || this.model instanceof TypeDeclarationType ? this.model.eClass().getEAllReferences() : Collections.emptyList();
        for (EReference reference : references) {
            this.addReference(all, reference);
        }
    }

    void addReference(List<IStructureComparator> all, EReference reference) {
        if (!reference.isContainment() && !reference.isMany()) {
            all.add(new AttributeComparator(this.model, reference.getName(), this));
        }
    }

    void addAttributes(List<IStructureComparator> all) {
        EList attributes = this.model instanceof IModelElement || this.model instanceof ModelType || this.model instanceof TypeDeclarationType ? this.model.eClass().getEAllAttributes() : Collections.emptyList();
        for (EAttribute attribute : attributes) {
            this.addAttribute(all, attribute);
        }
    }

    private void addAttribute(List<IStructureComparator> all, EAttribute attribute) {
        if (!attribute.isMany()) {
            all.add(new AttributeComparator(this.model, attribute.getName(), this));
        }
    }

    public IStructureComparator getParent() {
        return this.parent;
    }

    public Image getImage() {
        if (this.model instanceof AttributeType || this.model instanceof DescriptionType || this.model instanceof TextType || this.model instanceof XmlTextNode) {
            return DiagramPlugin.getImage((String)"/icons/full/obj16/attribute_obj.gif");
        }
        String icon = IconFactory.getDefault().getIconFor(this.model);
        return icon == null ? null : DiagramPlugin.getImage((String)icon);
    }

    public String getName() {
        return StructureComparator.getName(this.model);
    }

    static String getName(EObject model) {
        EStructuralFeature mixed;
        String name = null;
        if (model instanceof TypeDeclarationType) {
            name = ((TypeDeclarationType)model).getName();
        }
        if (model instanceof Connection) {
            name = ((Connection)model).getName();
        }
        if (model instanceof DiagramType) {
            name = ((DiagramType)model).getName();
        }
        if (model instanceof AttributeType) {
            AttributeType attribute = (AttributeType)model;
            StringBuffer buffer = new StringBuffer();
            buffer.append(attribute.getName());
            if (attribute.getType() != null) {
                buffer.append('[').append(attribute.getType()).append(']');
            }
            buffer.append('=').append(attribute.getAttributeValue());
            name = buffer.toString();
        }
        if (model instanceof ParticipantType) {
            name = "participant=" + ((ParticipantType)model).getParticipant().getId();
        }
        if (model instanceof IIdentifiableElement) {
            name = ((IIdentifiableElement)model).getId();
        }
        if (name == null && model instanceof IModelElement) {
            name = String.valueOf(model.eClass().getName()) + ": " + ((IModelElement)model).getElementOid();
        }
        if (name == null && (mixed = model.eClass().getEStructuralFeature("mixed")) != null) {
            String prefix = model.eContainingFeature() == null ? model.eClass().getName() : model.eContainingFeature().getName();
            name = String.valueOf(prefix) + "=" + ModelUtils.getCDataString((FeatureMap)((FeatureMap)model.eGet(mixed)));
        }
        if (name == null) {
            EPackage pkg = model.eClass().getEPackage();
            name = pkg.getNsURI().equals("http://www.carnot.ag/workflowmodel/3.1") ? StructureComparator.getEObjectLabel(model) : String.valueOf(pkg.getNsURI()) + ":" + model.eClass().getName();
        }
        return name;
    }

    private static String getEObjectLabel(EObject model) {
        String label = model.toString();
        int idx = label.indexOf(40);
        return idx < 0 ? label : label.substring(idx);
    }

    public String getType() {
        return this.model.eClass().getName();
    }

    public String toString() {
        return this.getName();
    }

    public int hashCode() {
        return this.key.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        return obj instanceof StructureComparator && this.key.equals(((StructureComparator)obj).key);
    }

    public int getCategory() {
        if (!(this.model instanceof IModelElement)) {
            return this.model.eClass().getClassifierID() + 1000;
        }
        return this.model.eContainingFeature().getFeatureID() + 10000;
    }

    public boolean isEditable() {
        return false;
    }

    public ITypedElement replace(ITypedElement dest, ITypedElement src) {
        this.children = null;
        if (dest == null) {
            return this.add(src);
        }
        if (src == null) {
            return this.remove(dest);
        }
        return this.copy(dest, src);
    }

    ITypedElement copy(ITypedElement dest, ITypedElement src) {
        EObject destModel = this.getModel(dest);
        EObject srcModel = this.getModel(src);
        if (dest instanceof AttributeComparator) {
            EStructuralFeature feature = destModel.eClass().getEStructuralFeature(((AttributeComparator)dest).attributeName);
            Object value = srcModel.eGet(feature);
            if (value instanceof EObject) {
                value = MergeUtil.copy((EObject)value);
            }
            destModel.eSet(feature, value);
        } else {
            EcoreUtil.replace((EObject)destModel, (EObject)MergeUtil.copy(srcModel));
        }
        return dest;
    }

    EObject getModel(ITypedElement dest) {
        return dest instanceof AttributeComparator ? ((AttributeComparator)dest).model : ((StructureComparator)dest).model;
    }

    ITypedElement remove(ITypedElement dest) {
        EStructuralFeature feature;
        EObject destModel = this.getModel(dest);
        if (destModel instanceof LaneSymbol) {
            ((LaneSymbol)destModel).setParentLane(null);
            ((LaneSymbol)destModel).setParentPool(null);
        }
        if ((feature = destModel.eContainingFeature()).isMany()) {
            this.getList(this.model, feature).remove(destModel);
        } else if (feature.isUnsettable()) {
            this.model.eUnset(feature);
        } else {
            this.model.eSet(feature, null);
        }
        return null;
    }

    ITypedElement add(ITypedElement src) {
        EObject srcModel = this.getModel(src);
        EStructuralFeature feature = srcModel.eContainingFeature();
        EObject value = this.clone(srcModel);
        if (feature.isMany()) {
            this.getList(this.model, feature).add(value);
        } else {
            this.model.eSet(feature, (Object)value);
        }
        if (value instanceof LaneSymbol) {
            ((LaneSymbol)value).setParentLane((ISwimlaneSymbol)this.model);
            ((LaneSymbol)value).setParentPool(this.getPool());
        }
        return new StructureComparator(value, this);
    }

    EObject clone(EObject model) {
        return MergeUtil.copyAdd(model);
    }

    <T extends EObject> List<T> getList(EObject model, EStructuralFeature feature) {
        return (List)model.eGet(feature);
    }

    private PoolSymbol getPool() {
        if (this.model instanceof PoolSymbol) {
            return (PoolSymbol)this.model;
        }
        if (this.model instanceof LaneSymbol) {
            return ((LaneSymbol)this.model).getParentPool();
        }
        return null;
    }

    public void setContent(byte[] newContent) {
    }
}

