/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.repository.file;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.NotificationImpl;
import org.eclipse.emf.common.util.URI;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.repository.common.Connection;
import org.eclipse.stardust.modeling.repository.common.ConnectionManager;
import org.eclipse.stardust.modeling.repository.common.IObjectDescriptor;
import org.eclipse.stardust.modeling.repository.common.SearchConnectionHandler;
import org.eclipse.stardust.modeling.repository.common.descriptors.CategoryDescriptor;
import org.eclipse.stardust.modeling.repository.common.ui.ConnectionQueryUtils;
import org.eclipse.stardust.modeling.repository.file.search.SearchDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class FileSearchConnectionHandler
implements SearchConnectionHandler {
    public void performSearch(Connection connection) {
        URI uri = ConnectionManager.makeURI((Connection)connection);
        WorkflowModelEditor editor = (WorkflowModelEditor)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
        ConnectionManager cm = editor.getConnectionManager();
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        SearchDialog dialog = new SearchDialog(shell);
        if (dialog.open() == 0 && dialog.getSearchString() != null && dialog.getSearchString().length() != 0) {
            if (!StringUtils.isEmpty((String)dialog.getSearchString())) {
                try {
                    List descriptors = ConnectionQueryUtils.select((Connection)connection, (ConnectionManager)cm, null);
                    List<IObjectDescriptor> result = dialog.searchEntries(descriptors);
                    if (result != null) {
                        CategoryDescriptor searchDescriptor = new CategoryDescriptor(uri, "search", "Search Result", result.toArray(new IObjectDescriptor[result.size()]), "org.eclipse.stardust.modeling.repository.file", "icons/search.gif");
                        connection.setProperty("search.result", (Object)searchDescriptor);
                    } else {
                        connection.removeProperty("search.result");
                    }
                }
                catch (CoreException coreException) {
                    connection.removeProperty("search.result");
                }
                connection.eNotify((Notification)new NotificationImpl(5, null, null));
            }
            dialog.close();
        }
    }

    public boolean supportsSearch() {
        return true;
    }
}

