/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.templates.basic.ui;

import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.stardust.model.xpdl.carnot.ActivitySymbolType;
import org.eclipse.stardust.model.xpdl.carnot.ActivityType;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelFactory;
import org.eclipse.stardust.model.xpdl.carnot.CarnotWorkflowModelPackage;
import org.eclipse.stardust.model.xpdl.carnot.DiagramType;
import org.eclipse.stardust.model.xpdl.carnot.FlowControlType;
import org.eclipse.stardust.model.xpdl.carnot.GatewaySymbol;
import org.eclipse.stardust.model.xpdl.carnot.IFlowObjectSymbol;
import org.eclipse.stardust.model.xpdl.carnot.ISymbolContainer;
import org.eclipse.stardust.model.xpdl.carnot.JoinSplitType;
import org.eclipse.stardust.model.xpdl.carnot.ModelType;
import org.eclipse.stardust.model.xpdl.carnot.ProcessDefinitionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionConnectionType;
import org.eclipse.stardust.model.xpdl.carnot.TransitionType;
import org.eclipse.stardust.model.xpdl.carnot.XmlTextNode;
import org.eclipse.stardust.model.xpdl.carnot.util.ModelUtils;
import org.eclipse.stardust.modeling.core.editors.WorkflowModelEditor;
import org.eclipse.stardust.modeling.templates.basic.Templates_Basic_Messages;
import org.eclipse.stardust.modeling.templates.basic.ui.ParallelSplitTemplatePage;
import org.eclipse.stardust.modeling.templates.defaulttemplate.TemplateHelper;

public class ParallelSplitTemplateWizard
extends Wizard {
    private ParallelSplitTemplatePage newTemplatePage;
    private WorkflowModelEditor editor;
    private ModelType model;
    private DiagramType diagram;
    private ProcessDefinitionType process;
    private int xHint;
    private int yHint;
    private static CarnotWorkflowModelPackage PKG = CarnotWorkflowModelPackage.eINSTANCE;
    private static CarnotWorkflowModelFactory factory = CarnotWorkflowModelFactory.eINSTANCE;
    private EditPart editPart;
    private TemplateHelper templateHelper;
    private XmlTextNode expression;
    private boolean killed;

    public ParallelSplitTemplateWizard() {
    }

    public ParallelSplitTemplateWizard(WorkflowModelEditor targetEditor, ModelType targetModel, DiagramType targetDiagram, EditPart editPart, int xHint, int yHint) {
        this.setWindowTitle(Templates_Basic_Messages.TXT_APPLY_PARALLEL_SPLIT_TEMPLATE);
        this.editPart = editPart;
        this.model = targetModel;
        this.editor = targetEditor;
        this.diagram = targetDiagram;
        this.process = (ProcessDefinitionType)targetDiagram.eContainer();
        this.xHint = xHint;
        this.yHint = yHint;
        if (editPart.getModel() != null && editPart.getModel() instanceof ISymbolContainer) {
            this.xHint = 5;
            this.yHint = 5;
        }
        this.templateHelper = new TemplateHelper(this.model, this.diagram, this.process, editPart);
    }

    public void addPages() {
        super.addPages();
        this.newTemplatePage = new ParallelSplitTemplatePage(Templates_Basic_Messages.TXT_AND_SPLIT_TEMPLATE, Templates_Basic_Messages.TXT_AND_SPLIT_TEMPLATE, null);
        this.addPage((IWizardPage)this.newTemplatePage);
    }

    public boolean performFinish() {
        String kind = this.newTemplatePage.getKind();
        int number = Integer.parseInt(this.newTemplatePage.getNumber());
        int x = this.xHint;
        int y = this.yHint;
        ActivityType rootActivity = this.templateHelper.createActivity(String.valueOf(kind) + " 0", kind);
        rootActivity.setSplit(JoinSplitType.AND_LITERAL);
        ActivitySymbolType rootActivitySymbol = this.templateHelper.createActivitySymbol(rootActivity, x, y);
        GatewaySymbol gatewaySymbol = this.templateHelper.createGatewaySymbol(rootActivitySymbol, FlowControlType.SPLIT_LITERAL);
        gatewaySymbol.setXPos((long)x);
        gatewaySymbol.setYPos((long)(y += 100));
        TransitionConnectionType rootTransitionSymbol = this.templateHelper.createTransitionSymbol(null);
        rootTransitionSymbol.setSourceActivitySymbol((IFlowObjectSymbol)rootActivitySymbol);
        rootTransitionSymbol.setTargetActivitySymbol((IFlowObjectSymbol)gatewaySymbol);
        y += 100;
        int i = 0;
        while (i < number) {
            ActivityType splitActivity = this.templateHelper.createActivity(String.valueOf(kind) + " " + (i + 1), kind);
            ActivitySymbolType splitActivitySymbol = this.templateHelper.createActivitySymbol(splitActivity, x, y);
            TransitionType splitTransition = this.templateHelper.createTransition("Transition " + i);
            splitTransition.setCondition("CONDITION");
            this.expression = CarnotWorkflowModelFactory.eINSTANCE.createXmlTextNode();
            splitTransition.setExpression(this.expression);
            ModelUtils.setCDataString((FeatureMap)this.expression.getMixed(), (String)"true", (boolean)true);
            TransitionConnectionType splitTransitionSymbol = this.templateHelper.createTransitionSymbol(splitTransition);
            splitTransition.setFrom(rootActivity);
            splitTransition.setTo(splitActivity);
            splitTransitionSymbol.setSourceActivitySymbol((IFlowObjectSymbol)gatewaySymbol);
            splitTransitionSymbol.setTargetActivitySymbol((IFlowObjectSymbol)splitActivitySymbol);
            splitTransitionSymbol.setTargetAnchor("top");
            x += 200;
            ++i;
        }
        return true;
    }

    public boolean isKilled() {
        return this.killed;
    }
}

