/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.templates.views;

import java.awt.Frame;
import java.net.URL;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.stardust.modeling.common.ui.jface.utils.FormBuilder;
import org.eclipse.stardust.modeling.core.Diagram_Messages;
import org.eclipse.stardust.modeling.templates.spi.ITemplate;
import org.eclipse.stardust.modeling.templates.spi.ITemplateFactory;
import org.eclipse.stardust.modeling.templates.views.DropTemplateWorkflowModelEditorAction;
import org.eclipse.stardust.modeling.templates.views.ExtendedHTMLEditorKit;
import org.eclipse.stardust.modeling.templates.views.PartListener;
import org.eclipse.stardust.modeling.templates.views.PatternsContentProvider;
import org.eclipse.stardust.modeling.templates.views.PatternsLabelProvider;
import org.eclipse.stardust.modeling.templates.views.WorkbenchPageListener;
import org.eclipse.stardust.modeling.templates.views.WorkbenchWindowListener;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.part.ViewPart;

public class PatternsView
extends ViewPart {
    private WorkbenchWindowListener listener;
    private Browser browser;
    private JTextPane textPane;

    public void dispose() {
        this.listener.unregister();
        this.listener = null;
        super.dispose();
    }

    public void createPartControl(Composite parent) {
        this.listener = new WorkbenchWindowListener(new WorkbenchPageListener(new PartListener(new DropTemplateWorkflowModelEditorAction())));
        this.listener.register();
        FillLayout parentLayout = new FillLayout();
        parent.setLayout((Layout)parentLayout);
        SashForm sashForm = new SashForm(parent, 256);
        Tree tree = new Tree((Composite)sashForm, 2048);
        tree.setLinesVisible(false);
        tree.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData());
        Composite composite = FormBuilder.createComposite((Composite)sashForm, (int)1);
        Composite swingComposite = new Composite(composite, 0x1000000);
        swingComposite.setLayoutData((Object)FormBuilder.createDefaultMultiLineWidgetGridData());
        Frame locationFrame = SWT_AWT.new_Frame((Composite)swingComposite);
        this.textPane = new JTextPane();
        JScrollPane scrollPane = new JScrollPane(this.textPane);
        locationFrame.add(scrollPane);
        this.textPane.setContentType("text/html");
        StyleSheet css = ((HTMLEditorKit)this.textPane.getEditorKit()).getStyleSheet();
        URL url = ((Object)((Object)this)).getClass().getResource("/html/carnot.css");
        css.importStyleSheet(url);
        this.textPane.setEditable(false);
        sashForm.setWeights(new int[]{1, 2});
        final TreeViewer viewer = new TreeViewer(tree);
        viewer.setContentProvider((IContentProvider)new PatternsContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new PatternsLabelProvider());
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TreeSelection selection = (TreeSelection)event.getSelection();
                Object object = selection.getFirstElement();
                if (object instanceof ITemplate) {
                    ITemplate template = (ITemplate)object;
                    PatternsView.this.textPane.setEditorKit(new ExtendedHTMLEditorKit(template));
                    PatternsView.this.textPane.setText(template.getDescription());
                } else if (object instanceof ITemplateFactory) {
                    ITemplateFactory templateFactory = (ITemplateFactory)object;
                    PatternsView.this.textPane.setText(templateFactory.getDescription());
                }
            }
        });
        viewer.addDragSupport(1, new Transfer[]{LocalSelectionTransfer.getTransfer()}, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                ISelection selection = viewer.getSelection();
                LocalSelectionTransfer.getTransfer().setSelection(selection);
                LocalSelectionTransfer.getTransfer().setSelectionSetTime((long)event.time & 0xFFFFFFFFL);
                event.doit = DropTemplateWorkflowModelEditorAction.isValidDndSelection(selection);
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = LocalSelectionTransfer.getTransfer().getSelection();
            }

            public void dragFinished(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(null);
                LocalSelectionTransfer.getTransfer().setSelectionSetTime(0L);
            }
        });
        IToolBarManager tbm = this.getViewSite().getActionBars().getToolBarManager();
        Action refreshAction = new Action(Diagram_Messages.LB_VersionRepository_Refresh){

            public void run() {
                viewer.setInput((Object)"org.eclipse.stardust.modeling.templates.templateProvider");
            }
        };
        tbm.add((IAction)refreshAction);
        refreshAction.run();
    }

    public void setFocus() {
    }
}

