/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.format;

import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.StandardClasspathProvider;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.engine.extensions.transformation.format.IMessageFormat;
import org.eclipse.stardust.modeling.transformation.messaging.format.IMessageFormatDependencyProvider;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.Modeling_Messages;

public class FormatManager {
    private static final String EXTENSION_POINT_ID = "org.eclipse.stardust.modeling.transformation.messageFormat";
    private static final String CONFIGURATION_ID = "messageFormat";
    private static final String ID_FIELD_ID = "id";
    private static final String CLASS_FIELD_ID = "class";
    private static final String DEPENDENCY_PROVIDER_FIELD_ID = "dependencyProvider";

    private static IExtensionPoint getMessageFormatExtensionPoint() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(EXTENSION_POINT_ID);
        if (point == null) {
            throw new RuntimeException(Modeling_Messages.EXC_EXTENSION_POINT_NOT_FOUND);
        }
        return point;
    }

    public static List<String> getMessageFormats() {
        IExtension[] extensions = FormatManager.getMessageFormatExtensionPoint().getExtensions();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            int j = 0;
            while (j < extension.getConfigurationElements().length) {
                IConfigurationElement configurationElement = extension.getConfigurationElements()[j];
                if (configurationElement.getName().equals(CONFIGURATION_ID)) {
                    list.add(configurationElement.getAttribute(ID_FIELD_ID));
                }
                ++j;
            }
            ++i;
        }
        return list;
    }

    public static IMessageFormat getMessageFormat(String id, ILaunchConfiguration launchConfiguration) {
        IExtension[] extensions = FormatManager.getMessageFormatExtensionPoint().getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            int j = 0;
            while (j < extension.getConfigurationElements().length) {
                IConfigurationElement configurationElement = extension.getConfigurationElements()[j];
                if (configurationElement.getName().equals(CONFIGURATION_ID) && configurationElement.getAttribute(ID_FIELD_ID).equals(id)) {
                    try {
                        return (IMessageFormat)configurationElement.createExecutableExtension(CLASS_FIELD_ID);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(MessageFormat.format(Modeling_Messages.EXC_CANNOT_LOAD_MSG_FORMAT_CL, configurationElement.getAttribute(CLASS_FIELD_ID), id), e);
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static URL[] parseClasspath(ILaunchConfiguration configuration) throws CoreException {
        StandardClasspathProvider standardClasspathProvider = new StandardClasspathProvider();
        IRuntimeClasspathEntry[] runtimeClasspathEntries = standardClasspathProvider.resolveClasspath(standardClasspathProvider.computeUnresolvedClasspath(configuration), configuration);
        List urls = CollectionUtils.newList();
        int i = 0;
        while (i < runtimeClasspathEntries.length) {
            try {
                IResource resource = runtimeClasspathEntries[i].getResource();
                if (resource != null) {
                    urls.add(runtimeClasspathEntries[i].getResource().getLocationURI().toURL());
                }
            }
            catch (MalformedURLException e) {
                throw new RuntimeException(e);
            }
            ++i;
        }
        return urls.toArray(new URL[urls.size()]);
    }

    public static IMessageFormatDependencyProvider getMessageFormatDependencyProvider(String messageFormatId) {
        IExtension[] extensions = FormatManager.getMessageFormatExtensionPoint().getExtensions();
        int i = 0;
        while (i < extensions.length) {
            IExtension extension = extensions[i];
            int j = 0;
            while (j < extension.getConfigurationElements().length) {
                String className;
                IConfigurationElement configurationElement = extension.getConfigurationElements()[j];
                if (configurationElement.getName().equals(CONFIGURATION_ID) && configurationElement.getAttribute(ID_FIELD_ID).equals(messageFormatId) && (className = configurationElement.getAttribute(DEPENDENCY_PROVIDER_FIELD_ID)) != null) {
                    try {
                        return (IMessageFormatDependencyProvider)configurationElement.createExecutableExtension(DEPENDENCY_PROVIDER_FIELD_ID);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(MessageFormat.format(Modeling_Messages.EXC_CANNOT_LOAD_MSG_FORMAT_DEPENDENCY_PD_CL, className, messageFormatId), e);
                    }
                }
                ++j;
            }
            ++i;
        }
        return null;
    }
}

