/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.breakpoints;

import java.util.Collections;
import java.util.Set;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.stardust.common.CollectionUtils;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.breakpoints.MessageTransformationMappingBreakpoint;

public class MessageBreakpointManager
implements IBreakpointListener {
    private final IBreakpointManager breakpointManager;
    private final Set breakpoints = CollectionUtils.newHashSet();

    public MessageBreakpointManager() {
        this.breakpointManager = DebugPlugin.getDefault().getBreakpointManager();
        this.breakpointManager.addBreakpointListener((IBreakpointListener)this);
        this.addBreakpoints(this.breakpointManager.getBreakpoints());
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        this.addBreakpoints(new IBreakpoint[]{breakpoint});
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        this.removeBreakpoints(new IBreakpoint[]{breakpoint});
    }

    public Set getBreakPoints() {
        return Collections.unmodifiableSet(this.breakpoints);
    }

    public boolean isBreakpointAvailable(String fieldPath) {
        for (IBreakpoint rawBreakpoint : this.breakpoints) {
            MessageTransformationMappingBreakpoint breakpoint;
            if (!(rawBreakpoint instanceof MessageTransformationMappingBreakpoint) || !(breakpoint = (MessageTransformationMappingBreakpoint)rawBreakpoint).getFieldPath().equals(fieldPath)) continue;
            return true;
        }
        return false;
    }

    public boolean isEnabled() {
        return this.breakpointManager.isEnabled();
    }

    private void addBreakpoints(IBreakpoint[] breakpoints) {
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            if (MessageBreakpointManager.canHandleBreakpoint(breakpoint)) {
                this.breakpoints.add(breakpoint);
            }
            ++i;
        }
    }

    private void removeBreakpoints(IBreakpoint[] breakpoints) {
        int i = 0;
        while (i < breakpoints.length) {
            IBreakpoint breakpoint = breakpoints[i];
            if (MessageBreakpointManager.canHandleBreakpoint(breakpoint)) {
                this.breakpoints.remove(breakpoint);
            }
            ++i;
        }
    }

    public static boolean canHandleBreakpoint(IBreakpoint breakpoint) {
        return breakpoint instanceof MessageTransformationMappingBreakpoint;
    }
}

