/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.renderer;

import org.eclipse.stardust.model.xpdl.carnot.AccessPointType;
import org.eclipse.stardust.model.xpdl.carnot.IExtensibleElement;
import org.eclipse.stardust.model.xpdl.carnot.util.AttributeUtil;
import org.eclipse.stardust.modeling.core.ui.StringUtils;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.MessageTransformationController;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.renderer.IMappingRenderer;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.MappingConfiguration;
import org.eclipse.stardust.modeling.transformation.messaging.modeling.application.transformation.widgets.MultipleAccessPathBrowserContentProvider;

public class SerializableMappingRenderer
implements IMappingRenderer {
    private MessageTransformationController controller;
    private AccessPointType messageType;

    public SerializableMappingRenderer(MessageTransformationController controller, AccessPointType messageType) {
        this.controller = controller;
        this.messageType = messageType;
    }

    @Override
    public AccessPointType getType() {
        return this.messageType;
    }

    @Override
    public String renderGetterCode(boolean ignoreArrays, boolean variablesAsIndices, MappingConfiguration config) {
        String result = this.createJavaPath(ignoreArrays, variablesAsIndices, config);
        result = this.createJavaAccessCode(result, true, config);
        return result;
    }

    @Override
    public String renderSetterCode(String getterCode, boolean ignoreArrays, boolean variablesAsIndices, MappingConfiguration config) {
        String accessCode = this.createJavaPath(ignoreArrays, variablesAsIndices, config);
        accessCode = this.createJavaAccessCode(accessCode, false, config);
        return String.valueOf(accessCode) + ".set" + this.messageType.getName().substring(0, 1).toUpperCase() + this.messageType.getName().substring(1) + "(" + getterCode + ")";
    }

    @Override
    public String renderListMappingCode(IMappingRenderer sourceMapper, IMappingRenderer targetMapper, String inset, int depth, MappingConfiguration config) {
        String result = null;
        if (this.controller.isJavaList(targetMapper.getType())) {
            result = this.generateJavaListMapping(sourceMapper, targetMapper, inset, depth, config);
        }
        if (this.controller.isJavaArray(targetMapper.getType())) {
            result = this.generateJavaArrayMapping(sourceMapper, targetMapper, inset, depth, config);
        }
        return result;
    }

    @Override
    public String renderAssignmentCode(IMappingRenderer sourceMapper, IMappingRenderer targetMapper, String inset, int depth, String result, MappingConfiguration config) {
        Object[] sourceChildren = this.controller.getSourceAPB().getChildren(sourceMapper.getType());
        Object[] targetChildren = this.controller.getTargetAPB().getChildren(targetMapper.getType());
        int i = 0;
        while (i < sourceChildren.length) {
            SerializableMappingRenderer sourceChildTypeMapper = new SerializableMappingRenderer(this.controller, (AccessPointType)sourceChildren[i]);
            SerializableMappingRenderer targetChildTypeMapper = new SerializableMappingRenderer(this.controller, (AccessPointType)targetChildren[i]);
            if (this.controller.isJavaList((AccessPointType)sourceChildren[i])) {
                result = String.valueOf(result) + this.renderListMappingCode(sourceChildTypeMapper, targetChildTypeMapper, String.valueOf(inset) + "   ", depth + 1, config);
            } else if (this.controller.isJavaArray((AccessPointType)sourceChildren[i])) {
                result = String.valueOf(result) + this.generateJavaArrayMapping(sourceChildTypeMapper, targetChildTypeMapper, String.valueOf(inset) + "   ", depth + 1, config);
            } else if (this.controller.isComplexType((AccessPointType)sourceChildren[i])) {
                result = this.renderAssignmentCode(sourceChildTypeMapper, targetChildTypeMapper, inset, depth, result, config);
            } else {
                String sourceChildArray = sourceChildTypeMapper.renderGetterCode(false, true, config);
                String setterCode = targetChildTypeMapper.renderSetterCode(sourceChildArray, false, true, config);
                result = String.valueOf(result) + inset + "   " + setterCode + ";\n";
            }
            ++i;
        }
        return result;
    }

    @Override
    public String renderAdditionCode(IMappingRenderer sourceMapper, IMappingRenderer targetMapper, MappingConfiguration config) {
        String targetIndex;
        String result = "";
        String sourcePath = this.renderGetterCode(false, false, config);
        if (sourcePath.endsWith(".")) {
            sourcePath = sourcePath.replace(".", "");
        }
        if ((targetIndex = targetMapper.renderGetterCode(false, false, config)).endsWith("]")) {
            result = targetIndex;
            if (config.isAppend()) {
                int idx1 = targetIndex.lastIndexOf("[");
                int idx2 = targetIndex.lastIndexOf("]");
                int idx = idx2 - idx1 + 1;
                targetIndex = targetIndex.substring(0, targetIndex.length() - idx);
                targetIndex = String.valueOf(targetIndex) + ".length + 1";
                String xPath = this.controller.getXPathFor(targetMapper.getType());
                config.getIndexMap().put(xPath, targetIndex);
                result = targetMapper.renderGetterCode(false, false, config);
            }
            if (result.endsWith(".")) {
                result = targetIndex.replace(".", "");
            }
            result = String.valueOf(result) + " = " + sourcePath;
        } else {
            int idx1 = targetIndex.lastIndexOf("get(");
            int idx2 = targetIndex.lastIndexOf(")");
            int idx = idx2 - idx1 + 1;
            if ((targetIndex = targetIndex.substring(0, targetIndex.length() - idx)).endsWith(".")) {
                targetIndex = targetIndex.substring(0, targetIndex.length() - 1);
            }
            if (config.isAppend()) {
                result = String.valueOf(targetIndex) + ".add(" + this.renderGetterCode(false, false, config) + ");";
            } else {
                String xPath = this.controller.getXPathFor(targetMapper.getType());
                String indexString = config.getIndexMap().get(xPath);
                result = String.valueOf(targetIndex) + ".set(" + indexString + ", " + this.renderGetterCode(false, false, config) + ");";
            }
        }
        return result;
    }

    private String createJavaPath(boolean ignoreArrays, boolean useVariableAsIndices, MappingConfiguration config) {
        String javaPath = "";
        javaPath = this.controller.isRoot(this.messageType) ? this.messageType.getId() : this.controller.getXPathFor(this.messageType);
        javaPath = javaPath.replace('/', '.');
        if (!ignoreArrays) {
            javaPath = this.addJavaListInfo(useVariableAsIndices, config);
        }
        return javaPath;
    }

    private String createJavaAccessCode(String mappingCode, boolean fullPath, MappingConfiguration config) {
        String resultCode = "";
        String xPath = "";
        String[] segments = mappingCode.split("\\.");
        int pathLength = segments.length;
        if (!fullPath) {
            --pathLength;
        }
        int i = 0;
        while (i < pathLength) {
            String segment = segments[i];
            if (!segment.startsWith("(")) {
                xPath = StringUtils.isEmpty((String)xPath) ? String.valueOf(xPath) + segment : String.valueOf(xPath) + "/" + segment;
                xPath = xPath.replaceAll("\\[0\\]", "");
                xPath = xPath.replaceAll("\\(\\)", "");
            }
            if (i > 0) {
                if (segment.startsWith("(") && config != null && config.getIndexMap().get(xPath) != null) {
                    segment = "get" + segment.substring(0, 1).toUpperCase() + config.getIndexMap().get(xPath) + ")";
                } else {
                    if (segment.endsWith("]") && config != null && config.getIndexMap().get(xPath) != null) {
                        String indexString = config.getIndexMap().get(xPath);
                        segment = segment.replace("[0]", "[" + indexString + "]");
                        segment = "get" + segment.substring(0, 1).toUpperCase() + segment.substring(1);
                    } else {
                        segment = "get" + segment.substring(0, 1).toUpperCase() + segment.substring(1);
                    }
                    if (!(segment.startsWith("get(0)") || segment.startsWith("get(n") || segment.endsWith("]"))) {
                        segment = String.valueOf(segment) + "()";
                    }
                }
            }
            resultCode = String.valueOf(resultCode) + "." + segment;
            ++i;
        }
        resultCode = resultCode.replaceFirst("\\.", "");
        return resultCode;
    }

    private String addJavaListInfo(boolean useVariablesAsIndices, MappingConfiguration config) {
        MultipleAccessPathBrowserContentProvider apcp = this.controller.isSourceField(this.messageType) ? this.controller.getSourceAPB() : this.controller.getTargetAPB();
        String listIdx = ".(n)";
        if (!useVariablesAsIndices) {
            listIdx = ".(0)";
        }
        String arrIdx = "()[n]";
        if (!useVariablesAsIndices) {
            arrIdx = "()[0]";
        }
        String accessPath = this.createJavaPath(true, true, config);
        accessPath = this.createJavaAccessCode(accessPath, true, config);
        String xPath = this.controller.getXPathFor(this.messageType);
        String[] segments = xPath.split("/");
        AccessPointType parent = null;
        int i = 0;
        while (i < segments.length) {
            if (i == 0) {
                parent = this.controller.getMessageTypeByName(segments[0]);
            } else {
                if (this.controller.isJavaList(parent = apcp.getChild(parent, segments[i]))) {
                    segments[i] = String.valueOf(segments[i]) + listIdx;
                }
                if (this.controller.isJavaArray(parent)) {
                    segments[i] = String.valueOf(segments[i]) + arrIdx;
                }
            }
            ++i;
        }
        int n = 0;
        int adepth = 0;
        int arraySelectionDepth = 0;
        arraySelectionDepth = this.controller.isSourceField(this.messageType) ? this.controller.getArraySelectionDepthSource() : this.controller.getArraySelectionDepthTarget();
        if (useVariablesAsIndices) {
            int i2 = 0;
            while (i2 < segments.length) {
                if (segments[i2].indexOf("(n)") != -1 || segments[i2].indexOf("[n]") != -1) {
                    if (++adepth >= arraySelectionDepth) {
                        segments[i2] = segments[i2].replace("(n)", "(n" + n + ")");
                        segments[i2] = segments[i2].replace("[n]", "[n" + n + "]");
                        ++n;
                    } else {
                        segments[i2] = segments[i2].replace("(n)", "(0)");
                        segments[i2] = segments[i2].replace("[n]", "[0]");
                    }
                }
                ++i2;
            }
        }
        String javaPath = "";
        int i3 = 0;
        while (i3 < segments.length) {
            javaPath = String.valueOf(javaPath) + segments[i3] + ".";
            ++i3;
        }
        javaPath = javaPath.substring(0, javaPath.length() - 1);
        return javaPath;
    }

    private String generateJavaListMapping(IMappingRenderer sourceMapper, IMappingRenderer targetMapper, String inset, int depth, MappingConfiguration config) {
        String result = "";
        String sourceArray = sourceMapper.renderGetterCode(false, true, config);
        String targetArray = targetMapper.renderGetterCode(false, true, config);
        int index = 0;
        if (depth > 9) {
            index = 1;
        }
        String sourcePath = sourceArray.substring(0, sourceArray.length() - 8 - index);
        String targetPath = targetArray.substring(0, targetArray.length() - 8 - index);
        String varDeclaration = "n" + depth;
        String o = this.controller.getUsedVar().get("n" + depth);
        if (o == null) {
            varDeclaration = "var n" + depth;
            this.controller.getUsedVar().put("n" + depth, "defined");
        }
        result = String.valueOf(result) + inset + targetPath + ".clear();\n";
        result = String.valueOf(result) + inset + "for (" + varDeclaration + " = 0; n" + depth + " < " + sourcePath + ".size(); ++n" + depth + "){\n";
        if (this.controller.isComplexType(sourceMapper.getType())) {
            result = String.valueOf(result) + inset + "   " + targetPath + ".add(" + sourcePath + ".get(0).getClass().newInstance());\n";
            result = this.renderAssignmentCode(sourceMapper, targetMapper, inset, depth, result, config);
        } else {
            result = String.valueOf(result) + inset + "   " + targetPath + ".add(" + sourceArray + ");\n";
        }
        result = String.valueOf(result) + inset + "}\n";
        result = result.replace("= null", "= " + AttributeUtil.getAttributeValue((IExtensibleElement)sourceMapper.getType(), (String)"RootElement"));
        result = result.replace("null", AttributeUtil.getAttributeValue((IExtensibleElement)targetMapper.getType(), (String)"RootElement"));
        return result;
    }

    private String generateJavaArrayMapping(IMappingRenderer sourceMapper, IMappingRenderer targetMapper, String inset, int depth, MappingConfiguration config) {
        String result = "";
        String sourceArray = sourceMapper.renderGetterCode(false, true, config);
        String targetArray = targetMapper.renderGetterCode(false, true, config);
        int index = 0;
        if (depth > 9) {
            index = 1;
        }
        String sourcePath = sourceArray.substring(0, sourceArray.length() - 4 - index);
        String varDeclaration = "n" + depth;
        String o = this.controller.getUsedVar().get("n" + depth);
        if (o == null) {
            varDeclaration = "var n" + depth;
            this.controller.getUsedVar().put("n" + depth, "defined");
        }
        result = String.valueOf(result) + inset + "for (" + varDeclaration + " = 0; n" + depth + " < " + sourcePath + ".length; ++n" + depth + "){\n";
        result = this.controller.isComplexType(sourceMapper.getType()) ? this.renderAssignmentCode(sourceMapper, targetMapper, inset, depth, result, config) : String.valueOf(result) + inset + "   " + targetArray + " = " + sourceArray + ";\n";
        result = String.valueOf(result) + inset + "}\n";
        result = result.replace("= null", "= " + AttributeUtil.getAttributeValue((IExtensibleElement)sourceMapper.getType(), (String)"RootElement"));
        result = result.replace("null", AttributeUtil.getAttributeValue((IExtensibleElement)targetMapper.getType(), (String)"RootElement"));
        return result;
    }

    @Override
    public String getTypeString() {
        String className = AttributeUtil.getAttributeValue((IExtensibleElement)this.messageType, (String)"carnot:engine:className");
        if (className.indexOf("<") > -1) {
            int idx1 = className.indexOf("<");
            int idx2 = className.indexOf(">");
            className = className.substring(idx1 + 1, idx1 + idx2 - idx1);
        }
        if (className.endsWith("String")) {
            return "String";
        }
        if (className.endsWith("java.lang.Integer")) {
            return "Number";
        }
        if (className.endsWith("Double")) {
            return "Number";
        }
        if (className.endsWith("Float")) {
            return "Number";
        }
        if (className.endsWith("Boolean")) {
            return "Number";
        }
        if (className.endsWith("Date")) {
            return "Date";
        }
        if (className.endsWith("Calendar")) {
            return "Date";
        }
        return className;
    }
}

