/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.services.remote;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.tcf.core.Command;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IService;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.JSON;
import org.eclipse.tcf.services.IProcesses;

public class ProcessesProxy
implements IProcesses {
    protected final IChannel channel;
    private final Map<IProcesses.ProcessesListener, IChannel.IEventListener> listeners = new HashMap<IProcesses.ProcessesListener, IChannel.IEventListener>();

    public ProcessesProxy(IChannel channel) {
        this.channel = channel;
    }

    @Override
    public String getName() {
        return "Processes";
    }

    @Override
    public void addListener(final IProcesses.ProcessesListener listener) {
        IChannel.IEventListener l = new IChannel.IEventListener(){

            @Override
            public void event(String name, byte[] data) {
                try {
                    Object[] args = JSON.parseSequence(data);
                    if (name.equals("exited")) {
                        if (!$assertionsDisabled && args.length != 2) {
                            throw new AssertionError();
                        }
                    } else {
                        throw new IOException("Processes service: unknown event: " + name);
                    }
                    listener.exited((String)args[0], ((Number)args[1]).intValue());
                }
                catch (Throwable x) {
                    ProcessesProxy.this.channel.terminate(x);
                }
            }
        };
        this.channel.addEventListener(this, l);
        this.listeners.put(listener, l);
    }

    @Override
    public void removeListener(IProcesses.ProcessesListener listener) {
        IChannel.IEventListener l = this.listeners.remove(listener);
        if (l != null) {
            this.channel.removeEventListener(this, l);
        }
    }

    @Override
    public IToken getChildren(String parent_context_id, boolean attached_only, final IProcesses.DoneGetChildren done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getChildren", (Object[])new Object[]{parent_context_id, Boolean.valueOf((boolean)attached_only)}){

            @Override
            public void done(Exception error, Object[] args) {
                String[] ids = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    ids = ProcessesProxy.toStringArray(args[1]);
                }
                done.doneGetChildren(this.token, error, ids);
            }
        }.token;
    }

    @Override
    public IToken getContext(String id, final IProcesses.DoneGetContext done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getContext", (Object[])new Object[]{id}){

            @Override
            public void done(Exception error, Object[] args) {
                ProcessContextInfo ctx = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    if (args[1] != null) {
                        ctx = new ProcessContextInfo((Map)args[1]);
                    }
                }
                done.doneGetContext(this.token, error, ctx);
            }
        }.token;
    }

    @Override
    public IToken getEnvironment(final IProcesses.DoneGetEnvironment done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getEnvironment", null){

            @Override
            public void done(Exception error, Object[] args) {
                Map env = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    env = ProcessesProxy.toEnvMap(args[1]);
                }
                done.doneGetEnvironment(this.token, error, env);
            }
        }.token;
    }

    @Override
    public IToken start(String directory, String file, String[] command_line, Map<String, String> environment, boolean attach, final IProcesses.DoneStart done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"start", (Object[])new Object[]{directory, file, command_line, ProcessesProxy.toEnvStringArray(environment), Boolean.valueOf((boolean)attach)}){

            @Override
            public void done(Exception error, Object[] args) {
                ProcessContextInfo ctx = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    if (args[1] != null) {
                        ctx = new ProcessContextInfo((Map)args[1]);
                    }
                }
                done.doneStart(this.token, error, ctx);
            }
        }.token;
    }

    @Override
    public IToken getSignalList(String context_id, final IProcesses.DoneGetSignalList done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getSignalList", (Object[])new Object[]{context_id}){

            @Override
            public void done(Exception error, Object[] args) {
                Collection list = null;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 2) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    list = ProcessesProxy.toSignalList(args[1]);
                }
                done.doneGetSignalList(this.token, error, list);
            }
        }.token;
    }

    @Override
    public IToken getSignalMask(String context_id, final IProcesses.DoneGetSignalMask done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"getSignalMask", (Object[])new Object[]{context_id}){

            @Override
            public void done(Exception error, Object[] args) {
                int dont_stop = 0;
                int dont_pass = 0;
                int pending = 0;
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 4) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                    if (args[1] != null) {
                        dont_stop = ((Number)args[1]).intValue();
                    }
                    if (args[2] != null) {
                        dont_pass = ((Number)args[2]).intValue();
                    }
                    if (args[3] != null) {
                        pending = ((Number)args[3]).intValue();
                    }
                }
                done.doneGetSignalMask(this.token, error, dont_stop, dont_pass, pending);
            }
        }.token;
    }

    @Override
    public IToken setSignalMask(String context_id, int dont_stop, int dont_pass, final IProcesses.DoneCommand done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"setSignalMask", (Object[])new Object[]{context_id, Integer.valueOf((int)dont_stop), Integer.valueOf((int)dont_pass)}){

            @Override
            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneCommand(this.token, error);
            }
        }.token;
    }

    @Override
    public IToken signal(String context_id, long signal, final IProcesses.DoneCommand done) {
        return new Command((IChannel)this.channel, (IService)this, (String)"signal", (Object[])new Object[]{context_id, Long.valueOf((long)signal)}){

            @Override
            public void done(Exception error, Object[] args) {
                if (error == null) {
                    if (!$assertionsDisabled && args.length != 1) {
                        throw new AssertionError();
                    }
                    error = this.toError(args[0]);
                }
                done.doneCommand(this.token, error);
            }
        }.token;
    }

    private static String[] toStringArray(Object o) {
        if (o == null) {
            return null;
        }
        Collection c = (Collection)o;
        return c.toArray(new String[c.size()]);
    }

    protected static String[] toEnvStringArray(Map<String, String> m) {
        if (m == null) {
            return new String[0];
        }
        int n = 0;
        String[] arr = new String[m.size()];
        for (Map.Entry<String, String> e : m.entrySet()) {
            arr[n++] = String.valueOf(e.getKey()) + "=" + e.getValue();
        }
        return arr;
    }

    private static Map<String, String> toEnvMap(Object o) {
        HashMap<String, String> m = new HashMap<String, String>();
        if (o == null) {
            return m;
        }
        Collection c = (Collection)o;
        for (String s : c) {
            int i = s.indexOf(61);
            if (i >= 0) {
                m.put(s.substring(0, i), s.substring(i + 1));
                continue;
            }
            m.put(s, "");
        }
        return m;
    }

    private static Collection<Map<String, Object>> toSignalList(Object o) {
        if (o == null) {
            return null;
        }
        return (Collection)o;
    }

    protected class ProcessContextInfo
    implements IProcesses.ProcessContext {
        private final Map<String, Object> props;

        ProcessContextInfo(Map<String, Object> props) {
            this.props = props;
        }

        @Override
        public String getID() {
            return (String)this.props.get("ID");
        }

        @Override
        public String getParentID() {
            return (String)this.props.get("ParentID");
        }

        @Override
        public boolean canTerminate() {
            Boolean b = (Boolean)this.props.get("CanTerminate");
            return b != null && b != false;
        }

        @Override
        public String getName() {
            return (String)this.props.get("Name");
        }

        @Override
        public boolean isAttached() {
            Boolean b = (Boolean)this.props.get("Attached");
            return b != null && b != false;
        }

        @Override
        public IToken attach(final IProcesses.DoneCommand done) {
            return new Command((IChannel)ProcessesProxy.this.channel, (IService)ProcessesProxy.this, (String)"attach", (Object[])new Object[]{this.getID()}){

                @Override
                public void done(Exception error, Object[] args) {
                    if (error == null) {
                        if (!$assertionsDisabled && args.length != 1) {
                            throw new AssertionError();
                        }
                        error = this.toError(args[0]);
                    }
                    done.doneCommand(this.token, error);
                }
            }.token;
        }

        @Override
        public IToken detach(final IProcesses.DoneCommand done) {
            return new Command((IChannel)ProcessesProxy.this.channel, (IService)ProcessesProxy.this, (String)"detach", (Object[])new Object[]{this.getID()}){

                @Override
                public void done(Exception error, Object[] args) {
                    if (error == null) {
                        if (!$assertionsDisabled && args.length != 1) {
                            throw new AssertionError();
                        }
                        error = this.toError(args[0]);
                    }
                    done.doneCommand(this.token, error);
                }
            }.token;
        }

        @Override
        public IToken terminate(final IProcesses.DoneCommand done) {
            return new Command((IChannel)ProcessesProxy.this.channel, (IService)ProcessesProxy.this, (String)"terminate", (Object[])new Object[]{this.getID()}){

                @Override
                public void done(Exception error, Object[] args) {
                    if (error == null) {
                        if (!$assertionsDisabled && args.length != 1) {
                            throw new AssertionError();
                        }
                        error = this.toError(args[0]);
                    }
                    done.doneCommand(this.token, error);
                }
            }.token;
        }

        @Override
        public Map<String, Object> getProperties() {
            return this.props;
        }

        public String toString() {
            return "[Processes Context " + this.props.toString() + "]";
        }
    }
}

