/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.core.steps;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.tcf.te.launch.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.runtime.interfaces.properties.IPropertiesContainer;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IFullQualifiedId;
import org.eclipse.tcf.te.runtime.stepper.interfaces.IStepContext;
import org.eclipse.tcf.te.runtime.stepper.steps.AbstractStep;

public abstract class AbstractLaunchStep
extends AbstractStep {
    public void validateExecute(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId, IProgressMonitor monitor) throws CoreException {
        if (this.getLaunch(context) == null) {
            throw new CoreException((IStatus)new Status(4, CoreBundleActivator.getUniqueIdentifier(), "missing launch context"));
        }
    }

    protected ILaunch getLaunch(IStepContext context) {
        Assert.isNotNull((Object)context);
        return (ILaunch)context.getAdapter(ILaunch.class);
    }

    protected ILaunchConfiguration getLaunchConfiguration(IStepContext context) {
        Assert.isNotNull((Object)context);
        return (ILaunchConfiguration)context.getAdapter(ILaunchConfiguration.class);
    }

    protected ILaunchConfigurationType getLaunchConfigurationType(IStepContext context) {
        Assert.isNotNull((Object)context);
        return (ILaunchConfigurationType)context.getAdapter(ILaunchConfigurationType.class);
    }

    protected String getLaunchMode(IStepContext context) {
        ILaunch launch = this.getLaunch(context);
        return launch != null ? launch.getLaunchMode() : null;
    }

    protected IModelNode getActiveModelNodeContext(IStepContext context, IPropertiesContainer data, IFullQualifiedId fullQualifiedId) {
        Object activeContext = this.getActiveContext(context, data, fullQualifiedId);
        IModelNode modelNode = null;
        if (activeContext instanceof IModelNode) {
            return (IModelNode)activeContext;
        }
        if (activeContext instanceof IAdaptable) {
            modelNode = (IModelNode)((IAdaptable)activeContext).getAdapter(IModelNode.class);
        }
        if (modelNode == null) {
            modelNode = (IModelNode)Platform.getAdapterManager().getAdapter(activeContext, IModelNode.class);
        }
        return modelNode;
    }
}

