/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.core.internal.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.cdt.debug.core.sourcelookup.MappingSourceContainer;
import org.eclipse.cdt.debug.internal.core.sourcelookup.MapEntrySourceContainer;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IPersistableSourceLocator;
import org.eclipse.debug.core.sourcelookup.AbstractSourceLookupDirector;
import org.eclipse.debug.core.sourcelookup.ISourceContainer;
import org.eclipse.debug.core.sourcelookup.ISourceLookupDirector;
import org.eclipse.tcf.internal.debug.Activator;
import org.eclipse.tcf.internal.debug.launch.TCFLaunchDelegate;
import org.eclipse.tcf.protocol.IChannel;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.IToken;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IPathMap;
import org.eclipse.tcf.te.runtime.callback.AsyncCallbackCollector;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.services.AbstractService;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.utils.StatusHelper;
import org.eclipse.tcf.te.tcf.core.Tcf;
import org.eclipse.tcf.te.tcf.core.async.CallbackInvocationDelegate;
import org.eclipse.tcf.te.tcf.core.interfaces.IPathMapGeneratorService;
import org.eclipse.tcf.te.tcf.core.interfaces.IPathMapService;
import org.eclipse.tcf.te.tcf.launch.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNodeProvider;
import org.osgi.framework.Bundle;

public class PathMapService
extends AbstractService
implements IPathMapService {
    private final Lock lock = new ReentrantLock();

    public void generateSourcePathMappings(Object context) {
        IPathMap.PathMapRule[] generatedRules;
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0, (String)"Illegal Thread Access");
        Assert.isNotNull((Object)context);
        ILaunchConfiguration config = (ILaunchConfiguration)Platform.getAdapterManager().getAdapter(context, ILaunchConfiguration.class);
        if (config == null) {
            config = (ILaunchConfiguration)Platform.getAdapterManager().loadAdapter(context, "org.eclipse.debug.core.ILaunchConfiguration");
        }
        IPathMapGeneratorService generator = (IPathMapGeneratorService)ServiceManager.getInstance().getService(context, IPathMapGeneratorService.class);
        if (config != null && generator != null && (generatedRules = generator.getSourcePathMap(context)) != null) {
            MapEntrySourceContainer[] mappings = new MapEntrySourceContainer[generatedRules.length];
            int i = 0;
            IPathMap.PathMapRule[] pathMapRuleArray = generatedRules;
            int n = generatedRules.length;
            int n2 = 0;
            while (n2 < n) {
                IPathMap.PathMapRule pathMapRule = pathMapRuleArray[n2];
                mappings[i++] = new MapEntrySourceContainer((IPath)new Path(pathMapRule.getSource()), (IPath)new Path(pathMapRule.getDestination()));
                ++n2;
            }
            try {
                config = this.addSourceMappingToLaunchConfig(config, mappings);
            }
            catch (Exception exception) {}
        }
    }

    private ILaunchConfiguration addSourceMappingToLaunchConfig(ILaunchConfiguration config, MapEntrySourceContainer[] mappings) throws CoreException {
        IPersistableSourceLocator locator;
        String memento = null;
        String type = null;
        ILaunchConfigurationWorkingCopy wc = config.getWorkingCopy();
        memento = wc.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, null);
        type = wc.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, null);
        if (type == null) {
            type = wc.getType().getSourceLocatorId();
        }
        if ((locator = DebugPlugin.getDefault().getLaunchManager().newSourceLocator(type)) instanceof AbstractSourceLookupDirector) {
            AbstractSourceLookupDirector director = (AbstractSourceLookupDirector)locator;
            if (memento == null) {
                director.initializeDefaults((ILaunchConfiguration)wc);
            } else {
                director.initializeFromMemento(memento, (ILaunchConfiguration)wc);
            }
            ArrayList<ISourceContainer> containerList = new ArrayList<ISourceContainer>(Arrays.asList(director.getSourceContainers()));
            MappingSourceContainer generatedMappings = null;
            for (ISourceContainer container : containerList) {
                if (!(container instanceof MappingSourceContainer) || !container.getName().equals("Generated Mappings")) continue;
                generatedMappings = (MappingSourceContainer)container;
                break;
            }
            if (generatedMappings != null) {
                containerList.remove(generatedMappings);
            }
            generatedMappings = new MappingSourceContainer("Generated Mappings");
            generatedMappings.init((ISourceLookupDirector)director);
            containerList.add((ISourceContainer)generatedMappings);
            MapEntrySourceContainer[] mapEntrySourceContainerArray = mappings;
            int n = mappings.length;
            int n2 = 0;
            while (n2 < n) {
                MapEntrySourceContainer mapping = mapEntrySourceContainerArray[n2];
                generatedMappings.addMapEntry(mapping);
                ++n2;
            }
            director.setSourceContainers(containerList.toArray(new ISourceContainer[containerList.size()]));
            wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, director.getMemento());
            wc.setAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_ID, director.getId());
            return wc.doSave();
        }
        return config;
    }

    public IPathMap.PathMapRule[] getPathMap(Object context) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0, (String)"Illegal Thread Access");
        Assert.isNotNull((Object)context);
        IPathMap.PathMapRule[] rules = null;
        try {
            IPathMap.PathMapRule[] generatedRules;
            IPathMapGeneratorService generator;
            this.lock.lock();
            this.generateSourcePathMappings(context);
            ArrayList<IPathMap.PathMapRule> rulesList = new ArrayList<IPathMap.PathMapRule>();
            ILaunchConfiguration config = (ILaunchConfiguration)Platform.getAdapterManager().getAdapter(context, ILaunchConfiguration.class);
            if (config == null) {
                config = (ILaunchConfiguration)Platform.getAdapterManager().loadAdapter(context, "org.eclipse.debug.core.ILaunchConfiguration");
            }
            if (config != null) {
                try {
                    String path_map_cfg = config.getAttribute("org.eclipse.tcf.debug.PathMap", "");
                    rulesList.addAll(TCFLaunchDelegate.parsePathMapAttribute((String)path_map_cfg));
                    path_map_cfg = config.getAttribute(ILaunchConfiguration.ATTR_SOURCE_LOCATOR_MEMENTO, "");
                    rulesList.addAll(TCFLaunchDelegate.parseSourceLocatorMemento((String)path_map_cfg));
                }
                catch (CoreException coreException) {}
            }
            if ((generator = (IPathMapGeneratorService)ServiceManager.getInstance().getService(context, IPathMapGeneratorService.class)) != null && (generatedRules = generator.getPathMap(context)) != null && generatedRules.length > 0) {
                rulesList.addAll(Arrays.asList(generatedRules));
            }
            if (!rulesList.isEmpty()) {
                int cnt = 0;
                String id = this.getClientID();
                for (IPathMap.PathMapRule r : rulesList) {
                    if (r.getProperties().get("ID") != null) continue;
                    r.getProperties().put("ID", String.valueOf(id) + "/" + cnt++);
                }
                rules = rulesList.toArray(new IPathMap.PathMapRule[rulesList.size()]);
            }
        }
        finally {
            this.lock.unlock();
        }
        return rules;
    }

    public IPathMap.PathMapRule addPathMap(Object context, String source, String destination) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0, (String)"Illegal Thread Access");
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)source);
        Assert.isNotNull((Object)destination);
        IPathMap.PathMapRule rule = null;
        try {
            this.lock.lock();
            ArrayList<IPathMap.PathMapRule> rulesList = new ArrayList<IPathMap.PathMapRule>();
            ILaunchConfigurationWorkingCopy config = (ILaunchConfigurationWorkingCopy)Platform.getAdapterManager().getAdapter(context, ILaunchConfigurationWorkingCopy.class);
            if (config == null) {
                config = (ILaunchConfigurationWorkingCopy)Platform.getAdapterManager().loadAdapter(context, "org.eclipse.debug.core.ILaunchConfigurationWorkingCopy");
            }
            if (config != null) {
                this.populatePathMapRulesList((ILaunchConfiguration)config, rulesList);
                for (IPathMap.PathMapRule candidate : rulesList) {
                    if (!source.equals(candidate.getSource()) || !destination.equals(candidate.getDestination())) continue;
                    rule = candidate;
                    break;
                }
                if (rule == null) {
                    LinkedHashMap<String, String> props = new LinkedHashMap<String, String>();
                    props.put("Source", source);
                    props.put("Destination", destination);
                    rule = new TCFLaunchDelegate.PathMapRule(props);
                    rulesList.add(rule);
                    this.updateLaunchConfiguration(config, rulesList);
                    this.applyPathMap(context, false, false, (ICallback)new Callback(){

                        protected void internalDone(Object caller, IStatus status) {
                            if (status != null && Platform.inDebugMode()) {
                                Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log(status);
                            }
                        }
                    });
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return rule;
    }

    public void removePathMap(Object context, IPathMap.PathMapRule rule) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0, (String)"Illegal Thread Access");
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)rule);
        try {
            this.lock.lock();
            ArrayList<IPathMap.PathMapRule> rulesList = new ArrayList<IPathMap.PathMapRule>();
            ILaunchConfigurationWorkingCopy config = (ILaunchConfigurationWorkingCopy)Platform.getAdapterManager().getAdapter(context, ILaunchConfigurationWorkingCopy.class);
            if (config == null) {
                config = (ILaunchConfigurationWorkingCopy)Platform.getAdapterManager().loadAdapter(context, "org.eclipse.debug.core.ILaunchConfigurationWorkingCopy");
            }
            if (config != null) {
                this.populatePathMapRulesList((ILaunchConfiguration)config, rulesList);
                if (rulesList.remove(rule)) {
                    this.updateLaunchConfiguration(config, rulesList);
                    this.applyPathMap(context, true, true, (ICallback)new Callback(){

                        protected void internalDone(Object caller, IStatus status) {
                            if (status != null && Platform.inDebugMode()) {
                                Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log(status);
                            }
                        }
                    });
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private void populatePathMapRulesList(ILaunchConfiguration config, List<IPathMap.PathMapRule> rulesList) {
        Assert.isNotNull((Object)config);
        Assert.isNotNull(rulesList);
        try {
            String path_map_cfg = config.getAttribute("org.eclipse.tcf.debug.PathMap", "");
            String path_map_cfgV1 = config.getAttribute("org.eclipse.tcf.debug.PathMapV1", "");
            rulesList.addAll(TCFLaunchDelegate.parsePathMapAttribute((String)path_map_cfgV1));
            int i = -1;
            for (IPathMap.PathMapRule candidate : TCFLaunchDelegate.parsePathMapAttribute((String)path_map_cfg)) {
                if (rulesList.contains(candidate)) {
                    i = rulesList.indexOf(candidate);
                    continue;
                }
                rulesList.add(++i, candidate);
            }
        }
        catch (CoreException coreException) {}
    }

    private void updateLaunchConfiguration(ILaunchConfigurationWorkingCopy config, List<IPathMap.PathMapRule> rulesList) {
        block10: {
            Assert.isNotNull((Object)config);
            Assert.isNotNull(rulesList);
            for (IPathMap.PathMapRule candidate : rulesList) {
                candidate.getProperties().remove("ID");
            }
            StringBuilder bf = new StringBuilder();
            StringBuilder bf1 = new StringBuilder();
            for (IPathMap.PathMapRule candidate : rulesList) {
                if (!(candidate instanceof TCFLaunchDelegate.PathMapRule)) continue;
                boolean enabled = true;
                if (candidate.getProperties().containsKey("Enabled")) {
                    enabled = Boolean.parseBoolean(candidate.getProperties().get("Enabled").toString());
                }
                if (enabled) {
                    candidate.getProperties().remove("Enabled");
                    bf.append(candidate.toString());
                }
                bf1.append(candidate.toString());
            }
            if (bf.length() == 0) {
                config.removeAttribute("org.eclipse.tcf.debug.PathMap");
            } else {
                config.setAttribute("org.eclipse.tcf.debug.PathMap", bf.toString());
            }
            if (bf1.length() == 0) {
                config.removeAttribute("org.eclipse.tcf.debug.PathMapV1");
            } else {
                config.setAttribute("org.eclipse.tcf.debug.PathMapV1", bf1.toString());
            }
            try {
                config.doSave();
            }
            catch (CoreException e) {
                if (!Platform.inDebugMode()) break block10;
                Platform.getLog((Bundle)CoreBundleActivator.getContext().getBundle()).log(e.getStatus());
            }
        }
    }

    public void applyPathMap(Object context, boolean force, boolean forceEmpty, ICallback callback) {
        IChannel channel;
        IPeer peer;
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0, (String)"Illegal Thread Access");
        Assert.isNotNull((Object)context);
        Assert.isNotNull((Object)callback);
        IPeer iPeer = peer = context instanceof IPeer ? (IPeer)context : null;
        if (peer == null && context instanceof IPeerNode) {
            peer = ((IPeerNode)context).getPeer();
        }
        if (peer == null && context instanceof IPeerNodeProvider && ((IPeerNodeProvider)context).getPeerNode() != null) {
            peer = ((IPeerNodeProvider)context).getPeerNode().getPeer();
        }
        IChannel iChannel = channel = context instanceof IChannel ? (IChannel)context : null;
        if (peer == null && channel != null) {
            final AtomicReference remotePeer = new AtomicReference();
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    remotePeer.set(channel.getRemotePeer());
                }
            });
            peer = (IPeer)remotePeer.get();
        }
        AsyncCallbackCollector collector = new AsyncCallbackCollector(callback, (AsyncCallbackCollector.ICallbackInvocationDelegate)new CallbackInvocationDelegate());
        AsyncCallbackCollector.SimpleCollectorCallback innerCallback = new AsyncCallbackCollector.SimpleCollectorCallback(collector);
        collector.initDone();
        if (peer != null) {
            IChannel c;
            IChannel iChannel2 = c = channel != null ? channel : Tcf.getChannelManager().getChannel(peer);
            if (c != null && 1 == c.getState()) {
                IPathMap.PathMapRule[] configuredMap = this.getPathMap(context instanceof IChannel ? peer : context);
                if (configuredMap != null && configuredMap.length > 0) {
                    Runnable runnable = new Runnable((ICallback)innerCallback, configuredMap, force, forceEmpty){
                        private final /* synthetic */ ICallback val$innerCallback;
                        private final /* synthetic */ IPathMap.PathMapRule[] val$configuredMap;
                        private final /* synthetic */ boolean val$force;
                        private final /* synthetic */ boolean val$forceEmpty;
                        {
                            this.val$innerCallback = iCallback;
                            this.val$configuredMap = pathMapRuleArray;
                            this.val$force = bl;
                            this.val$forceEmpty = bl2;
                        }

                        @Override
                        public void run() {
                            final IPathMap svc = (IPathMap)c.getRemoteService(IPathMap.class);
                            if (svc != null) {
                                svc.get(new IPathMap.DoneGet(){

                                    public void doneGet(IToken token, Exception error, IPathMap.PathMapRule[] map) {
                                        List<IPathMap.PathMapRule> rules = PathMapService.mergePathMaps(PathMapService.this.getClientID(), map, val$configuredMap);
                                        if (val$force || PathMapService.isDifferent(rules, map)) {
                                            PathMapService.set(rules, svc, val$forceEmpty, new IPathMap.DoneSet(){

                                                public void doneSet(IToken token, Exception error) {
                                                    val$innerCallback.done((Object)PathMapService.this, StatusHelper.getStatus((Throwable)error));
                                                }
                                            });
                                        } else {
                                            val$innerCallback.done((Object)PathMapService.this, Status.OK_STATUS);
                                        }
                                    }
                                });
                            } else {
                                this.val$innerCallback.done((Object)PathMapService.this, Status.OK_STATUS);
                            }
                        }
                    };
                    Protocol.invokeLater((Runnable)runnable);
                } else {
                    innerCallback.done((Object)this, Status.OK_STATUS);
                }
            } else {
                innerCallback.done((Object)this, Status.OK_STATUS);
            }
        } else {
            innerCallback.done((Object)this, Status.OK_STATUS);
        }
    }

    public static List<IPathMap.PathMapRule> mergePathMaps(String clientID, IPathMap.PathMapRule[] agentSidePathMap, IPathMap.PathMapRule[] clientSidePathMap) {
        IPathMap.PathMapRule rule;
        int n;
        int n2;
        IPathMap.PathMapRule[] pathMapRuleArray;
        Assert.isNotNull((Object)clientID);
        Assert.isNotNull((Object)clientSidePathMap);
        ArrayList<IPathMap.PathMapRule> rules = new ArrayList<IPathMap.PathMapRule>();
        ArrayList<IPathMap.PathMapRule> agentSideRules = new ArrayList<IPathMap.PathMapRule>();
        if (agentSidePathMap != null && agentSidePathMap.length > 0) {
            pathMapRuleArray = agentSidePathMap;
            n2 = agentSidePathMap.length;
            n = 0;
            while (n < n2) {
                rule = pathMapRuleArray[n];
                if (rule.getID() == null || !rule.getID().startsWith(clientID) && !"agent".equalsIgnoreCase(rule.getID())) {
                    rules.add(rule);
                } else if ("agent".equalsIgnoreCase(rule.getID())) {
                    agentSideRules.add(rule);
                }
                ++n;
            }
        }
        pathMapRuleArray = clientSidePathMap;
        n2 = clientSidePathMap.length;
        n = 0;
        while (n < n2) {
            rule = pathMapRuleArray[n];
            if (!"target".equals(rule.getProtocol())) {
                boolean addRule = true;
                HashMap m1 = new HashMap(rule.getProperties());
                m1.remove("ID");
                for (IPathMap.PathMapRule agentSideRule : agentSideRules) {
                    HashMap m2 = new HashMap(agentSideRule.getProperties());
                    m2.remove("ID");
                    if (!m1.equals(m2)) continue;
                    rules.add(agentSideRule);
                    addRule = false;
                    break;
                }
                if (addRule) {
                    rules.add(rule);
                }
            }
            ++n;
        }
        return rules;
    }

    public static boolean isDifferent(List<IPathMap.PathMapRule> mergedPathMap, IPathMap.PathMapRule[] agentSidePathMap) {
        boolean changed;
        Assert.isNotNull(mergedPathMap);
        boolean bl = agentSidePathMap != null ? agentSidePathMap.length != mergedPathMap.size() : (changed = !mergedPathMap.isEmpty());
        if (!changed && !mergedPathMap.isEmpty()) {
            ArrayList<IPathMap.PathMapRule> copy = new ArrayList<IPathMap.PathMapRule>(mergedPathMap);
            IPathMap.PathMapRule[] pathMapRuleArray = agentSidePathMap;
            int n = agentSidePathMap.length;
            int n2 = 0;
            while (n2 < n) {
                IPathMap.PathMapRule rule = pathMapRuleArray[n2];
                Iterator iter = copy.iterator();
                while (iter.hasNext()) {
                    IPathMap.PathMapRule r = (IPathMap.PathMapRule)iter.next();
                    if (!r.equals(rule)) continue;
                    iter.remove();
                    break;
                }
                ++n2;
            }
            changed = !copy.isEmpty();
        }
        return changed;
    }

    public static void set(List<IPathMap.PathMapRule> map, IPathMap svc, boolean forceEmpty, IPathMap.DoneSet done) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull(map);
        Assert.isNotNull((Object)svc);
        Assert.isNotNull((Object)done);
        Iterator<IPathMap.PathMapRule> iter = map.iterator();
        while (iter.hasNext()) {
            IPathMap.PathMapRule rule = iter.next();
            if (!"agent".equalsIgnoreCase(rule.getID())) continue;
            iter.remove();
        }
        if (!map.isEmpty() || forceEmpty) {
            svc.set(map.toArray(new IPathMap.PathMapRule[map.size()]), done);
        } else {
            done.doneSet(null, null);
        }
    }

    public String getClientID() {
        return Activator.getClientID();
    }
}

