/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.model.runtime;

import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.core.interfaces.IConnectable;
import org.eclipse.tcf.te.core.interfaces.IFilterable;
import org.eclipse.tcf.te.runtime.callback.Callback;
import org.eclipse.tcf.te.runtime.interfaces.callback.ICallback;
import org.eclipse.tcf.te.runtime.model.ContainerModelNode;
import org.eclipse.tcf.te.runtime.model.contexts.AsyncRefreshableCtxAdapter;
import org.eclipse.tcf.te.runtime.model.factory.Factory;
import org.eclipse.tcf.te.runtime.model.interfaces.contexts.IAsyncRefreshableCtx;
import org.eclipse.tcf.te.runtime.model.interfaces.factory.IFactory;
import org.eclipse.tcf.te.runtime.preferences.ScopedEclipsePreferences;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelChannelService;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelLookupService;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelRefreshService;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelService;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelUpdateService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.processes.core.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModelLookupService;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModelRefreshService;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModelUpdateService;
import org.eclipse.tcf.te.tcf.processes.core.model.runtime.services.RuntimeModelChannelService;
import org.eclipse.tcf.te.tcf.processes.core.model.runtime.services.RuntimeModelLookupService;
import org.eclipse.tcf.te.tcf.processes.core.model.runtime.services.RuntimeModelRefreshService;
import org.eclipse.tcf.te.tcf.processes.core.model.runtime.services.RuntimeModelUpdateService;

public final class RuntimeModel
extends ContainerModelNode
implements IRuntimeModel,
IFilterable {
    private boolean disposed = false;
    private IFactory factory = null;
    private final IPeerNode peerNode;
    private final IRuntimeModelRefreshService refreshService = new RuntimeModelRefreshService(this);
    private final IRuntimeModelLookupService lookupService = new RuntimeModelLookupService(this);
    private final IRuntimeModelUpdateService updateService = new RuntimeModelUpdateService(this);
    private final IModelChannelService channelService = new RuntimeModelChannelService(this);
    private final IAsyncRefreshableCtx refreshableCtxAdapter = new AsyncRefreshableCtxAdapter();
    int interval = 0;
    Timer timer = null;

    public RuntimeModel(IPeerNode peerNode) {
        this.setChangeEventsEnabled(true);
        this.suppressEventsOnNullParent = false;
        Assert.isNotNull((Object)peerNode);
        this.peerNode = peerNode;
        this.refreshableCtxAdapter.setQueryState(IAsyncRefreshableCtx.QueryType.CONTEXT, IAsyncRefreshableCtx.QueryState.DONE);
        ScopedEclipsePreferences prefs = CoreBundleActivator.getScopedPreferences();
        if (prefs.containsKey(String.valueOf(peerNode.getPeerId()) + ".autoRefreshInterval")) {
            this.setAutoRefreshInterval(prefs.getInt(String.valueOf(peerNode.getPeerId()) + ".autoRefreshInterval"));
        }
    }

    protected boolean checkThreadAccess() {
        return Protocol.isDispatchThread();
    }

    public void dispose() {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        this.disposed = true;
        this.channelService.closeChannel();
    }

    public boolean isDisposed() {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        return this.disposed;
    }

    public <V extends IModelService> V getService(Class<V> serviceInterface) {
        Assert.isNotNull(serviceInterface);
        return (V)((IModelService)this.getAdapter(serviceInterface));
    }

    public Object getAdapter(Class adapter) {
        if (IRuntimeModelRefreshService.class.equals((Object)adapter)) {
            return this.refreshService;
        }
        if (IModelRefreshService.class.equals((Object)adapter)) {
            return this.refreshService;
        }
        if (IRuntimeModelLookupService.class.equals((Object)adapter)) {
            return this.lookupService;
        }
        if (IModelLookupService.class.equals((Object)adapter)) {
            return this.lookupService;
        }
        if (IRuntimeModelUpdateService.class.equals((Object)adapter)) {
            return this.updateService;
        }
        if (IModelUpdateService.class.equals((Object)adapter)) {
            return this.updateService;
        }
        if (IModelChannelService.class.equals((Object)adapter)) {
            return this.channelService;
        }
        if (IAsyncRefreshableCtx.class.equals((Object)adapter)) {
            return this.refreshableCtxAdapter;
        }
        if (IPeerNode.class.isAssignableFrom(adapter) || IConnectable.class.isAssignableFrom(adapter)) {
            final AtomicReference peerNode = new AtomicReference();
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    peerNode.set(RuntimeModel.this.getPeerNode());
                }
            });
            return peerNode.get();
        }
        return super.getAdapter(adapter);
    }

    public void setFactory(IFactory factory) {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        this.factory = factory;
    }

    public IFactory getFactory() {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        return this.factory != null ? this.factory : Factory.getInstance();
    }

    public IPeerNode getPeerNode() {
        Assert.isTrue((boolean)this.checkThreadAccess(), (String)"Illegal Thread Access");
        return this.peerNode;
    }

    @Override
    public final void setAutoRefreshInterval(int interval) {
        if (interval < 0) {
            interval = 0;
        }
        int oldInterval = this.interval;
        this.interval = interval;
        if (oldInterval != interval) {
            ScopedEclipsePreferences prefs = CoreBundleActivator.getScopedPreferences();
            prefs.putInt(String.valueOf(this.peerNode.getPeerId()) + ".autoRefreshInterval", interval);
            if (interval != 0 && this.timer == null) {
                TimerTask task = new TimerTask(){

                    @Override
                    public void run() {
                        if (RuntimeModel.this.interval == 0) {
                            return;
                        }
                        RuntimeModel.this.doAutoRefresh();
                    }
                };
                this.timer = new Timer();
                this.timer.schedule(task, this.interval * 1000);
            } else if (interval == 0 && this.timer != null) {
                this.timer.cancel();
                this.timer = null;
            }
            this.fireChangeEvent("autoRefreshInterval", oldInterval, interval);
        }
    }

    @Override
    public final int getAutoRefreshInterval() {
        return this.interval;
    }

    void doAutoRefresh() {
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                RuntimeModel.this.getService(IRuntimeModelRefreshService.class).autoRefresh((ICallback)new Callback(){

                    protected void internalDone(Object caller, IStatus status) {
                        if ((this).RuntimeModel.this.interval > 0 && (this).RuntimeModel.this.timer != null) {
                            TimerTask task = new TimerTask(){

                                @Override
                                public void run() {
                                    if (((this).this).RuntimeModel.this.interval == 0) {
                                        return;
                                    }
                                    RuntimeModel.this.doAutoRefresh();
                                }
                            };
                            (this).RuntimeModel.this.timer.schedule(task, (this).RuntimeModel.this.interval * 1000);
                        }
                    }
                });
            }
        });
    }

    public String toString() {
        if (this.disposed) {
            return "*DISPOSED* : " + super.toString();
        }
        return super.toString();
    }
}

