/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.model.runtime.services;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.services.IProcesses;
import org.eclipse.tcf.services.ISysMonitor;
import org.eclipse.tcf.te.runtime.model.interfaces.IContainerModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.contexts.IAsyncRefreshableCtx;
import org.eclipse.tcf.te.runtime.services.ServiceUtils;
import org.eclipse.tcf.te.tcf.core.model.interfaces.IModel;
import org.eclipse.tcf.te.tcf.core.model.services.AbstractModelService;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.IProcessContextNode;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModelRefreshService;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModelUpdateService;
import org.eclipse.tcf.te.tcf.processes.core.model.runtime.services.RuntimeModelRefreshService;

public class RuntimeModelUpdateService
extends AbstractModelService<IRuntimeModel>
implements IRuntimeModelUpdateService {
    public RuntimeModelUpdateService(IRuntimeModel model) {
        super((IModel)model);
    }

    public void add(IModelNode node) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)node);
        ((IRuntimeModel)this.getModel()).add(node);
    }

    public void remove(IModelNode node) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)node);
        Assert.isNotNull((Object)node.getParent());
        node.getParent().remove(node, false);
    }

    @Override
    public void updateChildren(IContainerModelNode dst, IContainerModelNode src) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)dst);
        Assert.isNotNull((Object)src);
        boolean dstNodeChanged = this.__updateChildren(dst, src);
        if (dstNodeChanged) {
            dst.fireChangeEvent("changed", null, (Object)dst.getProperties());
        }
    }

    IProcessContextNode findInList(String id, List<IProcessContextNode> list) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)id);
        Assert.isNotNull(list);
        IProcessContextNode node = null;
        for (IProcessContextNode candidate : list) {
            if (!id.equals(candidate.getStringProperty("id"))) continue;
            node = candidate;
            break;
        }
        return node;
    }

    boolean __updateChildren(IContainerModelNode dst, IContainerModelNode src) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)dst);
        Assert.isNotNull((Object)src);
        boolean dstNodeChanged = false;
        IAsyncRefreshableCtx dstRefreshable = (IAsyncRefreshableCtx)dst.getAdapter(IAsyncRefreshableCtx.class);
        Assert.isNotNull((Object)dstRefreshable);
        IAsyncRefreshableCtx srcRefreshable = (IAsyncRefreshableCtx)src.getAdapter(IAsyncRefreshableCtx.class);
        Assert.isNotNull((Object)srcRefreshable);
        Assert.isTrue((srcRefreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CONTEXT) != IAsyncRefreshableCtx.QueryState.IN_PROGRESS ? 1 : 0) != 0, (String)("Context query of node '" + src.getName() + "' in progress while updating model."));
        if (srcRefreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CONTEXT) == IAsyncRefreshableCtx.QueryState.DONE && dstRefreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CONTEXT) != IAsyncRefreshableCtx.QueryState.DONE) {
            dstRefreshable.setQueryState(IAsyncRefreshableCtx.QueryType.CONTEXT, IAsyncRefreshableCtx.QueryState.DONE);
            dstNodeChanged |= true;
        }
        Assert.isTrue((srcRefreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST) != IAsyncRefreshableCtx.QueryState.IN_PROGRESS ? 1 : 0) != 0, (String)("Child list query of node '" + src.getName() + "' in progress while updating model."));
        if (srcRefreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST) == IAsyncRefreshableCtx.QueryState.DONE && dstRefreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST) != IAsyncRefreshableCtx.QueryState.DONE) {
            dstRefreshable.setQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST, IAsyncRefreshableCtx.QueryState.DONE);
            dstNodeChanged |= true;
        }
        if (srcRefreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CHILD_LIST) == IAsyncRefreshableCtx.QueryState.PENDING) {
            return dstNodeChanged;
        }
        List oldChildren = dst.getChildren(IProcessContextNode.class);
        boolean eventEnablementChanged = dst.setChangeEventsEnabled(false);
        List newChildren = src.getChildren(IProcessContextNode.class);
        for (IProcessContextNode candidate : newChildren) {
            String id = candidate.getStringProperty("id");
            if (id == null) continue;
            IProcessContextNode oldNode = this.findInList(id, oldChildren);
            if (oldNode != null) {
                oldChildren.remove(oldNode);
                dstNodeChanged |= this.__updateProperties(oldNode, candidate);
                IAsyncRefreshableCtx refreshable = (IAsyncRefreshableCtx)candidate.getAdapter(IAsyncRefreshableCtx.class);
                Assert.isNotNull((Object)refreshable);
                if (refreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CONTEXT) != IAsyncRefreshableCtx.QueryState.DONE) continue;
                dstNodeChanged |= this.__updateChildren(oldNode, candidate);
                continue;
            }
            if (candidate.getParent() == null) {
                dstNodeChanged |= dst.add((IModelNode)candidate);
                continue;
            }
            IProcessContextNode copy = (IProcessContextNode)((IRuntimeModel)this.getModel()).getFactory().newInstance(IProcessContextNode.class);
            this.__updateProperties(copy, candidate);
            IAsyncRefreshableCtx refreshable = (IAsyncRefreshableCtx)candidate.getAdapter(IAsyncRefreshableCtx.class);
            Assert.isNotNull((Object)refreshable);
            if (refreshable.getQueryState(IAsyncRefreshableCtx.QueryType.CONTEXT) == IAsyncRefreshableCtx.QueryState.DONE) {
                this.__updateChildren(copy, candidate);
            }
            dstNodeChanged |= dst.add((IModelNode)copy);
        }
        for (IProcessContextNode oldChild : oldChildren) {
            dstNodeChanged |= dst.remove((IModelNode)oldChild, false);
        }
        if (eventEnablementChanged) {
            dst.setChangeEventsEnabled(true);
        }
        return dstNodeChanged;
    }

    boolean __updateProperties(IProcessContextNode dst, IProcessContextNode src) {
        String[] candidates;
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)dst);
        Assert.isNotNull((Object)src);
        boolean eventEnablementChanged = dst.setChangeEventsEnabled(false);
        boolean dstNodeChanged = false;
        for (String key : src.getProperties().keySet()) {
            dstNodeChanged |= dst.setProperty(key, src.getProperty(key));
        }
        ArrayList<String> managedPropertyNames = new ArrayList<String>();
        managedPropertyNames.add("id");
        managedPropertyNames.add("name");
        IRuntimeModelRefreshService.IDelegate delegate = (IRuntimeModelRefreshService.IDelegate)ServiceUtils.getDelegateServiceDelegate((Object)dst, (Object)dst, IRuntimeModelRefreshService.IDelegate.class);
        if (delegate == null && ((IRuntimeModel)this.getModel()).getService(IRuntimeModelRefreshService.class) instanceof RuntimeModelRefreshService) {
            delegate = ((RuntimeModelRefreshService)((IRuntimeModel)this.getModel()).getService(IRuntimeModelRefreshService.class)).defaultDelegate;
        }
        if (delegate != null && (candidates = delegate.getManagedPropertyNames()) != null) {
            managedPropertyNames.addAll(Arrays.asList(candidates));
        }
        for (String managedPropertyName : managedPropertyNames) {
            if (!src.isProperty(managedPropertyName, null)) continue;
            dstNodeChanged |= dst.setProperty(managedPropertyName, null);
        }
        ISysMonitor.SysMonitorContext s1 = dst.getSysMonitorContext();
        ISysMonitor.SysMonitorContext s2 = src.getSysMonitorContext();
        if (s1 == null && s2 != null || s1 != null && s2 == null || s1 != null && !s1.equals(s2)) {
            dst.setSysMonitorContext(src.getSysMonitorContext());
            dstNodeChanged |= true;
        }
        IProcesses.ProcessContext p1 = dst.getProcessContext();
        IProcesses.ProcessContext p2 = src.getProcessContext();
        if (p1 == null && p2 != null || p1 != null && p2 == null || p1 != null && !p1.equals(p2)) {
            dst.setProcessContext(src.getProcessContext());
            dstNodeChanged |= true;
        }
        if (dst.getType() != src.getType()) {
            dst.setType(src.getType());
            dstNodeChanged |= true;
        }
        if (eventEnablementChanged) {
            dst.setChangeEventsEnabled(true);
        }
        return dstNodeChanged;
    }

    public void update(IModelNode dst, IModelNode src) {
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        Assert.isNotNull((Object)dst);
        Assert.isNotNull((Object)src);
        if (!(dst instanceof IProcessContextNode) || !(src instanceof IProcessContextNode)) {
            return;
        }
        String dstContextId = dst.getStringProperty("id");
        String srcContextId = src.getStringProperty("id");
        if (dstContextId == null && srcContextId != null || dstContextId != null && srcContextId == null || dstContextId != null && !dstContextId.equals(srcContextId)) {
            return;
        }
        boolean dstNodeChanged = this.__updateProperties((IProcessContextNode)dst, (IProcessContextNode)src);
        if (dst instanceof IContainerModelNode && src instanceof IContainerModelNode) {
            dstNodeChanged |= this.__updateChildren((IContainerModelNode)dst, (IContainerModelNode)src);
        }
        if (dstNodeChanged) {
            dst.fireChangeEvent("changed", null, null);
        }
    }
}

