/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.ui.internal;

import java.util.Arrays;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.tcf.te.runtime.persistence.history.HistoryManager;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IDelegateService;
import org.eclipse.tcf.te.runtime.services.interfaces.IService;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerNode;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.IDefaultContextService;
import org.eclipse.tcf.te.tcf.locator.model.ModelManager;
import org.eclipse.tcf.te.tcf.locator.utils.SimulatorUtils;
import org.eclipse.tcf.te.tcf.ui.handler.DeleteHandler;
import org.eclipse.tcf.te.tcf.ui.interfaces.IDefaultContextToolbarDelegate;
import org.eclipse.tcf.te.ui.views.navigator.nodes.NewWizardNode;

public class PropertyTester
extends org.eclipse.core.expressions.PropertyTester {
    private final DeleteHandler deleteHandler = new DeleteHandler();

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IStructuredSelection) {
            return this.testSelection((IStructuredSelection)receiver, property, args, expectedValue);
        }
        if ("canDelete".equals(property)) {
            return this.testSelection((IStructuredSelection)new StructuredSelection(receiver), property, args, expectedValue);
        }
        if ("hasHistory".equals(property) && receiver instanceof IPeerNode) {
            IService[] services;
            IPeerNode peerNode = (IPeerNode)receiver;
            IService[] iServiceArray = services = ServiceManager.getInstance().getServices((Object)peerNode, IDelegateService.class, false);
            int n = services.length;
            int n2 = 0;
            while (n2 < n) {
                String[] entries;
                IDefaultContextToolbarDelegate delegate;
                IService service = iServiceArray[n2];
                if (service instanceof IDelegateService && (delegate = (IDefaultContextToolbarDelegate)((IDelegateService)service).getDelegate((Object)peerNode, IDefaultContextToolbarDelegate.class)) != null && (entries = HistoryManager.getInstance().getHistory("org.eclipse.tcf.te.runtime.stepper.last_run_history_id@" + peerNode.getPeerId())) != null && entries.length > 0) {
                    return true;
                }
                ++n2;
            }
            return false;
        }
        if ("isWizardId".equals(property) && receiver instanceof NewWizardNode) {
            return ((NewWizardNode)receiver).getWizardId().equals(expectedValue);
        }
        if ("isValidSimulatorConfig".equals(property) && receiver instanceof IPeerNode && expectedValue instanceof Boolean) {
            boolean valid;
            SimulatorUtils.Result simulator = SimulatorUtils.getSimulatorService((IPeerNode)((IPeerNode)receiver));
            boolean bl = valid = simulator != null && simulator.service.isValidConfig(receiver, simulator.settings, true);
            return (Boolean)expectedValue == valid;
        }
        if ("canChangeDefaultContext".equals(property)) {
            IPeerNode defaultPeer = ((IDefaultContextService)ServiceManager.getInstance().getService(IDefaultContextService.class)).getDefaultContext(null);
            List<IPeerNode> peerNodes = Arrays.asList(ModelManager.getPeerModel().getPeerNodes());
            if (defaultPeer != null && peerNodes.contains(defaultPeer)) {
                return peerNodes.size() > 1;
            }
            return peerNodes.size() > 0;
        }
        return false;
    }

    protected boolean testSelection(IStructuredSelection selection, String property, Object[] args, Object expectedValue) {
        Assert.isNotNull((Object)selection);
        if ("canDelete".equals(property)) {
            return this.deleteHandler.canDelete((ISelection)selection);
        }
        return false;
    }
}

