/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.extension.factory;

import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNManager;
import org.eclipse.team.svn.core.operation.UnreportableException;

public interface ISVNConnectorFactory {
    public static final String DEFAULT_ID = "org.eclipse.team.svn.connector.svnkit17";
    public static final String CURRENT_COMPATIBILITY_VERSION = "3.0.0.I20150317-1700";
    public static final ISVNConnectorFactory EMPTY = new ISVNConnectorFactory(){

        public ISVNConnector createConnector() {
            throw new UnreportableException(this.getName());
        }

        public ISVNManager createManager() {
            throw new UnreportableException(this.getName());
        }

        public int getSupportedFeatures() {
            return 0;
        }

        public String getVersion() {
            return "";
        }

        public String getName() {
            return SVNMessages.getErrorString(this.getId());
        }

        public String getId() {
            return "Error_NoSVNClient";
        }

        public String getCompatibilityVersion() {
            return ISVNConnectorFactory.CURRENT_COMPATIBILITY_VERSION;
        }

        public String getClientVersion() {
            return "";
        }

        public int getSVNAPIVersion() {
            return -1;
        }
    };

    public ISVNConnector createConnector();

    public ISVNManager createManager();

    public String getId();

    public String getName();

    public String getVersion();

    public String getCompatibilityVersion();

    public String getClientVersion();

    public int getSupportedFeatures();

    public int getSVNAPIVersion();

    public static class APICompatibility {
        public static final int SVNAPI_NOT_SPECIFIED = -1;
        public static final int SVNAPI_1_0_x = 0;
        public static final int SVNAPI_1_1_x = 1;
        public static final int SVNAPI_1_2_x = 2;
        public static final int SVNAPI_1_3_x = 3;
        public static final int SVNAPI_1_4_x = 4;
        public static final int SVNAPI_1_5_x = 5;
        public static final int SVNAPI_1_6_x = 6;
        public static final int SVNAPI_1_7_x = 7;
        public static final int SVNAPI_1_8_x = 8;
    }

    public static class OptionalFeatures {
        public static final int NO_OPTIONAL_FEATURES = 0;
        public static final int ALL_OPTIONAL_FEATURES = -1;
        public static final int SSH_SETTINGS = 1;
        public static final int PROXY_SETTINGS = 2;
        public static final int ATOMIC_X_COMMIT = 4;
        public static final int CREATE_REPOSITORY_FSFS = 8;
        public static final int CREATE_REPOSITORY_BDB = 16;
        public static final int CREATE_REPOSITORY = 24;
    }
}

