/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.core.operation.local;

import java.util.HashSet;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.MultiRule;
import org.eclipse.team.core.RepositoryProvider;
import org.eclipse.team.svn.core.IConnectedProjectInformation;
import org.eclipse.team.svn.core.SVNMessages;
import org.eclipse.team.svn.core.connector.ISVNConnector;
import org.eclipse.team.svn.core.connector.ISVNProgressMonitor;
import org.eclipse.team.svn.core.connector.SVNDepth;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.IUnprotectedOperation;
import org.eclipse.team.svn.core.operation.SVNConflictDetectionProgressMonitor;
import org.eclipse.team.svn.core.operation.local.IUnresolvedConflictDetector;
import org.eclipse.team.svn.core.operation.local.UnresolvedConflictDetectorHelper;
import org.eclipse.team.svn.core.operation.remote.AbstractRepositoryOperation;
import org.eclipse.team.svn.core.resource.IRepositoryLocation;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.core.resource.IRepositoryResourceProvider;
import org.eclipse.team.svn.core.utility.FileUtility;
import org.eclipse.team.svn.core.utility.SVNUtility;

public class SwitchOperation
extends AbstractRepositoryOperation
implements IUnresolvedConflictDetector {
    protected IResource[] resources;
    protected SVNDepth depth;
    protected long options;
    protected UnresolvedConflictDetectorHelper conflictDetectorHelper;

    public SwitchOperation(IResource[] resources, IRepositoryResourceProvider destination, SVNDepth depth, boolean isStickyDepth, boolean ignoreExternals) {
        this(resources, destination, depth, (ignoreExternals ? 1L : 0L) | (isStickyDepth ? 16384L : 0L));
    }

    public SwitchOperation(IResource[] resources, IRepositoryResource[] destination, SVNDepth depth, boolean isStickyDepth, boolean ignoreExternals) {
        this(resources, destination, depth, (ignoreExternals ? 1L : 0L) | (isStickyDepth ? 16384L : 0L));
    }

    public SwitchOperation(IResource[] resources, IRepositoryResourceProvider destination, SVNDepth depth, long options) {
        super("Operation_Switch", SVNMessages.class, destination);
        this.resources = resources;
        this.depth = depth;
        this.options = options & 0x4003L;
        this.conflictDetectorHelper = new UnresolvedConflictDetectorHelper();
    }

    public SwitchOperation(IResource[] resources, IRepositoryResource[] destination, SVNDepth depth, long options) {
        super("Operation_Switch", SVNMessages.class, destination);
        this.resources = resources;
        this.depth = depth;
        this.options = options & 0x4003L;
        this.conflictDetectorHelper = new UnresolvedConflictDetectorHelper();
    }

    public int getOperationWeight() {
        return 19;
    }

    public ISchedulingRule getSchedulingRule() {
        HashSet<IResource> ruleSet = new HashSet<IResource>();
        int i = 0;
        while (i < this.resources.length) {
            ruleSet.add((IResource)(this.resources[i] instanceof IProject ? this.resources[i] : this.resources[i].getParent()));
            ++i;
        }
        return new MultiRule((ISchedulingRule[])ruleSet.toArray(new IResource[ruleSet.size()]));
    }

    protected void runImpl(IProgressMonitor monitor) throws Exception {
        IRepositoryResource[] destinations = this.operableData();
        int i = 0;
        while (i < this.resources.length) {
            final IResource resource = this.resources[i];
            final IRepositoryResource destination = destinations[i];
            final IRepositoryLocation location = destination.getRepositoryLocation();
            final ISVNConnector proxy = location.acquireSVNProxy();
            this.protectStep(new IUnprotectedOperation(){

                public void run(IProgressMonitor monitor) throws Exception {
                    String wcPath = FileUtility.getWorkingCopyPath(resource);
                    SwitchOperation.this.writeToConsole(0, "svn switch \"" + destination.getUrl() + "\" \"" + FileUtility.normalizePath(wcPath) + "\" -r " + destination.getSelectedRevision() + ISVNConnector.Options.asCommandLine(SwitchOperation.this.options) + SVNUtility.getDepthArg(SwitchOperation.this.depth, SwitchOperation.this.options) + FileUtility.getUsernameParam(location.getUsername()) + "\n");
                    proxy.switchTo(wcPath, SVNUtility.getEntryRevisionReference(destination), SwitchOperation.this.depth, SwitchOperation.this.options, new ConflictDetectionProgressMonitor(SwitchOperation.this, monitor, null));
                    if (resource instanceof IProject) {
                        IConnectedProjectInformation provider = (IConnectedProjectInformation)RepositoryProvider.getProvider((IProject)((IProject)resource));
                        provider.switchResource(destination);
                    }
                }
            }, monitor, this.resources.length);
            location.releaseSVNProxy(proxy);
            ++i;
        }
    }

    public void setUnresolvedConflict(boolean hasUnresolvedConflict) {
        this.conflictDetectorHelper.setUnresolvedConflict(hasUnresolvedConflict);
    }

    public boolean hasUnresolvedConflicts() {
        return this.conflictDetectorHelper.hasUnresolvedConflicts();
    }

    public String getMessage() {
        return this.conflictDetectorHelper.getMessage();
    }

    public IResource[] getUnprocessed() {
        return this.conflictDetectorHelper.getUnprocessed();
    }

    public IResource[] getProcessed() {
        return this.conflictDetectorHelper.getProcessed();
    }

    protected void defineInitialResourceSet(IResource[] resources) {
        this.conflictDetectorHelper.defineInitialResourceSet(resources);
    }

    public void addUnprocessed(IResource unprocessed) {
        this.conflictDetectorHelper.addUnprocessed(unprocessed);
    }

    public void setConflictMessage(String message) {
        this.conflictDetectorHelper.setConflictMessage(message);
    }

    public void removeProcessed(IResource resource) {
        this.conflictDetectorHelper.removeProcessed(resource);
    }

    protected class ConflictDetectionProgressMonitor
    extends SVNConflictDetectionProgressMonitor {
        public ConflictDetectionProgressMonitor(IActionOperation parent, IProgressMonitor monitor, IPath root) {
            super(parent, monitor, root);
        }

        protected void processConflict(ISVNProgressMonitor.ItemState state) {
            SwitchOperation.this.setUnresolvedConflict(true);
        }
    }
}

