/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.cache;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.eclipse.team.svn.revision.graph.cache.BytesUtility;
import org.eclipse.team.svn.revision.graph.cache.CacheChangedPath;

public class CacheRevision {
    protected long revision;
    protected int authorIndex;
    protected long date;
    protected int messageIndex;
    protected CacheChangedPath[] changedPaths = new CacheChangedPath[0];

    public CacheRevision(long revision, int authorIndex, long date, int messageIndex, CacheChangedPath[] changedPaths) {
        this.revision = revision;
        this.authorIndex = authorIndex;
        this.date = date;
        this.messageIndex = messageIndex;
        this.changedPaths = changedPaths;
    }

    public CacheRevision(byte[] bytes) {
        this.fromBytes(bytes);
    }

    public boolean hasChangedPaths() {
        return this.changedPaths.length > 0;
    }

    public CacheChangedPath[] getChangedPaths() {
        return this.changedPaths;
    }

    public long getRevision() {
        return this.revision;
    }

    public int getAuthorIndex() {
        return this.authorIndex;
    }

    public long getDate() {
        return this.date;
    }

    public int getMessageIndex() {
        return this.messageIndex;
    }

    protected final void fromBytes(byte[] bytes) {
        try {
            DataInputStream bytesIn = new DataInputStream(new ByteArrayInputStream(bytes));
            this.revision = bytesIn.readLong();
            this.date = bytesIn.readLong();
            this.authorIndex = bytesIn.readInt();
            this.messageIndex = bytesIn.readInt();
            int changedPathsCount = bytesIn.readInt();
            this.changedPaths = new CacheChangedPath[changedPathsCount];
            int i = 0;
            while (i < changedPathsCount) {
                byte[] pathBytes = BytesUtility.readBytesWithLength(bytesIn);
                this.changedPaths[i] = new CacheChangedPath(pathBytes);
                ++i;
            }
        }
        catch (IOException iOException) {}
    }

    public byte[] toBytes() {
        try {
            ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
            DataOutputStream revisionBytes = new DataOutputStream(byteArray);
            revisionBytes.writeLong(this.revision);
            revisionBytes.writeLong(this.date);
            revisionBytes.writeInt(this.authorIndex);
            revisionBytes.writeInt(this.messageIndex);
            revisionBytes.writeInt(this.changedPaths.length);
            CacheChangedPath[] cacheChangedPathArray = this.changedPaths;
            int n = this.changedPaths.length;
            int n2 = 0;
            while (n2 < n) {
                CacheChangedPath changedPath = cacheChangedPathArray[n2];
                byte[] pathBytes = changedPath.toBytes();
                BytesUtility.writeBytesWithLength(revisionBytes, pathBytes);
                ++n2;
            }
            return byteArray.toByteArray();
        }
        catch (IOException iOException) {
            return new byte[0];
        }
    }

    public String toString() {
        return String.valueOf(this.revision);
    }
}

