/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.revision.graph.graphic;

import java.util.HashSet;
import java.util.Set;
import org.eclipse.team.svn.revision.graph.PathRevision;
import org.eclipse.team.svn.revision.graph.graphic.RevisionNode;

public abstract class AbstractRevisionNodeFilter {
    public static AbstractRevisionNodeFilter ACCEPT_ALL_FILTER = new AbstractRevisionNodeFilter(){

        public boolean accept(RevisionNode node) {
            return true;
        }
    };
    public static AbstractRevisionNodeFilter SIMPLE_MODE_FILTER = new AbstractRevisionNodeFilter(){

        public boolean accept(RevisionNode node) {
            if (node.getAction() == PathRevision.RevisionNodeAction.MODIFY) {
                if (node.isNextCollapsed() || node.isPreviousCollapsed() || node.isCopiedFromCollapsed() || node.isCopiedToCollapsed() || node.isRenameCollapsed()) {
                    return true;
                }
                if (node.getCopiedTo().length == 0) {
                    return false;
                }
            }
            return true;
        }
    };

    public abstract boolean accept(RevisionNode var1);

    public static class AndRevisionNodeFilter
    extends AbstractRevisionNodeFilter {
        protected Set<AbstractRevisionNodeFilter> filters = new HashSet<AbstractRevisionNodeFilter>();

        public void addFilter(AbstractRevisionNodeFilter filter) {
            this.filters.add(filter);
        }

        public void removeFilter(AbstractRevisionNodeFilter filter) {
            this.filters.remove(filter);
        }

        public boolean accept(RevisionNode node) {
            if (!this.filters.isEmpty()) {
                for (AbstractRevisionNodeFilter filter : this.filters) {
                    if (filter.accept(node)) continue;
                    return false;
                }
            }
            return true;
        }
    }
}

