/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.svn.ui.panel.local;

import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.team.svn.core.connector.SVNConflictDescriptor;
import org.eclipse.team.svn.core.connector.SVNConflictVersion;
import org.eclipse.team.svn.core.operation.IActionOperation;
import org.eclipse.team.svn.core.operation.remote.GetLogMessagesOperation;
import org.eclipse.team.svn.core.resource.ILocalResource;
import org.eclipse.team.svn.core.resource.IRepositoryResource;
import org.eclipse.team.svn.ui.SVNUIMessages;
import org.eclipse.team.svn.ui.dialog.DefaultDialog;
import org.eclipse.team.svn.ui.panel.AbstractDialogPanel;
import org.eclipse.team.svn.ui.panel.common.SVNHistoryPanel;
import org.eclipse.team.svn.ui.panel.common.SelectRevisionPanel;
import org.eclipse.team.svn.ui.panel.local.EditTreeConflictsHelper;
import org.eclipse.team.svn.ui.utility.UIMonitorUtility;

public class EditTreeConflictsPanel
extends AbstractDialogPanel {
    protected ILocalResource local;
    protected EditTreeConflictsHelper helper;
    protected IActionOperation operation;
    protected Button localResolutionButton;
    protected Button remoteResolutionButton;
    protected Button manualResolutionButton;
    protected Button markAsMergedButton;

    public EditTreeConflictsPanel(ILocalResource local) {
        this.local = local;
        this.helper = new EditTreeConflictsHelper(this.local);
        this.dialogTitle = SVNUIMessages.EditTreeConflictsPanel_Title;
        this.dialogDescription = SVNUIMessages.EditTreeConflictsPanel_Description;
        this.defaultMessage = SVNUIMessages.EditTreeConflictsPanel_DefaultMessage;
    }

    protected void createControlsImpl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 1;
        GridData data = new GridData(1808);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        this.createConflictInfoControls(composite);
        this.createConflictResolutionControls(composite);
    }

    protected void createConflictInfoControls(Composite parent) {
        Group composite = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        GridData data = new GridData(768);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        composite.setText(SVNUIMessages.EditTreeConflictsPanel_ConlictInfo_Group);
        Label label = new Label((Composite)composite, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(SVNUIMessages.EditTreeConflictsPanel_Operation_Label);
        label = new Label((Composite)composite, 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(this.helper.getOperationAsString());
        label = new Label((Composite)composite, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(SVNUIMessages.EditTreeConflictsPanel_LocalStatus_Label);
        label = new Label((Composite)composite, 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(this.helper.getReasonAsString());
        label = new Label((Composite)composite, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(SVNUIMessages.EditTreeConflictsPanel_IncomingAction_Label);
        label = new Label((Composite)composite, 0);
        data = new GridData(768);
        data.horizontalSpan = 2;
        label.setLayoutData((Object)data);
        label.setText(this.helper.getActionAsString());
        label = new Label((Composite)composite, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(SVNUIMessages.EditTreeConflictsPanel_StartVersion_Label);
        label = new Label((Composite)composite, 0);
        label.setLayoutData((Object)new GridData());
        SVNConflictVersion cVersionLeft = this.local.getTreeConflictDescriptor().srcLeftVersion;
        SVNConflictVersion cVersionRight = this.local.getTreeConflictDescriptor().srcRightVersion;
        label.setText(SVNUIMessages.format((String)SVNUIMessages.EditTreeConflictsPanel_revision, (Object)String.valueOf(cVersionLeft != null ? cVersionLeft.pegRevision : -1L)));
        if (this.local.getTreeConflictDescriptor().operation == SVNConflictDescriptor.Operation.MERGE || this.local.getTreeConflictDescriptor().operation == SVNConflictDescriptor.Operation.SWITCHED) {
            Link leftLink = new Link((Composite)composite, 0);
            leftLink.setLayoutData((Object)new GridData(768));
            leftLink.setText("<a>" + this.helper.getSrcUrl(true) + "</a>");
            leftLink.addListener(13, new Listener(){

                public void handleEvent(Event event) {
                    EditTreeConflictsPanel.this.showHistoryPage(true);
                }
            });
        } else {
            label = new Label((Composite)composite, 0);
            label.setLayoutData((Object)new GridData(768));
            label.setText(this.helper.getSrcUrl(true));
        }
        label = new Label((Composite)composite, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(SVNUIMessages.EditTreeConflictsPanel_EndRevision_Label);
        label = new Label((Composite)composite, 0);
        label.setLayoutData((Object)new GridData());
        label.setText(SVNUIMessages.format((String)SVNUIMessages.EditTreeConflictsPanel_revision, (Object)String.valueOf(cVersionRight != null ? cVersionRight.pegRevision : -1L)));
        Link rightLink = new Link((Composite)composite, 0);
        rightLink.setLayoutData((Object)new GridData(768));
        rightLink.setText("<a>" + this.helper.getSrcUrl(false) + "</a>");
        rightLink.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EditTreeConflictsPanel.this.showHistoryPage(false);
            }
        });
    }

    protected void showHistoryPage(boolean isLeft) {
        boolean stopOnCopy = true;
        IRepositoryResource rr = this.helper.getRepositoryResourceForHistory(isLeft);
        SVNConflictVersion cVersionRight = this.local.getTreeConflictDescriptor().srcRightVersion;
        long currentRevision = cVersionRight != null ? cVersionRight.pegRevision : -1L;
        GetLogMessagesOperation msgsOp = SelectRevisionPanel.getMsgsOp(rr, stopOnCopy);
        if (!UIMonitorUtility.doTaskNowDefault(UIMonitorUtility.getShell(), (IActionOperation)msgsOp, true).isCancelled() && msgsOp.getExecutionState() == 0) {
            SVNHistoryPanel historyPanel = new SVNHistoryPanel(SVNUIMessages.SVNHistoryPanel_Title, SVNUIMessages.SVNHistoryPanel_Description, SVNUIMessages.SVNHistoryPanel_Message, msgsOp, true, false, currentRevision);
            DefaultDialog dialog = new DefaultDialog(UIMonitorUtility.getShell(), historyPanel);
            dialog.open();
        }
    }

    protected void createConflictResolutionControls(Composite parent) {
        Group composite = new Group(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        GridData data = new GridData(768);
        composite.setLayout((Layout)layout);
        composite.setLayoutData((Object)data);
        composite.setText(SVNUIMessages.EditTreeConflictsPanel_Conflict_Resolution_Group);
        String tip = this.helper.getTip();
        if (tip != null) {
            Label tipLabel = new Label((Composite)composite, 0);
            tipLabel.setLayoutData((Object)new GridData());
            tipLabel.setText(SVNUIMessages.EditTreeConflictsPanel_Tips_Label);
            tipLabel.setFont(JFaceResources.getFontRegistry().getBold("org.eclipse.jface.defaultfont"));
            Label tipValue = new Label((Composite)composite, 64);
            tipValue.setLayoutData((Object)new GridData(768));
            tipValue.setText(tip);
        }
        this.localResolutionButton = new Button((Composite)composite, 16);
        this.localResolutionButton.setLayoutData((Object)new GridData());
        this.localResolutionButton.setText(SVNUIMessages.EditTreeConflictsPanel_ApplyLocalChanges_Resolution);
        this.localResolutionButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EditTreeConflictsPanel.this.changeResolutionSelection();
            }
        });
        this.remoteResolutionButton = new Button((Composite)composite, 16);
        this.remoteResolutionButton.setLayoutData((Object)new GridData());
        this.remoteResolutionButton.setText(SVNUIMessages.EditTreeConflictsPanel_ApplyIncomigChanges_Resolution);
        this.remoteResolutionButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EditTreeConflictsPanel.this.changeResolutionSelection();
            }
        });
        this.manualResolutionButton = new Button((Composite)composite, 16);
        this.manualResolutionButton.setLayoutData((Object)new GridData());
        this.manualResolutionButton.setText(SVNUIMessages.EditTreeConflictsPanel_ManualResolution);
        this.manualResolutionButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                EditTreeConflictsPanel.this.changeResolutionSelection();
            }
        });
        this.markAsMergedButton = new Button((Composite)composite, 32);
        this.markAsMergedButton.setLayoutData((Object)new GridData());
        this.markAsMergedButton.setText(SVNUIMessages.EditTreeConflictsPanel_MarkAsMerged_Button);
    }

    public void postInit() {
        super.postInit();
        this.manualResolutionButton.setSelection(true);
        this.changeResolutionSelection();
    }

    protected void changeResolutionSelection() {
        if (this.localResolutionButton.getSelection()) {
            this.markAsMergedButton.setSelection(true);
            this.markAsMergedButton.setEnabled(false);
        } else if (this.manualResolutionButton.getSelection()) {
            this.markAsMergedButton.setSelection(false);
            this.markAsMergedButton.setEnabled(true);
        } else if (this.remoteResolutionButton.getSelection()) {
            this.markAsMergedButton.setSelection(true);
            this.markAsMergedButton.setEnabled(!this.helper.isRemoteOperationResolveTheConflict());
        }
    }

    protected void saveChangesImpl() {
        this.operation = this.helper.getOperation(this.remoteResolutionButton.getSelection(), this.localResolutionButton.getSelection(), this.markAsMergedButton.getSelection());
    }

    protected void cancelChangesImpl() {
        this.operation = null;
    }

    public IActionOperation getOperation() {
        return this.operation;
    }

    public String getHelpId() {
        return "org.eclipse.team.svn.help.editTreeConflictsContext";
    }
}

