/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.engine;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.config.Engine;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.thym.core.config.WidgetModel;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.engine.internal.cordova.CordovaEngineProvider;
import org.osgi.framework.Version;

public class HybridMobileEngineManager {
    private final HybridProject project;

    public HybridMobileEngineManager(HybridProject project) {
        this.project = project;
    }

    public HybridMobileEngine[] getActiveEngines() {
        try {
            WidgetModel model = WidgetModel.getModel(this.project);
            Widget w = model.getWidgetForRead();
            List<Engine> engines = null;
            if (w != null) {
                engines = w.getEngines();
            }
            if (engines == null || engines.isEmpty()) {
                HybridCore.log(1, "No engine information exists on config.xml. Falling back to default engines", null);
                return HybridMobileEngineManager.defaultEngines();
            }
            CordovaEngineProvider engineProvider = new CordovaEngineProvider();
            ArrayList<HybridMobileEngine> activeEngines = new ArrayList<HybridMobileEngine>();
            List<HybridMobileEngine> availableEngines = engineProvider.getAvailableEngines();
            block2: for (Engine engine : engines) {
                for (HybridMobileEngine hybridMobileEngine : availableEngines) {
                    if (!this.engineMatches(engine, hybridMobileEngine)) continue;
                    activeEngines.add(hybridMobileEngine);
                    continue block2;
                }
            }
            return activeEngines.toArray(new HybridMobileEngine[activeEngines.size()]);
        }
        catch (CoreException e) {
            HybridCore.log(2, "Engine information can not be read", e);
            HybridCore.log(2, "Could not determine the engines used", null);
            return new HybridMobileEngine[0];
        }
    }

    private boolean engineMatches(Engine configEngine, HybridMobileEngine engine) {
        if (engine.isManaged()) {
            return configEngine.getName() != null && configEngine.getName().equals(engine.getId()) && configEngine.getVersion() != null && configEngine.getVersion().equals(engine.getVersion());
        }
        return engine.getLocation().isValidPath(configEngine.getVersion()) && engine.getLocation().equals((Object)new Path(configEngine.getVersion()));
    }

    public static HybridMobileEngine[] defaultEngines() {
        CordovaEngineProvider engineProvider = new CordovaEngineProvider();
        List<HybridMobileEngine> availableEngines = engineProvider.getAvailableEngines();
        if (availableEngines == null || availableEngines.isEmpty()) {
            return new HybridMobileEngine[0];
        }
        ArrayList<HybridMobileEngine> defaults = new ArrayList<HybridMobileEngine>();
        String pref = Platform.getPreferencesService().getString("org.eclipse.thym.ui", "default_engine", null, null);
        if (pref != null && !pref.isEmpty()) {
            String[] engineStrings;
            String[] stringArray = engineStrings = pref.split(",");
            int n = engineStrings.length;
            int n2 = 0;
            while (n2 < n) {
                String engineString = stringArray[n2];
                String[] engineInfo = engineString.split(":");
                for (HybridMobileEngine hybridMobileEngine : availableEngines) {
                    if (!engineInfo[0].equals(hybridMobileEngine.getId()) || !engineInfo[1].equals(hybridMobileEngine.getVersion())) continue;
                    defaults.add(hybridMobileEngine);
                }
                ++n2;
            }
        } else {
            HashMap<String, HybridMobileEngine> platforms = new HashMap<String, HybridMobileEngine>();
            for (HybridMobileEngine hybridMobileEngine : availableEngines) {
                if (platforms.containsKey(hybridMobileEngine.getId())) {
                    HybridMobileEngine existing = (HybridMobileEngine)platforms.get(hybridMobileEngine.getId());
                    try {
                        Version ev = Version.parseVersion((String)existing.getVersion());
                        Version hv = Version.parseVersion((String)hybridMobileEngine.getVersion());
                        if (hv.compareTo(ev) <= 0) continue;
                        platforms.put(hybridMobileEngine.getId(), hybridMobileEngine);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                    continue;
                }
                platforms.put(hybridMobileEngine.getId(), hybridMobileEngine);
            }
            defaults.addAll(platforms.values());
        }
        return defaults.toArray(new HybridMobileEngine[defaults.size()]);
    }

    public void updateEngines(HybridMobileEngine[] engines) throws CoreException {
        WidgetModel model = WidgetModel.getModel(this.project);
        Widget w = model.getWidgetForEdit();
        List<Engine> existingEngines = w.getEngines();
        if (existingEngines != null) {
            for (Engine existingEngine : existingEngines) {
                w.removeEngine(existingEngine);
            }
        }
        HybridMobileEngine[] hybridMobileEngineArray = engines;
        int n = engines.length;
        int n2 = 0;
        while (n2 < n) {
            HybridMobileEngine engine = hybridMobileEngineArray[n2];
            Engine e = model.createEngine(w);
            e.setName(engine.getId());
            if (!engine.isManaged()) {
                e.setVersion(engine.getLocation().toString());
            } else {
                e.setVersion(engine.getVersion());
            }
            w.addEngine(e);
            ++n2;
        }
        model.save();
    }
}

