/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.platform;

import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.thym.core.HybridCore;
import org.eclipse.thym.core.HybridMobileStatus;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.engine.HybridMobileEngine;
import org.eclipse.thym.core.engine.HybridMobileLibraryResolver;
import org.eclipse.thym.core.internal.util.FileUtils;
import org.eclipse.thym.core.plugin.CordovaPluginManager;
import org.eclipse.thym.core.plugin.FileOverwriteCallback;
import org.osgi.framework.Bundle;

public abstract class AbstractProjectGeneratorDelegate {
    private static final String ASSEMBLY_ROOT = "/proj_gen/";
    private IProject project;
    private File generationRoot;
    private String platform;

    public void init(IProject project, File generationFolder, String platformID) {
        this.project = project;
        this.generationRoot = generationFolder;
        this.platform = platformID;
        if (this.generationRoot == null) {
            this.generationRoot = new File(this.getTempGenerationDirectory(), project.getName());
        }
    }

    public File generateNow(IProgressMonitor monitor) throws CoreException {
        if (this.project == null || this.generationRoot == null) {
            throw new IllegalStateException("Project generator delegate is not initialized properly");
        }
        long start = System.currentTimeMillis();
        try {
            try {
                IStatus libStatus;
                if (!this.generationRoot.exists() && !this.generationRoot.mkdirs()) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", NLS.bind((String)"Can not create the destination directory for project generation at {0}", (Object)this.generationRoot.toString())));
                }
                monitor.beginTask(NLS.bind((String)"Generate Native Project for {0}", (Object)this.getProjectName()), 50);
                HybridProject hybridProject = HybridProject.getHybridProject(this.getProject());
                if (hybridProject == null) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", NLS.bind((String)"Project {0} is missing or not a Hybrid Mobile project", (Object)this.getProjectName())));
                }
                HybridMobileEngine[] engine = hybridProject.getActiveEngines();
                if (engine == null || engine.length < 1) {
                    throw new CoreException((IStatus)HybridMobileStatus.newMissingEngineStatus(this.project, "Hybrid Mobile Engine is missing. Please install the missing engine or use a different engine."));
                }
                HybridMobileEngine theEngine = null;
                HybridMobileEngine[] hybridMobileEngineArray = engine;
                int n = engine.length;
                int n2 = 0;
                while (n2 < n) {
                    HybridMobileEngine eng = hybridMobileEngineArray[n2];
                    if (eng.getId().equals(this.getTargetShortName())) {
                        theEngine = eng;
                    }
                    ++n2;
                }
                if (theEngine == null) {
                    throw new CoreException((IStatus)HybridMobileStatus.newMissingEngineStatus(this.getProject(), NLS.bind((String)"Project {0} does not have any engines with {1} support installed.", (Object[])new Object[]{this.getProject().getName(), this.getTargetShortName()})));
                }
                HybridMobileLibraryResolver resolver = theEngine.getResolver();
                if (resolver == null) {
                    throw new CoreException((IStatus)HybridMobileStatus.newMissingEngineStatus(this.getProject(), NLS.bind((String)"Active Hybrid Mobile Engine can not support {0}.", (Object)this.getTargetShortName())));
                }
                if (resolver.needsPreCompilation()) {
                    resolver.preCompile(monitor);
                }
                if (!(libStatus = resolver.isLibraryConsistent()).isOK()) {
                    throw new CoreException((IStatus)HybridMobileStatus.newMissingEngineStatus(this.project, "Active Hybrid Mobile Engine is missing or not compatible. Please install or use a different engine."));
                }
                this.generateNativeFiles(resolver);
                monitor.worked(10);
                IFolder folder = this.getProject().getFolder("/www");
                if (!folder.isAccessible()) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "www folder is missing. Can not generate target project without www directory"));
                }
                File targetWWW = this.getPlatformWWWDirectory();
                Assert.isNotNull((Object)targetWWW, (String)"Platform implementation must return a file location for www directory");
                if (!targetWWW.exists() && !targetWWW.mkdirs()) {
                    throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", " Unable to create www directory for native project "));
                }
                this.copyResource((IResource)folder, folder.getFullPath(), targetWWW);
                monitor.worked(10);
                folder = this.getProject().getFolder("/merges/" + this.getTargetShortName());
                if (folder.exists()) {
                    this.copyResource((IResource)folder, folder.getFullPath(), targetWWW);
                }
                monitor.worked(10);
                File configDestination = new File(targetWWW, "config.xml");
                if (!configDestination.exists()) {
                    File sourceFile = hybridProject.getConfigFile().getLocation().toFile();
                    FileUtils.fileCopy(FileUtils.toURL(sourceFile), FileUtils.toURL(configDestination));
                }
                this.replaceCordovaPlatformFiles(resolver);
                this.completeCordovaPluginInstallations(monitor);
            }
            catch (IOException e) {
                throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", " Unable to generate native project ", (Throwable)e));
            }
        }
        finally {
            monitor.done();
        }
        HybridCore.trace(String.valueOf(this.getTargetShortName()) + " project generated in " + Long.toString(System.currentTimeMillis() - start) + " ms.");
        return this.getDestination();
    }

    private void copyResource(IResource resource, IPath workspaceRoot, File root) throws IOException {
        if (!resource.isAccessible()) {
            return;
        }
        File destinationFile = this.createDestinationFile(resource, workspaceRoot, root);
        if (resource.getType() == 1) {
            File sourceFile = resource.getLocation().toFile();
            FileUtils.fileCopy(FileUtils.toURL(sourceFile), FileUtils.toURL(destinationFile));
        } else {
            IContainer container = (IContainer)resource;
            IResource[] children = null;
            try {
                children = container.members();
            }
            catch (CoreException e) {
                HybridCore.log(4, "Copying resources to generated project", e);
            }
            destinationFile.mkdir();
            if (children != null) {
                IResource[] iResourceArray = children;
                int n = children.length;
                int n2 = 0;
                while (n2 < n) {
                    IResource child = iResourceArray[n2];
                    this.copyResource(child, workspaceRoot, root);
                    ++n2;
                }
            }
        }
    }

    private File createDestinationFile(IResource resource, IPath workspaceRoot, File root) {
        return new File(root, resource.getFullPath().makeRelativeTo(workspaceRoot).toOSString());
    }

    protected void completeCordovaPluginInstallations(IProgressMonitor monitor) throws CoreException {
        HybridProject project = HybridProject.getHybridProject(this.getProject());
        if (project == null) {
            return;
        }
        CordovaPluginManager pluginManager = new CordovaPluginManager(project);
        pluginManager.completePluginInstallationsForPlatform(this.getDestination(), this.getTargetShortName(), new FileOverwriteCallback(){

            @Override
            public boolean isOverwiteAllowed(String[] files) {
                return true;
            }
        }, monitor);
    }

    protected abstract void generateNativeFiles(HybridMobileLibraryResolver var1) throws CoreException;

    protected String getTargetShortName() {
        return this.platform;
    }

    protected abstract void replaceCordovaPlatformFiles(HybridMobileLibraryResolver var1) throws IOException;

    protected abstract File getPlatformWWWDirectory();

    public File getDestination() {
        return new File(this.generationRoot, this.getTargetShortName());
    }

    protected String getProjectName() {
        return this.project.getName();
    }

    protected IProject getProject() {
        return this.project;
    }

    protected File getTempGenerationDirectory() {
        Bundle bundle = HybridCore.getContext().getBundle();
        return bundle.getDataFile(ASSEMBLY_ROOT);
    }
}

