/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.plugin.actions;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.thym.core.platform.IPluginInstallationAction;

public class CreateFileAction
implements IPluginInstallationAction {
    private File target;
    private String content;

    public CreateFileAction(String content, File target) {
        this.content = content;
        this.target = target;
    }

    @Override
    public void install() throws CoreException {
        try {
            FileUtils.copyInputStreamToFile((InputStream)new ByteArrayInputStream(this.content.getBytes()), (File)this.target);
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Error while creating file " + this.target, (Throwable)e));
        }
    }

    @Override
    public void unInstall() throws CoreException {
        if (this.target.exists() && !this.target.delete()) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.thym.core", "Unable to delete file " + this.target));
        }
    }

    @Override
    public String[] filesToOverwrite() {
        if (this.target.exists()) {
            return new String[]{this.target.toString()};
        }
        return new String[0];
    }
}

