/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.plugin.actions;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.thym.core.HybridProject;
import org.eclipse.thym.core.config.Feature;
import org.eclipse.thym.core.config.Widget;
import org.eclipse.thym.core.config.WidgetModel;
import org.eclipse.thym.core.platform.IPluginInstallationAction;

public class PluginInstallRecordAction
implements IPluginInstallationAction {
    private final HybridProject project;
    private final String pluginName;
    private final Map<String, String> parameters;
    private static final String[] INSTALL_RECORD_PARAMS = new String[]{"id", "version", "url", "installPath"};

    public PluginInstallRecordAction(HybridProject project, String pluginName, Map<String, String> parameters) {
        this.project = project;
        this.pluginName = pluginName;
        this.parameters = parameters;
    }

    @Override
    public void install() throws CoreException {
        WidgetModel widgetModel = WidgetModel.getModel(this.project);
        Widget widget = widgetModel.getWidgetForEdit();
        Feature feature = this.getExistingFeature(widget);
        if (feature == null) {
            feature = widgetModel.createFeature(widget);
            feature.setName(this.pluginName);
            widget.addFeature(feature);
        }
        String[] stringArray = INSTALL_RECORD_PARAMS;
        int n = INSTALL_RECORD_PARAMS.length;
        int n2 = 0;
        while (n2 < n) {
            String key = stringArray[n2];
            if (feature.getParams().containsKey(key)) {
                feature.removeParam(key);
            }
            ++n2;
        }
        Set<String> keys = this.parameters.keySet();
        for (String paramName : keys) {
            if (feature.getParams().containsKey(paramName)) {
                feature.removeParam(paramName);
            }
            feature.addParam(paramName, this.parameters.get(paramName));
        }
        widgetModel.save();
    }

    private Feature getExistingFeature(Widget widget) {
        List<Feature> features = widget.getFeatures();
        if (features == null) {
            return null;
        }
        for (Feature feature : features) {
            if (!feature.getName().equals(this.pluginName)) continue;
            return feature;
        }
        return null;
    }

    @Override
    public String[] filesToOverwrite() {
        return new String[0];
    }

    @Override
    public void unInstall() throws CoreException {
        WidgetModel widgetModel = WidgetModel.getModel(this.project);
        Widget widget = widgetModel.getWidgetForEdit();
        Feature feature = this.getExistingFeature(widget);
        if (feature != null) {
            widget.removeFeature(feature);
        }
        widgetModel.save();
    }
}

