/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.core.plugin.registry;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.thym.core.plugin.registry.CordovaRegistryPluginInfo;

public class CordovaRegistryPlugin
extends CordovaRegistryPluginInfo {
    private List<RegistryPluginVersion> versions;
    private List<String> keywords;
    private Map<String, String> maintainers;
    private String latestVersion;
    private String license;

    public List<RegistryPluginVersion> getVersions() {
        return this.versions;
    }

    public void addVersion(RegistryPluginVersion version) {
        if (this.versions == null) {
            this.versions = new ArrayList<RegistryPluginVersion>();
        }
        this.versions.add(version);
    }

    public RegistryPluginVersion getVersion(String version) {
        if (this.versions == null) {
            return null;
        }
        for (RegistryPluginVersion ver : this.versions) {
            if (!ver.getVersionNumber().equals(version)) continue;
            return ver;
        }
        return null;
    }

    public List<String> getKeywords() {
        return this.keywords;
    }

    public void addKeyword(String keyword) {
        if (this.keywords == null) {
            this.keywords = new ArrayList<String>();
        }
        this.keywords.add(keyword);
    }

    public void addMaintainer(String email, String name) {
        if (this.maintainers == null) {
            this.maintainers = new HashMap<String, String>();
        }
        this.maintainers.put(email, name);
    }

    public Map<String, String> getMaintainers() {
        return this.maintainers;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
    }

    public String getLicense() {
        return this.license;
    }

    public void setLicense(String license) {
        this.license = license;
    }

    public class RegistryPluginVersion {
        private String versionNumber;
        private String tarball;
        private String shasum;

        public String getVersionNumber() {
            return this.versionNumber;
        }

        public void setVersionNumber(String versionNumber) {
            this.versionNumber = versionNumber;
        }

        public String getName() {
            return CordovaRegistryPlugin.this.getName();
        }

        public String getTarball() {
            return this.tarball;
        }

        public void setTarball(String tarball) {
            this.tarball = tarball;
        }

        public String getShasum() {
            return this.shasum;
        }

        public void setShasum(String shasum) {
            this.shasum = shasum;
        }
    }
}

