/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ios.core.pbxproject;

import org.eclipse.thym.ios.core.pbxproject.PBXProject;

public class PBXFile {
    private static final String M_EXTENSION = ".m";
    private static final String SOURCE_FILE = "sourcecode.c.objc";
    private static final String H_EXTENSION = ".h";
    private static final String HEADER_FILE = "sourcecode.c.h";
    private static final String BUNDLE_EXTENSION = ".bundle";
    private static final String BUNDLE = "\"wrapper.plug-in\"";
    private static final String XIB_EXTENSION = ".xib";
    private static final String XIB_FILE = "file.xib";
    private static final String DYLIB_EXTENSION = ".dylib";
    private static final String DYLIB = "\"compiled.mach-o.dylib\"";
    private static final String FRAMEWORK_EXTENSION = ".framework";
    private static final String FRAMEWORK = "wrapper.framework";
    private static final String ARCHIVE_EXTENSION = ".a";
    private static final String ARCHIVE = "archive.ar";
    private String path;
    private String lastType;
    private String sourceTree;
    private String encoding;
    private String compilerFlags;
    private String group;
    private String fileRef;
    private String uuid;
    private boolean weak;
    private boolean isFramework;
    private boolean isPlugin;

    public PBXFile(String path) {
        this(path, PBXFile.guessLastType(path));
    }

    public PBXFile(String path, String lastType) {
        this.lastType = lastType;
        this.path = path;
    }

    public String getPath() {
        if (this.getLastType().equals(FRAMEWORK)) {
            return "System/Library/Frameworks/" + this.path;
        }
        if (this.getLastType().equals(DYLIB)) {
            return "usr/lib/" + this.path;
        }
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public String getLastType() {
        return this.lastType;
    }

    public void setLastType(String lastType) {
        this.lastType = lastType;
    }

    public String getSourceTree() {
        if (this.sourceTree == null) {
            if (DYLIB.equals(this.getLastType()) || FRAMEWORK.equals(this.getLastType())) {
                return "SDKROOT";
            }
            return "<group>";
        }
        return this.sourceTree;
    }

    public void setSourceTree(String sourceTree) {
        this.sourceTree = sourceTree;
    }

    public String getEncoding() {
        if (this.encoding == null && !BUNDLE.equals(this.getLastType())) {
            return "4";
        }
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getCompilerFlags() {
        return this.compilerFlags;
    }

    public void setCompilerFlags(String compilerFlags) {
        this.compilerFlags = compilerFlags;
    }

    public boolean isWeak() {
        return this.weak;
    }

    public void setWeak(boolean weak) {
        this.weak = weak;
    }

    public String getGroup() {
        if (this.group == null) {
            if (SOURCE_FILE.equals(this.getLastType())) {
                return "Sources";
            }
            if (DYLIB.equals(this.getLastType()) || ARCHIVE.equals(this.getLastType())) {
                return "Frameworks";
            }
            return "Resources";
        }
        return this.group;
    }

    public void setGroup(String group) {
        this.group = group;
    }

    public String getFileRef() {
        if (this.fileRef == null) {
            this.fileRef = PBXProject.generateReference();
        }
        return this.fileRef;
    }

    public void setFileRef(String fileRef) {
        this.fileRef = fileRef;
    }

    public String getUuid() {
        if (this.uuid == null) {
            this.uuid = PBXProject.generateReference();
        }
        return this.uuid;
    }

    public void setUuid(String uuid) {
        this.uuid = uuid;
    }

    public boolean isFramework() {
        return this.isFramework;
    }

    public void setFramework(boolean isFramework) {
        this.isFramework = isFramework;
    }

    public boolean isPlugin() {
        return this.isPlugin;
    }

    public void setPlugin(boolean isPlugin) {
        this.isPlugin = isPlugin;
    }

    public boolean hasSettings() {
        return this.isWeak() || this.getCompilerFlags() != null;
    }

    private static String guessLastType(String file) {
        if (file == null) {
            return null;
        }
        if (file.endsWith(M_EXTENSION)) {
            return SOURCE_FILE;
        }
        if (file.endsWith(H_EXTENSION)) {
            return HEADER_FILE;
        }
        if (file.endsWith(BUNDLE_EXTENSION)) {
            return BUNDLE;
        }
        if (file.endsWith(XIB_EXTENSION)) {
            return XIB_FILE;
        }
        if (file.endsWith(DYLIB_EXTENSION)) {
            return DYLIB;
        }
        if (file.endsWith(FRAMEWORK_EXTENSION)) {
            return FRAMEWORK;
        }
        if (file.endsWith(ARCHIVE_EXTENSION)) {
            return ARCHIVE;
        }
        return "unknown";
    }
}

