/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui;

import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Image;
import org.eclipse.thym.ui.HybridUI;

public class PlatformImage {
    private static final String ATTR_ICON = "icon";
    public static final String ATTR_PLATFORM_SUPPORT = "platformSupport";
    public static final String ATTR_PROJECT_BUILDER = "projectBuilder";
    public static final String EXTENSION_POINT_ID = "org.eclipse.thym.ui.platformImages";
    public static final String IMAGE_REG_BASE = "org.eclipse.thym.ui.platformImage";
    private ImageDescriptor icon;
    private String projectGeneratorID;
    private String projectBuilderID;

    PlatformImage(IConfigurationElement configurationElement) {
        String iconPath = configurationElement.getAttribute(ATTR_ICON);
        this.icon = HybridUI.getImageDescriptor(configurationElement.getContributor().getName(), iconPath);
        this.projectGeneratorID = configurationElement.getAttribute(ATTR_PLATFORM_SUPPORT);
        this.projectBuilderID = configurationElement.getAttribute(ATTR_PROJECT_BUILDER);
    }

    public ImageDescriptor getIcon() {
        return this.icon;
    }

    public String getProjectGeneratorID() {
        return this.projectGeneratorID;
    }

    public String getProjectBuilderID() {
        return this.projectBuilderID;
    }

    public static ImageDescriptor getIconFor(String attribute, String id) {
        List<PlatformImage> images = HybridUI.getPlatformImages();
        for (PlatformImage platformImage : images) {
            if (attribute.equals(ATTR_PLATFORM_SUPPORT) && id.equals(platformImage.getProjectGeneratorID())) {
                return platformImage.getIcon();
            }
            if (!attribute.equals(ATTR_PROJECT_BUILDER) || !id.equals(platformImage.getProjectBuilderID())) continue;
            return platformImage.getIcon();
        }
        return null;
    }

    public static Image getImageFor(String attribute, String id) {
        String key = IMAGE_REG_BASE + attribute + id;
        ImageRegistry imageRegistry = JFaceResources.getImageRegistry();
        Image image = imageRegistry.get(key);
        if (image == null) {
            ImageDescriptor desc = PlatformImage.getIconFor(attribute, id);
            if (desc == null) {
                return null;
            }
            imageRegistry.put(key, PlatformImage.getIconFor(attribute, id));
            image = imageRegistry.get(key);
        }
        return image;
    }
}

