/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.thym.ui.config.internal;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.swt.widgets.Display;
import org.eclipse.thym.ui.config.internal.ConfigEditor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.wst.validation.internal.provisional.core.IReporter;
import org.eclipse.wst.validation.internal.provisional.core.IValidationContext;
import org.eclipse.wst.validation.internal.provisional.core.IValidator;

public class ReconcilingStrategy
implements IValidator {
    public void cleanup(IReporter reporter) {
    }

    public void validate(IValidationContext helper, IReporter reporter) {
        ConfigEditor editor = this.getConfigEditor(helper);
        if (editor == null) {
            return;
        }
        editor.getWidgetModel().reloadEditableWidget();
    }

    private ConfigEditor getConfigEditor(IValidationContext helper) {
        String[] path = helper.getURIs();
        if (path.length == 0) {
            return null;
        }
        IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(path[0]));
        if (file == null) {
            return null;
        }
        IEditorPart editor = this.getEditor((IEditorInput)new FileEditorInput(file));
        if (editor == null) {
            return null;
        }
        if (!(editor instanceof ConfigEditor)) {
            return null;
        }
        return (ConfigEditor)editor;
    }

    private IEditorPart getEditor(final IEditorInput editorInput) {
        final IEditorPart[] editor = new IEditorPart[1];
        Display.getDefault().syncExec(new Runnable(){

            @Override
            public void run() {
                IEditorReference[] refs;
                IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
                if (activePage != null && (refs = activePage.findEditors(editorInput, "org.eclipse.thym.ui.config.internal.ConfigEditor", 3)).length > 0) {
                    editor[0] = refs[0].getEditor(true);
                }
            }
        });
        return editor[0];
    }
}

